/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.property.OperandExpression;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProductExpression;
import io.sf.carte.doc.style.css.property.StyleExpression;
import io.sf.carte.doc.style.css.property.SumExpression;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class ExpressionValue
extends PrimitiveValue
implements CSSExpressionValue {
    private StyleExpression expression = null;
    private boolean roundResult = false;

    public ExpressionValue() {
        super((short)101);
    }

    protected ExpressionValue(ExpressionValue copied) {
        super(copied);
        this.expression = copied.expression.clone();
    }

    @Override
    ExpressionLexicalSetter newLexicalSetter() {
        return new ExpressionLexicalSetter();
    }

    private StyleExpression addOperand(StyleExpression expression, OperandExpression operand) {
        if (expression == null) {
            expression = operand;
        } else {
            if (expression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                throw new DOMException(5, "Bad expression");
            }
            expression.addExpression(operand);
        }
        return expression;
    }

    protected boolean isInvalidOperand(PrimitiveValue primi, short lutype, short lastlutype) {
        if (this.isOperatorType(lutype)) {
            return this.isOperatorType(lastlutype);
        }
        return !this.isOperatorType(lastlutype) && lastlutype != -1 && lutype != 0;
    }

    private boolean isOperatorType(short lutype) {
        switch (lutype) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public CSSExpression getExpression() {
        return this.expression;
    }

    @Override
    public String getStringValue() throws DOMException {
        return "";
    }

    @Override
    public String getCssText() {
        String s = this.expression.getCssText();
        if (this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length() + 2);
        buf.append('(').append(s).append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        String s = this.expression.getMinifiedCssText();
        if (this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length() + 2);
        buf.append('(').append(s).append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        if (this.expression.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
            this.expression.writeCssText(wri);
        } else {
            wri.write('(');
            this.expression.writeCssText(wri);
            wri.write(')');
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "The value of this property cannot be modified.");
    }

    @Override
    public void setExpectInteger() {
        this.roundResult = true;
    }

    boolean mustRoundResult() {
        return this.roundResult;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionValue other = (ExpressionValue)obj;
        return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
    }

    @Override
    public ExpressionValue clone() {
        return new ExpressionValue(this);
    }

    class ExpressionLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        ExpressionLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) throws DOMException {
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
            this.setLexicalUnitFromSubValues(lunit.getParameters());
        }

        void setLexicalUnitFromSubValues(LexicalUnit lunit) throws DOMException {
            ExpressionValue.this.expression = this.fillExpressionLevel(lunit, new ValueFactory());
            if (ExpressionValue.this.expression == null) {
                throw new DOMException(12, "Void expression");
            }
        }

        private StyleExpression fillExpressionLevel(LexicalUnit lu, ValueFactory factory) {
            StyleExpression expression = null;
            short lastlutype = -1;
            block9: while (lu != null) {
                boolean inverse = false;
                short lutype = lu.getLexicalUnitType();
                switch (lutype) {
                    case 2: {
                        inverse = true;
                    }
                    case 1: {
                        StyleExpression operation;
                        if (expression == null) {
                            if (inverse) {
                                expression = new SumExpression();
                                expression.nextOperandInverse = true;
                                break;
                            }
                            throw new DOMException(5, "Missing operand");
                        }
                        if (expression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                            operation = new SumExpression();
                            operation.addExpression(expression);
                            operation.nextOperandInverse = inverse;
                            expression = operation;
                            break;
                        }
                        if (expression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                            expression.nextOperandInverse = inverse;
                            break;
                        }
                        StyleExpression parent = expression.getParentExpression();
                        if (parent == null) {
                            operation = new SumExpression();
                            operation.addExpression(expression);
                            operation.nextOperandInverse = inverse;
                            expression = operation;
                            break;
                        }
                        expression = parent;
                        expression.nextOperandInverse = inverse;
                        break;
                    }
                    case 4: {
                        inverse = true;
                    }
                    case 3: {
                        StyleExpression operation;
                        if (expression == null) {
                            throw new DOMException(5, "Missing factor");
                        }
                        if (expression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                            operation = new ProductExpression();
                            operation.addExpression(expression);
                            operation.nextOperandInverse = inverse;
                            expression = operation;
                            break;
                        }
                        if (expression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                            operation = new ProductExpression();
                            if (lastlutype != 40) {
                                expression.replaceLastExpression(operation);
                            } else {
                                operation.addExpression(expression);
                            }
                            operation.nextOperandInverse = inverse;
                            expression = operation;
                            break;
                        }
                        expression.nextOperandInverse = inverse;
                        break;
                    }
                    case 40: {
                        LexicalUnit subval = lu.getSubValues();
                        if (subval == null) {
                            throw new DOMException(12, "Empty sub-expression");
                        }
                        StyleExpression subexpr = this.fillExpressionLevel(subval, factory);
                        if (subexpr != null) {
                            if (expression != null) {
                                expression.addExpression(subexpr);
                                if (expression.getPartType() != CSSExpression.AlgebraicPart.SUM) break;
                                expression = subexpr;
                                break;
                            }
                            expression = subexpr;
                            break;
                        }
                        throw new DOMException(5, "Bad subexpression");
                    }
                    case 0: {
                        if (this.nextLexicalUnit != null || expression.getParentExpression() != null) {
                            throw new DOMException(5, "Bad operand: ','");
                        }
                        this.nextLexicalUnit = lu;
                        return expression;
                    }
                    case 41: {
                        StyleExpression subexpr;
                        LexicalUnit subval;
                        String funcname = lu.getFunctionName();
                        if (funcname.equals(ExpressionValue.this.getStringValue())) {
                            lutype = 40;
                            subval = lu.getParameters();
                            if (subval == null) {
                                throw new DOMException(12, "Empty sub-" + ExpressionValue.this.getStringValue() + "()");
                            }
                            subexpr = this.fillExpressionLevel(subval, factory);
                            if (subexpr != null) {
                                subexpr.setInverseOperation(inverse);
                                if (expression != null) {
                                    expression.addExpression(subexpr);
                                    break;
                                }
                                expression = subexpr;
                                break;
                            }
                            throw new DOMException(5, "Bad sub-" + ExpressionValue.this.getStringValue() + "()");
                        }
                    }
                    default: {
                        PrimitiveValue primi;
                        PrimitiveValue.LexicalSetter item = factory.createCSSPrimitiveValueItem(lu, false);
                        if (item == null || ExpressionValue.this.isInvalidOperand(primi = item.getCSSValue(), lutype, lastlutype)) {
                            throw new DOMException(5, "Bad operands");
                        }
                        OperandExpression operand = new OperandExpression();
                        operand.setOperand(primi);
                        expression = ExpressionValue.this.addOperand(expression, operand);
                        lastlutype = lutype;
                        lu = item.getNextLexicalUnit();
                        continue block9;
                    }
                }
                lastlutype = lutype;
                lu = lu.getNextLexicalUnit();
            }
            if (expression.getParentExpression() != null) {
                expression = expression.getParentExpression();
            }
            return expression;
        }
    }
}

