/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue2;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.UnknownValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class FunctionValue
extends PrimitiveValue
implements CSSFunctionValue {
    private String functionName = null;
    private final LinkedCSSValueList arguments = new LinkedCSSValueList();

    public FunctionValue() {
        super((short)127);
    }

    protected FunctionValue(FunctionValue copied) {
        super(copied);
        this.functionName = copied.functionName;
        this.arguments.addAll(copied.arguments);
    }

    @Override
    public LinkedCSSValueList getArguments() {
        return this.arguments;
    }

    void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter sw = new BufferSimpleWriter(this.functionName.length() + this.arguments.size() * 8 + 12);
        try {
            this.writeCssText(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText(String pname) {
        StringBuilder buf = new StringBuilder(this.functionName.length() + this.arguments.size() * 8 + 12);
        buf.append(this.functionName).append('(');
        int sz = this.arguments.size();
        if (sz > 0) {
            buf.append(((StyleValue)this.arguments.get(0)).getMinifiedCssText(pname));
            for (int i = 1; i < sz; ++i) {
                buf.append(',').append(((StyleValue)this.arguments.get(i)).getMinifiedCssText(pname));
            }
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write(this.functionName);
        wri.write('(');
        int sz = this.arguments.size();
        if (sz == 1) {
            StyleValue first = (StyleValue)this.arguments.get(0);
            if (first.getCssValueType() == 1 && ((CSSPrimitiveValue2)((Object)first)).getPrimitiveType() == 101 && ((CSSPrimitiveValue2)((Object)first)).getStringValue().length() == 0) {
                wri.write(((CSSExpressionValue)((Object)first)).getExpression().getCssText());
            } else {
                first.writeCssText(wri);
            }
        } else if (sz != 0) {
            ((StyleValue)this.arguments.get(0)).writeCssText(wri);
            for (int i = 1; i < sz; ++i) {
                wri.write(',');
                wri.write(' ');
                ((StyleValue)this.arguments.get(i)).writeCssText(wri);
            }
        }
        wri.write(')');
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.functionName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionValue other = (FunctionValue)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        return !(this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName));
    }

    @Override
    public FunctionValue clone() {
        return new FunctionValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            FunctionValue.this.functionName = lunit.getFunctionName();
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            boolean commaSep = false;
            ValueList list = null;
            while (true) {
                StyleValue newval;
                ValueItem item;
                block22: {
                    if (lu == null) {
                        this.nextLexicalUnit = lunit.getNextLexicalUnit();
                        return;
                    }
                    short type = lu.getLexicalUnitType();
                    if (type == 40) {
                        item = this.subExpression(lu);
                        newval = item.getCSSValue();
                    } else {
                        if (type == 68) {
                            LexicalUnit nlu = lu.getNextLexicalUnit();
                            item = factory.parseBracketList(nlu, null, false);
                            if (item != null) {
                                newval = item.getCSSValue();
                                break block22;
                            } else {
                                lu = nlu.getNextLexicalUnit();
                                continue;
                            }
                        }
                        if (type == 4) {
                            if (list != null && list.getLength() == 1 && this.isOperand(list.item(0))) {
                                list = null;
                                item = this.expressionItem(lu);
                                newval = item.getCSSValue();
                            } else {
                                ValueFactory.BasicValueItem vbi = new ValueFactory.BasicValueItem();
                                vbi.nextLexicalUnit = lu.getNextLexicalUnit();
                                item = vbi;
                                newval = new UnknownValue();
                                ((UnknownValue)newval).setPlainCssText("/");
                            }
                        } else if (list != null && (type == 1 || type == 2 || type == 3) && list.getLength() == 1 && this.isOperand(list.item(0))) {
                            list = null;
                            item = this.expressionItem(lu);
                            newval = item.getCSSValue();
                        } else {
                            item = factory.createCSSPrimitiveValueItem(lu, false);
                            newval = item.getCSSValue();
                        }
                    }
                }
                lu = item.getNextLexicalUnit();
                if (lu != null) {
                    if (lu.getLexicalUnitType() == 0) {
                        lu = lu.getNextLexicalUnit();
                        if (!commaSep && !FunctionValue.this.arguments.isEmpty()) {
                            list = ValueList.createWSValueList();
                            Iterator it = FunctionValue.this.arguments.iterator();
                            while (it.hasNext()) {
                                list.add((StyleValue)it.next());
                            }
                            list.add(newval);
                            FunctionValue.this.arguments.clear();
                            FunctionValue.this.arguments.add(list);
                            list = null;
                        } else if (list == null) {
                            FunctionValue.this.arguments.add(newval);
                        } else {
                            list.add(newval);
                            list = null;
                        }
                        commaSep = true;
                        continue;
                    }
                    if (list == null) {
                        list = ValueList.createWSValueList();
                        list.add(newval);
                        FunctionValue.this.arguments.add(list);
                        continue;
                    }
                    list.add(newval);
                    continue;
                }
                if (list == null) {
                    FunctionValue.this.arguments.add(newval);
                    continue;
                }
                list.add(newval);
            }
        }

        private boolean isOperand(StyleValue value) {
            if (value.getCssValueType() == 1) {
                short pType = ((CSSPrimitiveValue)((Object)value)).getPrimitiveType();
                switch (pType) {
                    case 0: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 126: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: {
                        break;
                    }
                    default: {
                        return true;
                    }
                }
            }
            return false;
        }

        private ValueItem subExpression(LexicalUnit lu) {
            ExpressionValue expr = new ExpressionValue();
            ExpressionValue.ExpressionLexicalSetter setter = expr.newLexicalSetter();
            setter.setLexicalUnitFromSubValues(lu.getSubValues());
            LexicalUnit nextlex = lu.getNextLexicalUnit();
            if (nextlex != null) {
                short type = nextlex.getLexicalUnitType();
                if (type == 4) {
                    setter.setLexicalUnitFromSubValues(lu);
                } else {
                    setter.setLexicalUnitFromSubValues(lu.getSubValues());
                    setter.nextLexicalUnit = nextlex;
                }
            }
            return setter;
        }

        private ValueItem expressionItem(LexicalUnit lu) {
            FunctionValue.this.arguments.removeLast();
            LexicalUnit firstOpLu = lu.getPreviousLexicalUnit();
            LexicalUnit delimLu = firstOpLu.getPreviousLexicalUnit();
            if (delimLu == null || delimLu.getLexicalUnitType() == 0) {
                ExpressionValue expr = new ExpressionValue();
                ExpressionValue.ExpressionLexicalSetter setter = expr.newLexicalSetter();
                setter.setLexicalUnitFromSubValues(firstOpLu);
                return setter;
            }
            throw new IllegalStateException();
        }
    }
}

