/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSGradientValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class GradientValue
extends FunctionValue
implements CSSGradientValue {
    private CSSGradientValue.GradientType gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;

    GradientValue() {
    }

    GradientValue(GradientValue copied) {
        super(copied);
        this.gradientType = copied.gradientType;
    }

    @Override
    public CSSGradientValue.GradientType getGradientType() {
        return this.gradientType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.gradientType == null ? 0 : this.gradientType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GradientValue other = (GradientValue)obj;
        return this.gradientType == other.gradientType;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public GradientValue clone() {
        return new GradientValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(GradientValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) throws DOMException {
            String funcname = lunit.getFunctionName();
            GradientValue.this.setFunctionName(funcname);
            funcname = funcname.toLowerCase(Locale.ROOT);
            LexicalUnit lu = lunit.getParameters();
            if (lu == null) {
                throw new DOMException(12, "Gradient without arguments");
            }
            GradientValue.this.setCSSUnitType((short)126);
            if (funcname.endsWith("linear-gradient")) {
                if (funcname.equals("linear-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.LINEAR_GRADIENT;
                } else if (funcname.equals("repeating-linear-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.REPEATING_LINEAR_GRADIENT;
                } else {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;
                }
                this.setLinearGradient(lu, new ValueFactory());
            } else if (funcname.endsWith("radial-gradient")) {
                if (funcname.equals("radial-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.RADIAL_GRADIENT;
                } else if (funcname.equals("repeating-radial-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.REPEATING_RADIAL_GRADIENT;
                } else {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;
                }
                this.setRadialGradient(lu, new ValueFactory());
            } else if (funcname.endsWith("conic-gradient")) {
                if (funcname.equals("conic-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.CONIC_GRADIENT;
                } else if (funcname.equals("repeating-conic-gradient")) {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.REPEATING_CONIC_GRADIENT;
                } else {
                    GradientValue.this.gradientType = CSSGradientValue.GradientType.OTHER_GRADIENT;
                }
                this.setConicGradient(lu, new ValueFactory());
            } else {
                throw new DOMException(12, "Unknown gradient type");
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void setLinearGradient(LexicalUnit lu, ValueFactory factory) {
            LexicalUnit colorStopLU = this.isLinearColorStop(lu) ? lu : this.setAngleArguments(lu, factory);
            if (colorStopLU == null) {
                throw new DOMException(12, "Expected angle, side or color stop, found: " + lu.toString());
            }
            do {
                if ((colorStopLU = this.processLinearColorStop(colorStopLU, factory)) == null) continue;
                if (colorStopLU.getLexicalUnitType() == 0) {
                    colorStopLU = colorStopLU.getNextLexicalUnit();
                    continue;
                }
                throw new DOMException(12, "Expected color stops, found: " + lu.toString());
            } while (colorStopLU != null);
        }

        private LexicalUnit setAngleArguments(LexicalUnit lu, ValueFactory factory) {
            LexicalUnit finalLU = null;
            if (lu.getLexicalUnitType() == 35) {
                String ident = lu.getStringValue().toLowerCase(Locale.ROOT);
                ValueList list = ValueList.createWSValueList();
                if ("to".equals(ident)) {
                    list.add(factory.createCSSPrimitiveValue(lu, true));
                    lu = lu.getNextLexicalUnit();
                } else {
                    if (!this.isSideValue(ident)) {
                        return null;
                    }
                    this.reportSyntaxWarning("Missing 'to' in side/corner specification in gradient: " + lu.toString());
                }
                if (lu.getLexicalUnitType() == 35 && this.isSideValue(ident = lu.getStringValue().toLowerCase(Locale.ROOT))) {
                    list.add(factory.createCSSPrimitiveValue(lu, true));
                    finalLU = lu = lu.getNextLexicalUnit();
                    if (lu.getLexicalUnitType() == 35 && this.isSideValue(ident = lu.getStringValue().toLowerCase(Locale.ROOT))) {
                        list.add(factory.createCSSPrimitiveValue(lu, true));
                        finalLU = lu.getNextLexicalUnit();
                    }
                    GradientValue.this.getArguments().add(list);
                }
            } else if (ValueFactory.isAngleSACUnit(lu)) {
                GradientValue.this.getArguments().add(factory.createCSSPrimitiveValue(lu, true));
                finalLU = lu.getNextLexicalUnit();
            }
            if (finalLU != null) {
                finalLU = finalLU.getLexicalUnitType() == 0 ? finalLU.getNextLexicalUnit() : null;
            }
            return finalLU;
        }

        private boolean isSideValue(String ident) {
            return "left".equals(ident) || "right".equals(ident) || "top".equals(ident) || "bottom".equals(ident);
        }

        private boolean isLinearColorStop(LexicalUnit lu) {
            LexicalUnit lu2 = lu.getNextLexicalUnit();
            if (BaseCSSStyleDeclaration.testColor(lu)) {
                return true;
            }
            return lu2 != null && BaseCSSStyleDeclaration.testColor(lu2) && ValueFactory.isSizeSACUnit(lu);
        }

        private LexicalUnit processLinearColorStop(LexicalUnit lu, ValueFactory factory) {
            LexicalUnit finalLU = null;
            LexicalUnit lu2 = lu.getNextLexicalUnit();
            if (BaseCSSStyleDeclaration.testColor(lu)) {
                PrimitiveValue color = factory.createCSSPrimitiveValue(lu, true);
                if (lu2 != null && ValueFactory.isSizeSACUnit(lu2)) {
                    ValueList list = ValueList.createWSValueList();
                    list.add(color);
                    list.add(factory.createCSSPrimitiveValue(lu2, true));
                    GradientValue.this.getArguments().add(list);
                    lu2 = lu2.getNextLexicalUnit();
                    if (lu2 != null && ValueFactory.isSizeSACUnit(lu2)) {
                        list.add(factory.createCSSPrimitiveValue(lu2, true));
                        lu2 = lu2.getNextLexicalUnit();
                    }
                } else {
                    GradientValue.this.getArguments().add(color);
                }
                finalLU = lu2;
            } else if (lu2 != null && BaseCSSStyleDeclaration.testColor(lu2) && ValueFactory.isSizeSACUnit(lu)) {
                ValueList list = ValueList.createWSValueList();
                list.add(factory.createCSSPrimitiveValue(lu2, true));
                list.add(factory.createCSSPrimitiveValue(lu, true));
                GradientValue.this.getArguments().add(list);
                finalLU = lu2.getNextLexicalUnit();
            } else if (lu.getLexicalUnitType() == 0) {
                finalLU = lu;
            }
            return finalLU;
        }

        private void setRadialGradient(LexicalUnit lu, ValueFactory factory) {
            LexicalUnit colorStopLU;
            if (!this.isLinearColorStop(lu) && (lu = this.processNonColorStop(lu, factory)) != null && !this.isLinearColorStop(lu)) {
                lu = this.processNonColorStop(lu, factory);
            }
            if ((colorStopLU = lu) == null) {
                throw new DOMException(12, "Missing color stop");
            }
            do {
                if ((colorStopLU = this.processLinearColorStop(colorStopLU, factory)) == null) continue;
                if (colorStopLU.getLexicalUnitType() == 0) {
                    colorStopLU = colorStopLU.getNextLexicalUnit();
                    continue;
                }
                throw new DOMException(12, "Expected color stops, found: " + lu.toString());
            } while (colorStopLU != null);
        }

        private LexicalUnit processNonColorStop(LexicalUnit lu, ValueFactory factory) {
            ValueList list = ValueList.createWSValueList();
            while (lu != null) {
                if (lu.getLexicalUnitType() == 0) {
                    lu = lu.getNextLexicalUnit();
                    break;
                }
                list.add(factory.createCSSPrimitiveValue(lu, true));
                lu = lu.getNextLexicalUnit();
            }
            if (list.getLength() != 1) {
                GradientValue.this.getArguments().add(list);
            } else {
                GradientValue.this.getArguments().add(list.item(0));
            }
            return lu;
        }

        private void setConicGradient(LexicalUnit lu, ValueFactory factory) {
            LexicalUnit colorStopLU;
            if (!this.isAngularColorStop(lu)) {
                ValueList list = ValueList.createWSValueList();
                while (lu != null) {
                    if (lu.getLexicalUnitType() == 0) {
                        lu = lu.getNextLexicalUnit();
                        break;
                    }
                    list.add(factory.createCSSPrimitiveValue(lu, true));
                    lu = lu.getNextLexicalUnit();
                }
                if (list.getLength() != 1) {
                    GradientValue.this.getArguments().add(list);
                } else {
                    GradientValue.this.getArguments().add(list.item(0));
                }
            }
            if ((colorStopLU = lu) == null) {
                throw new DOMException(12, "Missing angle, position or color stop in gradient");
            }
            do {
                if ((colorStopLU = this.processAngularColorStop(colorStopLU, factory)) == null) continue;
                if (colorStopLU.getLexicalUnitType() == 0) {
                    colorStopLU = colorStopLU.getNextLexicalUnit();
                    continue;
                }
                throw new DOMException(12, "Expected color stops, found: " + lu.toString());
            } while (colorStopLU != null);
        }

        private boolean isAngularColorStop(LexicalUnit lu) {
            LexicalUnit lu2 = lu.getNextLexicalUnit();
            if (BaseCSSStyleDeclaration.testColor(lu)) {
                return true;
            }
            return lu2 != null && BaseCSSStyleDeclaration.testColor(lu2) && (ValueFactory.isAngleSACUnit(lu) || lu.getLexicalUnitType() == 23);
        }

        private LexicalUnit processAngularColorStop(LexicalUnit lu, ValueFactory factory) {
            LexicalUnit finalLU = null;
            LexicalUnit lu2 = lu.getNextLexicalUnit();
            if (BaseCSSStyleDeclaration.testColor(lu)) {
                PrimitiveValue color = factory.createCSSPrimitiveValue(lu, true);
                if (lu2 != null && (ValueFactory.isAngleSACUnit(lu2) || lu2.getLexicalUnitType() == 23)) {
                    ValueList list = ValueList.createWSValueList();
                    list.add(color);
                    list.add(factory.createCSSPrimitiveValue(lu2, true));
                    GradientValue.this.getArguments().add(list);
                    lu2 = lu2.getNextLexicalUnit();
                    if (lu2 != null && (ValueFactory.isAngleSACUnit(lu2) || lu2.getLexicalUnitType() == 23)) {
                        list.add(factory.createCSSPrimitiveValue(lu2, true));
                        lu2 = lu2.getNextLexicalUnit();
                    }
                } else {
                    GradientValue.this.getArguments().add(color);
                }
                finalLU = lu2;
            } else if (lu2 != null && BaseCSSStyleDeclaration.testColor(lu2) && (ValueFactory.isAngleSACUnit(lu) || lu.getLexicalUnitType() == 23)) {
                ValueList list = ValueList.createWSValueList();
                list.add(factory.createCSSPrimitiveValue(lu2, true));
                list.add(factory.createCSSPrimitiveValue(lu, true));
                GradientValue.this.getArguments().add(list);
                finalLU = lu2.getNextLexicalUnit();
            } else if (ValueFactory.isAngleSACUnit(lu) || lu.getLexicalUnitType() == 23) {
                GradientValue.this.getArguments().add(factory.createCSSPrimitiveValue(lu, true));
                finalLU = lu2;
            } else if (lu.getLexicalUnitType() == 0) {
                finalLU = lu;
            }
            return finalLU;
        }
    }
}

