/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.nsac.LexicalUnit2;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class IdentifierValue
extends AbstractTextValue {
    private String stringValue = null;

    public IdentifierValue() {
        super((short)21);
    }

    public IdentifierValue(String plainIdentifier) {
        super((short)21);
        this.stringValue = plainIdentifier;
        this.setPlainCssText(plainIdentifier);
    }

    protected IdentifierValue(IdentifierValue copied) {
        super(copied);
        this.stringValue = copied.stringValue;
        this.setPlainCssText(copied.getCssText());
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        LexicalUnit2 lu;
        this.checkModifiableProperty();
        if (cssText == null || cssText.length() == 0) {
            throw new DOMException(5, "Null or empty value.");
        }
        InputSource source = new InputSource((Reader)new StringReader(cssText));
        CSSParser parser = new CSSParser();
        try {
            lu = parser.parsePropertyValue(source);
        }
        catch (IOException e) {
            lu = null;
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(5, "Bad identifier: " + cssText);
            ex.initCause(e);
            throw ex;
        }
        if (lu.getLexicalUnitType() != 35 || lu.getNextLexicalUnit() != null) {
            throw new DOMException(13, "Not an identifier: " + cssText);
        }
        PrimitiveValue.LexicalSetter setter = this.newLexicalSetter();
        setter.setLexicalUnit(lu);
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return ParseHelper.safeEscape(this.stringValue, false);
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        this.checkModifiableProperty();
        if (stringType != 21) {
            throw new DOMException(13, "This value is an identifier. To have a new type, set it at the style-declaration level.");
        }
        if (stringValue == null || stringValue.length() == 0) {
            throw new DOMException(5, "Null or empty value.");
        }
        this.setCSSUnitType(stringType);
        this.setStringValue(stringValue);
        this.setPlainCssText(this.escape(this.stringValue));
    }

    private void setStringValue(String value) {
        this.stringValue = value.intern();
    }

    private String escape(String css) throws DOMException {
        return ParseHelper.escape(css);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write(this.getCssText());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        String sv = this.getStringValue();
        result = 31 * result + (sv == null ? 0 : sv.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentifierValue other = (IdentifierValue)obj;
        String sv = this.getStringValue();
        String osv = other.getStringValue();
        return !(sv == null ? osv != null : !sv.equals(osv));
    }

    @Override
    public IdentifierValue clone() {
        return new IdentifierValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            String strval = lunit.getStringValue();
            IdentifierValue.this.setStringValue(strval);
            if (lunit instanceof LexicalUnit2) {
                IdentifierValue.this.setPlainCssText(((LexicalUnit2)lunit).getCssText());
            } else {
                IdentifierValue.this.setPlainCssText(IdentifierValue.this.escape(IdentifierValue.this.stringValue));
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

