/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class NumberValue
extends PrimitiveValue {
    protected float realvalue = 0.0f;
    private String dimensionUnitText = "";
    private boolean asInteger = false;
    boolean lengthUnitType = false;
    private boolean calculated = false;
    private boolean specified = true;

    public NumberValue() {
    }

    protected NumberValue(NumberValue copied) {
        super(copied);
        this.realvalue = copied.realvalue;
        this.asInteger = copied.asInteger;
        this.calculated = copied.calculated;
        this.lengthUnitType = copied.lengthUnitType;
        this.dimensionUnitText = copied.dimensionUnitText;
    }

    @Override
    public String getCssText() {
        boolean notaNumber;
        boolean bl = notaNumber = this.getPrimitiveType() != 1;
        if (this.realvalue == 0.0f && !notaNumber) {
            return "0";
        }
        if (Float.isInfinite(this.realvalue)) {
            return this.serializeInfinite();
        }
        double rintValue = Math.rint(this.realvalue);
        if (this.asInteger) {
            return Integer.toString((int)rintValue);
        }
        if ((double)this.realvalue == rintValue && notaNumber) {
            return Integer.toString((int)rintValue) + this.dimensionUnitText;
        }
        String s = this.serializeNumber(this.realvalue);
        StringBuilder buf = new StringBuilder(s.length() + this.dimensionUnitText.length());
        buf.append(s);
        buf.append(this.dimensionUnitText);
        return buf.toString();
    }

    private String serializeNumber(float real) {
        String s;
        if (this.specified) {
            s = Float.toString(real);
        } else {
            NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
            format.setMinimumFractionDigits(0);
            format.setMaximumFractionDigits(NumberValue.fractionDigits(this.getPrimitiveType()));
            s = format.format(real);
        }
        return s;
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        this.writeCssText(wri, this.realvalue);
    }

    void writeCssText(SimpleWriter wri, float realvalue) throws IOException {
        boolean notaNumber;
        boolean bl = notaNumber = this.getPrimitiveType() != 1;
        if (realvalue == 0.0f && !notaNumber) {
            wri.write('0');
            return;
        }
        if (Float.isInfinite(realvalue)) {
            this.writeInfinite(wri);
            return;
        }
        double rintValue = Math.rint(realvalue);
        if (this.asInteger) {
            wri.write(Integer.toString((int)rintValue));
            return;
        }
        if ((double)realvalue == rintValue && notaNumber) {
            wri.write(Integer.toString((int)rintValue));
            wri.write(this.dimensionUnitText);
            return;
        }
        String s = this.serializeNumber(realvalue);
        wri.write(s);
        wri.write(this.dimensionUnitText);
    }

    private void writeInfinite(SimpleWriter wri) throws IOException {
        if (this.realvalue > 0.0f) {
            wri.write("calc(1/0)");
        } else {
            wri.write("calc(-1/0)");
        }
    }

    public void serializeAbsolute(SimpleWriter wri) throws IOException {
        this.writeCssText(wri, Math.abs(this.realvalue));
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return this.getMinifiedCssText(propertyName, this.realvalue);
    }

    private String getMinifiedCssText(String propertyName, float realvalue) {
        boolean notaNumber;
        boolean bl = notaNumber = this.getPrimitiveType() != 1;
        if (realvalue == 0.0f && notaNumber && this.getPrimitiveType() != 2 && this.isLengthUnitType()) {
            return "0";
        }
        if (Float.isInfinite(realvalue)) {
            return this.serializeInfinite();
        }
        double rintValue = Math.rint(realvalue);
        if (this.asInteger) {
            return Integer.toString((int)rintValue);
        }
        if ((double)realvalue == rintValue) {
            String s = Integer.toString((int)rintValue);
            if (notaNumber) {
                return s + this.dimensionUnitText;
            }
            return s;
        }
        String s = this.serializeNumber(realvalue);
        int len = s.length();
        StringBuilder buf = new StringBuilder(len + this.dimensionUnitText.length());
        char c = s.charAt(0);
        if (c == '-' && s.charAt(1) == '0') {
            buf.append('-');
            buf.append(s.subSequence(2, len));
        } else if (c == '0' && len > 2) {
            buf.append(s.subSequence(1, len));
        } else {
            buf.append(s);
        }
        buf.append(this.dimensionUnitText);
        return buf.toString();
    }

    private String serializeInfinite() {
        if (this.realvalue > 0.0f) {
            return "calc(1/0)";
        }
        return "calc(-1/0)";
    }

    public String minifyAbsolute(String propertyName) {
        return this.getMinifiedCssText(propertyName, Math.abs(this.realvalue));
    }

    private boolean isLengthUnitType() {
        return this.lengthUnitType;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        this.checkModifiableProperty();
        this.setCSSUnitType(unitType);
        this.realvalue = floatValue;
        this.dimensionUnitText = NumberValue.dimensionUnitString(unitType);
        this.asInteger = unitType == 1 && (float)Math.rint(floatValue) == this.realvalue;
        this.lengthUnitType = NumberValue.isLengthUnitType(this.getPrimitiveType());
    }

    public void setFloatValuePt(float floatValue) {
        this.setCSSUnitType((short)9);
        this.realvalue = floatValue;
        this.dimensionUnitText = "pt";
        this.asInteger = false;
        this.lengthUnitType = true;
    }

    public void setIntegerValue(int intValue) {
        this.realvalue = intValue;
        this.setCSSUnitType((short)1);
        this.asInteger = true;
        this.lengthUnitType = false;
    }

    @Override
    public void setExpectInteger() {
        if (this.getPrimitiveType() != 1 || !this.asInteger) {
            super.setExpectInteger();
        }
    }

    void roundToInteger() throws DOMException {
        this.setExpectInteger();
        this.realvalue = Math.round(this.realvalue);
        this.asInteger = true;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "Cannot use setCssText here");
    }

    @Override
    public boolean isCalculatedNumber() {
        return this.calculated;
    }

    void setCalculatedNumber(boolean calculated) {
        this.calculated = calculated;
    }

    public void setAbsolutizedUnit() {
        this.specified = false;
    }

    @Override
    public boolean isNegativeNumber() {
        return this.realvalue < 0.0f;
    }

    @Override
    public boolean isNumberZero() {
        return this.realvalue == 0.0f;
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        if (unitType == this.getPrimitiveType()) {
            return this.realvalue;
        }
        if (unitType == 1 && this.getPrimitiveType() != 2) {
            return this.realvalue;
        }
        return NumberValue.floatValueConversion(this.realvalue, this.getPrimitiveType(), unitType);
    }

    public static float floatValueConversion(float fvalue, short declType, short unitType) throws DOMException {
        String unit;
        if (fvalue == 0.0f) {
            return 0.0f;
        }
        if (declType == unitType) {
            return fvalue;
        }
        switch (declType) {
            case 9: {
                if (unitType == 5) {
                    return fvalue / 0.75f;
                }
                if (unitType == 8) {
                    return fvalue / 72.0f;
                }
                if (unitType == 10) {
                    return fvalue / 12.0f;
                }
                if (unitType == 6) {
                    return fvalue / 28.346457f;
                }
                if (unitType == 7) {
                    return fvalue / 2.8346457f;
                }
                if (unitType != 30) break;
                return fvalue * 1.4111111f;
            }
            case 5: {
                if (unitType == 9) {
                    return fvalue * 0.75f;
                }
                if (unitType == 8) {
                    return fvalue / 96.0f;
                }
                if (unitType == 10) {
                    return fvalue / 16.0f;
                }
                if (unitType == 6) {
                    return fvalue / 37.795277f;
                }
                if (unitType == 7) {
                    return fvalue / 3.7795277f;
                }
                if (unitType != 30) break;
                return fvalue * 1.0583333f;
            }
            case 10: {
                if (unitType == 9) {
                    return fvalue * 12.0f;
                }
                if (unitType == 8) {
                    return fvalue / 6.0f;
                }
                if (unitType == 5) {
                    return fvalue * 16.0f;
                }
                if (unitType == 6) {
                    return fvalue * 0.42333332f;
                }
                if (unitType == 7) {
                    return fvalue * 4.233333f;
                }
                if (unitType != 30) break;
                return fvalue * 16.933332f;
            }
            case 8: {
                if (unitType == 5) {
                    return fvalue * 96.0f;
                }
                if (unitType == 9) {
                    return fvalue * 72.0f;
                }
                if (unitType == 10) {
                    return fvalue * 6.0f;
                }
                if (unitType == 6) {
                    return fvalue * 2.54f;
                }
                if (unitType == 7) {
                    return fvalue * 25.4f;
                }
                if (unitType != 30) break;
                return fvalue * 101.6f;
            }
            case 6: {
                if (unitType == 9) {
                    return fvalue * 28.346457f;
                }
                if (unitType == 8) {
                    return fvalue / 2.54f;
                }
                if (unitType == 5) {
                    return fvalue * 37.795277f;
                }
                if (unitType == 10) {
                    return fvalue * 2.3622048f;
                }
                if (unitType == 7) {
                    return fvalue * 10.0f;
                }
                if (unitType != 30) break;
                return fvalue * 40.0f;
            }
            case 7: {
                if (unitType == 9) {
                    return fvalue * 2.8346457f;
                }
                if (unitType == 8) {
                    return fvalue / 25.4f;
                }
                if (unitType == 5) {
                    return fvalue * 3.7795277f;
                }
                if (unitType == 10) {
                    return fvalue * 0.23622046f;
                }
                if (unitType == 6) {
                    return fvalue * 0.1f;
                }
                if (unitType != 30) break;
                return fvalue * 4.0f;
            }
            case 30: {
                if (unitType == 9) {
                    return fvalue * 0.7086614f;
                }
                if (unitType == 8) {
                    return fvalue / 101.6f;
                }
                if (unitType == 5) {
                    return fvalue * 0.9448819f;
                }
                if (unitType == 10) {
                    return fvalue / 16.933332f;
                }
                if (unitType == 7) {
                    return fvalue * 0.25f;
                }
                if (unitType != 6) break;
                return fvalue * 0.025f;
            }
            case 14: {
                if (unitType != 15) break;
                return fvalue * 0.001f;
            }
            case 15: {
                if (unitType != 14) break;
                return fvalue * 1000.0f;
            }
            case 33: {
                if (unitType == 12) {
                    return fvalue * 2.0f * (float)Math.PI;
                }
                if (unitType == 13) {
                    return fvalue * 400.0f;
                }
                if (unitType != 11) break;
                return fvalue * 360.0f;
            }
            case 12: {
                if (unitType == 11) {
                    return (float)Math.toDegrees(fvalue);
                }
                if (unitType == 13) {
                    return fvalue * 63.661976f;
                }
                if (unitType != 33) break;
                return fvalue * 0.15915494f;
            }
            case 11: {
                if (unitType == 12) {
                    return (float)Math.toRadians(fvalue);
                }
                if (unitType == 13) {
                    return fvalue * 1.1111112f;
                }
                if (unitType != 33) break;
                return fvalue / 360.0f;
            }
            case 13: {
                if (unitType == 11) {
                    return fvalue * 0.9f;
                }
                if (unitType == 12) {
                    return fvalue * 0.015707964f;
                }
                if (unitType != 33) break;
                return fvalue * 0.0025f;
            }
            case 1: {
                if (unitType == 11) {
                    return fvalue;
                }
            }
            case 16: {
                if (unitType != 17) break;
                return fvalue * 0.001f;
            }
            case 17: {
                if (unitType != 16) break;
                return fvalue * 1000.0f;
            }
            default: {
                if (18 != unitType) break;
                return fvalue;
            }
        }
        if ((unit = NumberValue.dimensionUnitString(declType)).length() == 0) {
            unit = Integer.toString(declType);
        }
        throw new DOMException(15, "Cannot transform unit " + unit + " to " + NumberValue.dimensionUnitString(unitType));
    }

    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.getCssValueType();
        short pType = this.realvalue != 0.0f ? this.getPrimitiveType() : (short)1;
        result = 31 * result + pType;
        result = 31 * result + Float.floatToIntBits(this.realvalue);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NumberValue)) {
            return false;
        }
        NumberValue other = (NumberValue)obj;
        if (Float.floatToIntBits(this.realvalue) != Float.floatToIntBits(other.realvalue)) {
            return false;
        }
        return this.getPrimitiveType() == other.getPrimitiveType() || this.realvalue == 0.0f;
    }

    @Override
    public NumberValue clone() {
        return new NumberValue(this);
    }

    NumberValue immutable() {
        return new ImmutableCSSNumberValue(this);
    }

    static String dimensionUnitString(short unitType) {
        switch (unitType) {
            case 3: {
                return "em";
            }
            case 4: {
                return "ex";
            }
            case 5: {
                return "px";
            }
            case 8: {
                return "in";
            }
            case 6: {
                return "cm";
            }
            case 7: {
                return "mm";
            }
            case 9: {
                return "pt";
            }
            case 10: {
                return "pc";
            }
            case 2: {
                return "%";
            }
            case 11: {
                return "deg";
            }
            case 13: {
                return "grad";
            }
            case 12: {
                return "rad";
            }
            case 14: {
                return "ms";
            }
            case 15: {
                return "s";
            }
            case 16: {
                return "Hz";
            }
            case 17: {
                return "kHz";
            }
            case 26: {
                return "cap";
            }
            case 27: {
                return "ch";
            }
            case 43: {
                return "fr";
            }
            case 28: {
                return "ic";
            }
            case 29: {
                return "lh";
            }
            case 30: {
                return "Q";
            }
            case 31: {
                return "rem";
            }
            case 32: {
                return "rlh";
            }
            case 34: {
                return "vb";
            }
            case 35: {
                return "vh";
            }
            case 36: {
                return "vi";
            }
            case 37: {
                return "vmax";
            }
            case 38: {
                return "vmin";
            }
            case 39: {
                return "vw";
            }
            case 40: {
                return "dpi";
            }
            case 41: {
                return "dpcm";
            }
            case 42: {
                return "dppx";
            }
        }
        return "";
    }

    private static int fractionDigits(short primitiveType) {
        switch (primitiveType) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 2;
            }
            case 6: 
            case 17: 
            case 33: {
                return 4;
            }
        }
        return 3;
    }

    public static boolean isLengthUnitType(short primitiveType) {
        switch (primitiveType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAngleUnitType(short primitiveType) {
        switch (primitiveType) {
            case 11: 
            case 12: 
            case 13: 
            case 33: {
                return true;
            }
        }
        return false;
    }

    public static NumberValue createCSSNumberValue(short unit, float floatValue) {
        NumberValue num = new NumberValue();
        num.setFloatValue(unit, floatValue);
        return num;
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(NumberValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            super.setLexicalUnit(lunit);
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
            switch (lunit.getLexicalUnitType()) {
                case 13: {
                    NumberValue.this.realvalue = lunit.getIntegerValue();
                    NumberValue.this.asInteger = true;
                    break;
                }
                default: {
                    NumberValue.this.realvalue = lunit.getFloatValue();
                    NumberValue.this.asInteger = false;
                    NumberValue.this.dimensionUnitText = lunit.getDimensionUnitText();
                }
            }
        }
    }

    private static class ImmutableCSSNumberValue
    extends NumberValue {
        ImmutableCSSNumberValue(NumberValue value) {
            super(value);
        }

        @Override
        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            throw new DOMException(7, "This value is immutable");
        }

        @Override
        public void setFloatValuePt(float floatValue) {
            throw new DOMException(7, "This value is immutable");
        }

        @Override
        public void setIntegerValue(int intValue) {
            throw new DOMException(7, "This value is immutable");
        }
    }
}

