/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.ExtendedCSSPrimitiveValue;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.CustomPropertyValue;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.OperandExpression;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.Rect;

public abstract class PrimitiveValue
extends StyleValue
implements ExtendedCSSPrimitiveValue {
    private short primitiveType = 0;
    private boolean subproperty = false;

    protected PrimitiveValue(short unitType) {
        super((short)1);
        this.primitiveType = unitType;
    }

    protected PrimitiveValue() {
        this(0);
    }

    protected PrimitiveValue(PrimitiveValue copied) {
        this(copied.primitiveType);
        this.subproperty = copied.subproperty;
    }

    @Override
    public short getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        if (unitType != this.getPrimitiveType()) {
            throw new DOMException(13, "Not a Float.");
        }
        throw new DOMException(15, "Not a <number>.");
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        throw new DOMException(15, "Not a Float");
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        if (stringType != this.getPrimitiveType()) {
            throw new DOMException(13, "Type not supported.");
        }
        throw new DOMException(15, "Cannot be modified as a String");
    }

    @Override
    public String getStringValue() throws DOMException {
        throw new DOMException(15, "Not a String");
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        throw new DOMException(15, "Not a Counter");
    }

    @Override
    public Rect getRectValue() throws DOMException {
        throw new DOMException(15, "Not a Rect");
    }

    @Override
    public RGBAColor getRGBColorValue() throws DOMException {
        String ident;
        String spec;
        if (this.getPrimitiveType() == 21 && (spec = "transparent".equals(ident = this.getStringValue().toLowerCase(Locale.ROOT)) ? "rgba(0,0,0,0)" : ColorIdentifiers.getInstance().getColor(ident)) != null) {
            ValueFactory factory = new ValueFactory();
            try {
                StyleValue val = factory.parseProperty(spec);
                if (val.getCssValueType() == 1 && ((PrimitiveValue)val).getPrimitiveType() == 25) {
                    return ((PrimitiveValue)val).getRGBColorValue();
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        throw new DOMException(15, "Not an RGB Color");
    }

    public void setSubproperty(boolean subp) {
        this.subproperty = subp;
    }

    @Override
    public boolean isSubproperty() {
        return this.subproperty;
    }

    void checkModifiableProperty() throws DOMException {
        if (this.isSubproperty() || this.isReadOnly()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify at the style-declaration level.");
        }
    }

    void setCSSUnitType(short cssUnitType) {
        this.primitiveType = cssUnitType;
    }

    @Override
    public boolean isCalculatedNumber() {
        return false;
    }

    @Override
    public boolean isNegativeNumber() {
        return false;
    }

    @Override
    public boolean isNumberZero() {
        return false;
    }

    public void setExpectInteger() {
        throw new DOMException(17, "Expected an integer, found type " + this.getPrimitiveType());
    }

    static boolean isCSSIdentifier(CSSPrimitiveValue value, String ident) {
        return value.getPrimitiveType() == 21 && ident.equalsIgnoreCase(value.getStringValue());
    }

    static boolean isOrContainsType(CSSValue value, short primitiveType) {
        short type = value.getCssValueType();
        if (type == 1) {
            return PrimitiveValue.isOrContainsType((CSSPrimitiveValue)value, primitiveType);
        }
        if (type == 2) {
            return PrimitiveValue.listContainsType((ValueList)value, primitiveType);
        }
        return false;
    }

    private static boolean listContainsType(ValueList list, short primitiveType) {
        for (StyleValue value : list) {
            if (!PrimitiveValue.isOrContainsType(value, primitiveType)) continue;
            return true;
        }
        return false;
    }

    static boolean isOrContainsType(CSSPrimitiveValue value, short primitiveType) {
        StyleValue fallback;
        short pType = value.getPrimitiveType();
        if (pType == primitiveType) {
            return true;
        }
        if (pType == 127) {
            return PrimitiveValue.functionContainsType((FunctionValue)value, primitiveType);
        }
        if (pType == 101) {
            return PrimitiveValue.expressionContainsType(((ExpressionValue)value).getExpression(), primitiveType);
        }
        return pType == 128 && (fallback = ((CustomPropertyValue)value).getFallback()) != null && PrimitiveValue.isOrContainsType(fallback, primitiveType);
    }

    private static boolean functionContainsType(FunctionValue function, short primitiveType) {
        LinkedCSSValueList list = function.getArguments();
        for (StyleValue value : list) {
            if (!PrimitiveValue.isOrContainsType(value, primitiveType)) continue;
            return true;
        }
        return false;
    }

    private static boolean expressionContainsType(CSSExpression expr, short primitiveType) {
        switch (expr.getPartType()) {
            case SUM: 
            case PRODUCT: {
                AlgebraicExpression ae = (AlgebraicExpression)expr;
                int len = ae.getLength();
                for (int i = 0; i < len; ++i) {
                    if (!PrimitiveValue.expressionContainsType(ae.item(i), primitiveType)) continue;
                    return true;
                }
                break;
            }
            case OPERAND: {
                OperandExpression operand = (OperandExpression)expr;
                ExtendedCSSPrimitiveValue primi = operand.getOperand();
                if (!PrimitiveValue.isOrContainsType(primi, primitiveType)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getPrimitiveType();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PrimitiveValue)) {
            return false;
        }
        PrimitiveValue other = (PrimitiveValue)obj;
        return this.getPrimitiveType() == other.getPrimitiveType();
    }

    abstract LexicalSetter newLexicalSetter();

    @Override
    public abstract PrimitiveValue clone();

    class LexicalSetter
    implements ValueItem {
        LexicalUnit nextLexicalUnit = null;
        private LinkedList<String> syntaxWarnings = null;

        LexicalSetter() {
        }

        void setLexicalUnit(LexicalUnit lunit) throws DOMException {
            PrimitiveValue.this.setCSSUnitType(ValueFactory.domPrimitiveType(lunit));
        }

        @Override
        public LexicalUnit getNextLexicalUnit() {
            return this.nextLexicalUnit;
        }

        @Override
        public PrimitiveValue getCSSValue() {
            return PrimitiveValue.this;
        }

        void reportSyntaxWarning(String message) {
            if (this.syntaxWarnings == null) {
                this.syntaxWarnings = new LinkedList();
            }
            this.syntaxWarnings.add(message);
        }

        @Override
        public boolean hasWarnings() {
            return this.syntaxWarnings != null;
        }

        @Override
        public void handleSyntaxWarnings(StyleDeclarationErrorHandler handler) {
            if (this.syntaxWarnings != null) {
                Iterator it = this.syntaxWarnings.iterator();
                while (it.hasNext()) {
                    handler.syntaxWarning((String)it.next());
                }
            }
        }

        public String toString() {
            return PrimitiveValue.this.getCssText();
        }
    }
}

