/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSRatioValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Objects;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class RatioValue
extends PrimitiveValue
implements CSSRatioValue {
    private PrimitiveValue antecedentValue;
    private PrimitiveValue consequentValue;

    public RatioValue() {
        this.setCSSUnitType((short)135);
    }

    protected RatioValue(RatioValue copied) {
        super(copied);
        this.antecedentValue = copied.antecedentValue.clone();
        this.consequentValue = copied.consequentValue.clone();
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter sw = new BufferSimpleWriter(32);
        try {
            this.writeCssText(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        this.antecedentValue.writeCssText(wri);
        wri.write('/');
        this.consequentValue.writeCssText(wri);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory vf = new ValueFactory();
        PrimitiveValue value = vf.parseMediaFeature(cssText);
        if (value.getPrimitiveType() != 135) {
            throw new DOMException(13, "Value is not a ratio.");
        }
        RatioValue ratio = (RatioValue)value;
        this.antecedentValue = ratio.antecedentValue;
        this.consequentValue = ratio.consequentValue;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        throw new DOMException(9, "This value needs special handling");
    }

    @Override
    public PrimitiveValue getAntecedentValue() {
        return this.antecedentValue;
    }

    @Override
    public PrimitiveValue getConsequentValue() {
        return this.consequentValue;
    }

    public void setAntecedentValue(PrimitiveValue antecedentValue) throws DOMException {
        this.checkValueType(antecedentValue);
        this.antecedentValue = antecedentValue;
    }

    public void setConsequentValue(PrimitiveValue consequentValue) throws DOMException {
        this.checkValueType(consequentValue);
        this.consequentValue = consequentValue;
    }

    private void checkValueType(CSSPrimitiveValue value) throws DOMException {
        if (value == null) {
            throw new DOMException(5, "Null value in ratio.");
        }
        short ptype = value.getPrimitiveType();
        if (ptype != 1 && ptype != 101) {
            throw new DOMException(12, "Unexpected type in ratio: " + ptype);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.antecedentValue, this.consequentValue);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RatioValue other = (RatioValue)obj;
        return Objects.equals(this.antecedentValue, other.antecedentValue) && Objects.equals(this.consequentValue, other.consequentValue);
    }

    @Override
    public RatioValue clone() {
        return new RatioValue(this);
    }
}

