/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class ShorthandDatabase {
    private final Map<String, String[]> shorthand2subp = new HashMap<String, String[]>();
    private final Map<String, String> subp2shorthand = new HashMap<String, String>();
    private final Properties identifiers;
    private static final ShorthandDatabase singleton = new ShorthandDatabase();

    private ShorthandDatabase() {
        this(null);
    }

    public ShorthandDatabase(ClassLoader loader) {
        this.identifiers = this.loadPropertiesfromClasspath("identifier.properties", loader);
        Properties shand = this.loadPropertiesfromClasspath("shorthand.properties", loader);
        ArrayList<String> array = new ArrayList<String>();
        for (Map.Entry<Object, Object> me : shand.entrySet()) {
            String shname = (String)me.getKey();
            String subpties = (String)me.getValue();
            StringTokenizer st = new StringTokenizer(subpties, ",");
            while (st.hasMoreTokens()) {
                array.add(st.nextToken().trim());
            }
            this.addShorthand(shname, array.toArray(new String[0]));
            array.clear();
        }
    }

    public static ShorthandDatabase getInstance() {
        return singleton;
    }

    public boolean isShorthand(String name) {
        return this.shorthand2subp.containsKey(name);
    }

    public boolean isShorthandSubproperty(String name) {
        return this.subp2shorthand.containsKey(name);
    }

    public String getShorthand(String subproperty) {
        return this.subp2shorthand.get(subproperty);
    }

    public boolean isShorthandSubpropertyOf(String shorthand, String subpName) {
        String sh = this.subp2shorthand.get(subpName);
        if (sh == null) {
            return false;
        }
        if (sh.equals(shorthand)) {
            return true;
        }
        if (shorthand.equals(sh = this.subp2shorthand.get(sh))) {
            return true;
        }
        String[] subp = this.shorthand2subp.get(shorthand);
        for (int i = 0; i < subp.length; ++i) {
            if (!subp[i].equals(subpName)) continue;
            return true;
        }
        return false;
    }

    public String[] getShorthandSubproperties(String shorthandName) {
        return this.shorthand2subp.get(shorthandName);
    }

    public String[] getLonghandProperties(String shorthandName) {
        String[] subparray = this.getShorthandSubproperties(shorthandName);
        if (subparray != null) {
            for (String subproperty : subparray) {
                if (!this.isShorthand(subproperty)) continue;
                return this.longhandArray(subparray);
            }
        }
        return subparray;
    }

    private String[] longhandArray(String[] subparray) {
        LinkedList<String> list = new LinkedList<String>();
        for (String subproperty : subparray) {
            if (!this.isShorthand(subproperty)) {
                list.add(subproperty);
                continue;
            }
            this.addLonghandsToList(list, subproperty);
        }
        return list.toArray(new String[0]);
    }

    private void addLonghandsToList(LinkedList<String> list, String property) {
        if (!this.isShorthand(property)) {
            list.add(property);
        } else {
            String[] ptysubp;
            for (String pty : ptysubp = this.getShorthandSubproperties(property)) {
                this.addLonghandsToList(list, pty);
            }
        }
    }

    private void addShorthand(String shorthand, String[] subproperties) {
        this.shorthand2subp.put(shorthand, subproperties);
        for (int i = 0; i < subproperties.length; ++i) {
            String prevSh = this.subp2shorthand.get(subproperties[i]);
            if (prevSh != null) {
                String topShorthand = this.subp2shorthand.get(shorthand);
                String topPrevSh = this.subp2shorthand.get(prevSh);
                if (topShorthand == null) {
                    if (topPrevSh != null) {
                        this.subp2shorthand.put(shorthand, topPrevSh);
                    }
                } else if (topPrevSh == null) {
                    this.subp2shorthand.put(prevSh, topShorthand);
                }
            }
            this.subp2shorthand.put(subproperties[i], shorthand);
        }
    }

    public boolean isIdentifierValue(String propertyName, String value) {
        String csl = this.identifiers.getProperty(propertyName);
        if (csl == null) {
            if (propertyName.endsWith("-color")) {
                value = value.toLowerCase(Locale.ROOT);
                return ColorIdentifiers.getInstance().isColorIdentifier(value) || "transparent".equals(value);
            }
            return false;
        }
        StringTokenizer tokp = new StringTokenizer(csl, ",");
        while (tokp.hasMoreTokens()) {
            String s = tokp.nextToken();
            if (!s.trim().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public boolean hasKnownIdentifierValues(String propertyName) {
        return this.identifiers.containsKey(propertyName);
    }

    private Properties loadPropertiesfromClasspath(final String filename, final ClassLoader classLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Properties run() {
                InputStream is = classLoader != null ? classLoader.getResourceAsStream(ShorthandDatabase.this.resourcePath(filename)) : this.getClass().getResourceAsStream(ShorthandDatabase.this.resourcePath(filename));
                if (is == null) {
                    return null;
                }
                Properties p = new Properties();
                try {
                    p.load(is);
                }
                catch (IOException e) {
                    Properties properties = null;
                    return properties;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                return p;
            }
        });
    }

    private String resourcePath(String filename) {
        return '/' + ShorthandDatabase.class.getPackage().getName().replace('.', '/') + '/' + filename;
    }
}

