/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.ExtendedCSSPrimitiveValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleExpression;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

class SumExpression
extends StyleExpression
implements AlgebraicExpression {
    private final LinkedList<StyleExpression> operands = new LinkedList();

    SumExpression() {
    }

    SumExpression(SumExpression copyFrom) {
        Iterator it = copyFrom.operands.iterator();
        while (it.hasNext()) {
            this.operands.add(((StyleExpression)it.next()).clone());
        }
    }

    @Override
    void addExpression(StyleExpression expr) {
        this.operands.add(expr);
        expr.setParentExpression(this);
        if (this.nextOperandInverse) {
            expr.setInverseOperation(true);
            this.nextOperandInverse = false;
        }
    }

    @Override
    void replaceLastExpression(StyleExpression operation) {
        StyleExpression lastexpr = this.operands.removeLast();
        if (lastexpr.isInverseOperation()) {
            lastexpr.setInverseOperation(false);
            operation.setInverseOperation(true);
        }
        lastexpr.setParentExpression(null);
        operation.addExpression(lastexpr);
        operation.setParentExpression(this);
        this.operands.addLast(operation);
    }

    @Override
    public StyleExpression item(int index) {
        try {
            return this.operands.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int getLength() {
        return this.operands.size();
    }

    @Override
    public CSSExpression.AlgebraicPart getPartType() {
        return CSSExpression.AlgebraicPart.SUM;
    }

    @Override
    public int hashCode() {
        int prime = 1021;
        int result = super.hashCode();
        result = 1021 * result + (this.operands == null ? 0 : this.operands.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SumExpression other = (SumExpression)obj;
        return !(this.operands == null ? other.operands != null : !this.operands.equals(other.operands));
    }

    @Override
    public String getCssText() {
        if (this.operands.isEmpty()) {
            return "";
        }
        BufferSimpleWriter wri = new BufferSimpleWriter(32 + this.operands.size() * 16);
        try {
            this.writeCssText(wri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wri.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.operands.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(32);
        Iterator it = this.operands.iterator();
        CSSExpression expr = (CSSExpression)it.next();
        this.appendMinifiedFirstExpression(expr, buf);
        while (it.hasNext()) {
            expr = (CSSExpression)it.next();
            this.appendMinifiedExpression(expr, buf);
        }
        return buf.toString();
    }

    private void appendMinifiedFirstExpression(CSSExpression expr, StringBuilder buf) {
        boolean parens = false;
        if (expr.isInverseOperation()) {
            if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                buf.append(" - (");
                parens = true;
            } else {
                NumberValue number;
                ExtendedCSSPrimitiveValue operand;
                if (expr.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (operand = ((CSSOperandExpression)expr).getOperand()) instanceof NumberValue && (number = (NumberValue)operand).isNegativeNumber()) {
                    buf.append(" + ");
                    buf.append(number.minifyAbsolute(""));
                    return;
                }
                buf.append(" - ");
            }
        }
        buf.append(expr.getMinifiedCssText());
        if (parens) {
            buf.append(')');
        }
    }

    private void appendMinifiedExpression(CSSExpression expr, StringBuilder buf) {
        boolean parens = false;
        if (expr.isInverseOperation()) {
            if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                buf.append(" - (");
                parens = true;
            } else {
                NumberValue number;
                ExtendedCSSPrimitiveValue operand;
                if (expr.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (operand = ((CSSOperandExpression)expr).getOperand()) instanceof NumberValue && (number = (NumberValue)operand).isNegativeNumber()) {
                    buf.append(" + ");
                    buf.append(number.minifyAbsolute(""));
                    return;
                }
                buf.append(" - ");
            }
        } else {
            NumberValue number;
            ExtendedCSSPrimitiveValue operand;
            if (expr.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (operand = ((CSSOperandExpression)expr).getOperand()) instanceof NumberValue && (number = (NumberValue)operand).isNegativeNumber()) {
                buf.append(" - ");
                buf.append(number.minifyAbsolute(""));
                return;
            }
            buf.append(" + ");
        }
        buf.append(expr.getMinifiedCssText());
        if (parens) {
            buf.append(')');
        }
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        if (!this.operands.isEmpty()) {
            Iterator it = this.operands.iterator();
            StyleExpression expr = (StyleExpression)it.next();
            this.writeFirstExpression(expr, wri);
            while (it.hasNext()) {
                expr = (StyleExpression)it.next();
                this.writeExpression(expr, wri);
            }
        }
    }

    private void writeFirstExpression(StyleExpression expr, SimpleWriter wri) throws IOException {
        boolean parens = false;
        if (expr.isInverseOperation()) {
            if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                wri.write(" - (");
                parens = true;
            } else {
                NumberValue number;
                ExtendedCSSPrimitiveValue operand;
                if (expr.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (operand = ((CSSOperandExpression)((Object)expr)).getOperand()) instanceof NumberValue && (number = (NumberValue)operand).isNegativeNumber()) {
                    wri.write(" + ");
                    number.serializeAbsolute(wri);
                    return;
                }
                wri.write(" - ");
            }
        }
        expr.writeCssText(wri);
        if (parens) {
            wri.write(')');
        }
    }

    private void writeExpression(StyleExpression expr, SimpleWriter wri) throws IOException {
        boolean parens = false;
        if (expr.isInverseOperation()) {
            if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                wri.write(" - (");
                parens = true;
            } else {
                NumberValue number;
                ExtendedCSSPrimitiveValue operand;
                if (expr.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (operand = ((CSSOperandExpression)((Object)expr)).getOperand()) instanceof NumberValue && (number = (NumberValue)operand).isNegativeNumber()) {
                    wri.write(" + ");
                    number.serializeAbsolute(wri);
                    return;
                }
                wri.write(" - ");
            }
        } else {
            NumberValue number;
            ExtendedCSSPrimitiveValue operand;
            if (expr.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (operand = ((CSSOperandExpression)((Object)expr)).getOperand()) instanceof NumberValue && (number = (NumberValue)operand).isNegativeNumber()) {
                wri.write(" - ");
                number.serializeAbsolute(wri);
                return;
            }
            wri.write(" + ");
        }
        expr.writeCssText(wri);
        if (parens) {
            wri.write(')');
        }
    }

    @Override
    public SumExpression clone() {
        return new SumExpression(this);
    }

    static AlgebraicExpression createSumExpression() {
        return new SumExpression();
    }
}

