/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.nsac.LexicalUnit2;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StringValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;

public class URIValue
extends StringValue {
    public URIValue(byte flags) {
        super((short)20, flags);
    }

    protected URIValue(URIValue copied) {
        super(copied);
    }

    @Override
    public short getPrimitiveType() {
        return 20;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        LexicalUnit2 lunit;
        this.checkModifiableProperty();
        if (cssText.indexOf(40) == -1 && cssText.indexOf(41) == -1) {
            cssText = "url(" + cssText + ")";
        }
        PrimitiveValue.LexicalSetter setter = this.newLexicalSetter();
        CSSParser parser = new CSSParser();
        try {
            lunit = parser.parsePropertyValue(new InputSource((Reader)new StringReader(cssText)));
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, "Error parsing text: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            lunit = null;
        }
        if (lunit == null || lunit.getLexicalUnitType() != 24) {
            throw new DOMException(13, "Not a URI value.");
        }
        setter.setLexicalUnit(lunit);
    }

    @Override
    boolean usesDoubleQuote(String text) {
        int i = text.lastIndexOf(41);
        while (i > 0) {
            char c;
            if ((c = text.charAt(--i)) == ' ') continue;
            return c == '\"';
        }
        return false;
    }

    @Override
    protected void setUnescapedCssText(String css) {
        int idx = (css = ParseHelper.escapeBackslash(css).toString()).indexOf(39);
        if (idx != -1) {
            int len = css.length();
            StringBuilder buf = new StringBuilder(len + 8);
            buf.append(css.subSequence(0, idx));
            for (int i = idx; i < len; ++i) {
                char c = css.charAt(i);
                if (c == this.quote) {
                    buf.append('\\');
                }
                buf.append(c);
            }
            css = buf.toString();
        }
        this.setPlainCssText("url(" + this.quote + css + this.quote + ')');
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return "url(" + ParseHelper.quote(this.getStringValue(), this.quote) + ')';
    }

    public URL getURLValue() {
        URL url;
        String sv = this.getStringValue();
        try {
            url = new URL(sv);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.getCssValueType();
        result = 31 * result + this.getPrimitiveType();
        String sv = this.getStringValue();
        return 31 * result + (sv == null ? 0 : sv.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URIValue)) {
            return false;
        }
        URIValue other = (URIValue)obj;
        String sv = this.getStringValue();
        return !(sv == null ? other.getStringValue() != null : !sv.equals(other.getStringValue()));
    }

    public boolean isEquivalent(URIValue other) {
        if (this.getMinifiedCssText(null).equals(other.getMinifiedCssText(null))) {
            return true;
        }
        String sv = this.getStringValue();
        return !(sv == null ? other.getStringValue() != null : !sv.equals(other.getStringValue()));
    }

    @Override
    public URIValue clone() {
        return new URIValue(this);
    }
}

