/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.w3c.dom.DOMException;

public class URIValueWrapper
extends URIValue
implements WrappedValue {
    private final String parentSheetHref;

    public URIValueWrapper(URIValue wrapped, String oldHrefContext, String parentSheetHref) {
        super(wrapped);
        this.parentSheetHref = parentSheetHref;
        if (oldHrefContext != parentSheetHref) {
            this.setStringValue(this.getStringValue(super.getStringValue(), oldHrefContext));
        }
    }

    @Override
    public String getParentSheetHref() {
        return this.parentSheetHref;
    }

    @Override
    public String getCssText() {
        String sv = this.getStringValue();
        if (sv == null) {
            return "";
        }
        BufferSimpleWriter sw = new BufferSimpleWriter(sv.length() + 6);
        try {
            this.writeCssText(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        String sv = this.getStringValue();
        if (sv != null) {
            wri.write("url(");
            sv = ParseHelper.quote(sv, this.quote);
            wri.write(sv);
            wri.write(')');
        }
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        URI baseUri;
        URI uri;
        int lastSlash;
        String sv = this.getStringValue();
        if (sv == null) {
            return "";
        }
        if (this.parentSheetHref == null || (lastSlash = this.parentSheetHref.lastIndexOf(47)) == -1) {
            return super.getCssText();
        }
        String base = this.parentSheetHref.substring(0, lastSlash + 1);
        try {
            uri = new URI(sv);
            baseUri = new URI(base);
        }
        catch (URISyntaxException e) {
            return super.getCssText();
        }
        baseUri = baseUri.normalize();
        String reluri = baseUri.relativize(uri).toASCIIString();
        String quoted = ParseHelper.quote(reluri, this.quote);
        return "url(" + quoted + ')';
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.error();
    }

    @Override
    public String getStringValue() {
        return this.getStringValue(super.getStringValue(), this.parentSheetHref);
    }

    private String getStringValue(String relValue, String contextHref) {
        if (relValue != null) {
            if (!relValue.contains("://") && contextHref != null) {
                try {
                    URL base = new URL(contextHref);
                    URL url = new URL(base, relValue);
                    relValue = url.toExternalForm();
                }
                catch (MalformedURLException base) {
                    // empty catch block
                }
            }
            try {
                URI uri = new URI(relValue);
                relValue = uri.normalize().toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return relValue;
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        this.error();
    }

    private void error() throws DOMException {
        throw new DOMException(7, "This property is read-only computed value. Must modify at the original style sheet.");
    }

    @Override
    public URL getURLValue() {
        URL url = null;
        String sv = super.getStringValue();
        if (sv != null) {
            if (this.parentSheetHref != null) {
                try {
                    URL base = new URL(this.parentSheetHref);
                    url = new URL(base, sv);
                    return url;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            try {
                url = new URL(sv);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    @Override
    public URIValue clone() {
        return new URIValueWrapper(super.clone(), this.parentSheetHref, this.parentSheetHref);
    }
}

