/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSUnicodeRangeValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class UnicodeValue
extends PrimitiveValue
implements CSSUnicodeRangeValue.CSSUnicodeValue {
    private int codePoint = 0;

    public UnicodeValue() {
        super((short)131);
    }

    protected UnicodeValue(UnicodeValue copied) {
        super(copied);
        this.codePoint = copied.codePoint;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This property is read-only.");
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("U+");
        wri.write(Integer.toHexString(this.codePoint));
    }

    @Override
    public String getCssText() {
        return "U+" + Integer.toHexString(this.codePoint);
    }

    @Override
    public String getStringValue() throws DOMException {
        return new String(this.toChars());
    }

    @Override
    public int getCodePoint() {
        return this.codePoint;
    }

    @Override
    public void setCodePoint(int codePoint) {
        this.codePoint = codePoint;
    }

    public char[] toChars() {
        return Character.toChars(this.codePoint);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return super.hashCode() * 31 + this.codePoint;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnicodeValue other = (UnicodeValue)obj;
        return this.codePoint == other.codePoint;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public UnicodeValue clone() {
        return new UnicodeValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            UnicodeValue.this.codePoint = lunit.getIntegerValue();
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

