/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.NumberValue;

class Unit {
    private short unitType;
    private int exponent;
    private Unit nextUnit = null;

    public Unit() {
        this.unitType = 1;
        this.exponent = 0;
    }

    Unit(short unitType) {
        this.setUnitType(unitType);
    }

    public int getExponent() {
        return this.exponent;
    }

    void setExponent(int exponent) {
        this.exponent = exponent;
    }

    void incrExponent() {
        ++this.exponent;
    }

    void decrExponent() {
        --this.exponent;
    }

    public short getUnitType() {
        return this.unitType;
    }

    void setUnitType(short unitType) {
        this.unitType = unitType;
        this.exponent = unitType == 1 ? 0 : 1;
    }

    public Unit getNextUnit() {
        return this.nextUnit;
    }

    void setNextUnit(Unit nextUnit) {
        this.nextUnit = nextUnit;
    }

    public float convert(float value, short destinationUnitType) {
        if (this.exponent != 0 && this.unitType != destinationUnitType) {
            double factor = NumberValue.floatValueConversion(1.0f, this.unitType, destinationUnitType);
            if (this.exponent > 1) {
                for (int i = 2; i <= this.exponent; ++i) {
                    factor *= factor;
                }
            } else if (this.exponent < 0) {
                factor = 1.0 / factor;
                for (int i = -2; i >= this.exponent; --i) {
                    factor *= factor;
                }
            }
            return (float)((double)value * factor);
        }
        return value;
    }
}

