/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class UnknownValue
extends AbstractTextValue {
    private boolean priorityCompat = false;

    public UnknownValue() {
        super((short)0);
    }

    protected UnknownValue(UnknownValue copied) {
        super(copied);
        this.setCssText(copied.getCssText());
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        this.setPlainCssText(cssText);
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write(this.getCssText());
    }

    public boolean isPriorityCompat() {
        return this.priorityCompat;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnknownValue other = (UnknownValue)obj;
        return this.getCssText().equals(other.getCssText());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getCssText().hashCode();
        return result;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    private String guessCssText(LexicalUnit lunit) {
        try {
            return lunit.getStringValue();
        }
        catch (DOMException dOMException) {
            String text = "";
            try {
                float fv = lunit.getFloatValue();
                text = Float.toString(fv);
            }
            catch (DOMException e1) {
                try {
                    int iv = lunit.getIntegerValue();
                    text = Integer.toString(iv);
                }
                catch (DOMException dOMException2) {
                    // empty catch block
                }
            }
            try {
                String unittext = lunit.getDimensionUnitText();
                if (unittext.length() != 0) {
                    text = text + unittext;
                }
            }
            catch (DOMException dOMException3) {
                // empty catch block
            }
            return text;
        }
    }

    @Override
    public UnknownValue clone() {
        return new UnknownValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            String text;
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
            switch (lunit.getLexicalUnitType()) {
                case 6: {
                    text = "^";
                    break;
                }
                case 10: {
                    text = ">=";
                    break;
                }
                case 8: {
                    text = ">";
                    break;
                }
                case 9: {
                    text = "<=";
                    break;
                }
                case 7: {
                    text = "<";
                    break;
                }
                case 2: {
                    text = "-";
                    break;
                }
                case 5: {
                    text = "%";
                    break;
                }
                case 3: {
                    text = "*";
                    break;
                }
                case 1: {
                    text = "+";
                    break;
                }
                case 11: {
                    text = "~";
                    break;
                }
                case 72: {
                    UnknownValue.this.priorityCompat = true;
                }
                case 71: {
                    text = lunit.toString();
                    this.nextLexicalUnit = null;
                    break;
                }
                default: {
                    text = UnknownValue.this.guessCssText(lunit);
                    if (text.length() != 0) break;
                    throw new DOMException(12, "Unsuitable value: " + lunit.toString());
                }
            }
            UnknownValue.this.setPlainCssText(text);
        }
    }
}

