/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit2;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.AttrValue;
import io.sf.carte.doc.style.css.property.CalcValue;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.CounterValue;
import io.sf.carte.doc.style.css.property.CountersValue;
import io.sf.carte.doc.style.css.property.CustomPropertyValue;
import io.sf.carte.doc.style.css.property.ElementReferenceValue;
import io.sf.carte.doc.style.css.property.EnvVariableValue;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.GradientValue;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.OMCSSRectValue;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RatioValue;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.UnicodeRangeValue;
import io.sf.carte.doc.style.css.property.UnicodeWildcardValue;
import io.sf.carte.doc.style.css.property.UnknownValue;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class ValueFactory {
    private final byte flags;

    public ValueFactory() {
        this(0);
    }

    public ValueFactory(byte flags) {
        this.flags = flags;
    }

    public static boolean isSizeSACUnit(LexicalUnit unit) {
        return ValueFactory.sizeSACUnit(unit) != 0;
    }

    private static short sizeSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41) {
            type = ValueFactory.functionDimensionArgumentUnit(unit);
        } else if (type == 40) {
            type = ValueFactory.subexpressionDimensionUnit(unit);
        }
        switch (type) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return type;
            }
            case 13: {
                return unit.getIntegerValue() == 0 ? type : (short)0;
            }
        }
        return 0;
    }

    public static boolean isResolutionSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41) {
            type = ValueFactory.firstArgumentUnit(unit);
        }
        switch (type) {
            case 64: 
            case 65: 
            case 66: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPositiveSizeSACUnit(LexicalUnit unit) {
        short utype;
        short type = utype = unit.getLexicalUnitType();
        if (utype == 41) {
            type = ValueFactory.functionDimensionArgumentUnit(unit);
        }
        switch (type) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return utype == 41 || unit.getFloatValue() > 0.0f;
            }
        }
        return false;
    }

    public static boolean isSizeOrNumberSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41) {
            type = ValueFactory.functionDimensionArgumentUnit(unit);
        }
        switch (type) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPlainNumberOrPercentSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        switch (type) {
            case 13: 
            case 14: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41) {
            type = ValueFactory.firstArgumentUnit(unit);
        }
        switch (type) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAngleSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41) {
            if (ValueFactory.isColorFunction(unit)) {
                return false;
            }
            type = ValueFactory.firstArgumentUnit(unit);
        }
        switch (type) {
            case 28: 
            case 29: 
            case 30: 
            case 63: {
                return true;
            }
            case 13: {
                if (unit.getIntegerValue() != 0) break;
                return true;
            }
        }
        return false;
    }

    public static boolean isTimeSACUnit(LexicalUnit unit) {
        short type = unit.getLexicalUnitType();
        if (type == 41 && (type = ValueFactory.firstArgumentUnit(unit)) == 13) {
            return false;
        }
        switch (type) {
            case 31: 
            case 32: {
                return true;
            }
            case 13: {
                if (unit.getIntegerValue() != 0) break;
                return true;
            }
        }
        return false;
    }

    static short functionDimensionArgumentUnit(LexicalUnit lunit) {
        if (ValueFactory.isColorFunction(lunit)) {
            return -1;
        }
        LexicalUnit lu = lunit.getParameters();
        while (lu != null) {
            short type = ValueFactory.sizeSACUnit(lu);
            if (type != 0) {
                return type;
            }
            if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != 0) continue;
            lu = lu.getNextLexicalUnit();
        }
        return -1;
    }

    static short subexpressionDimensionUnit(LexicalUnit lunit) {
        LexicalUnit lu = lunit.getSubValues();
        while (lu != null) {
            short type = ValueFactory.sizeSACUnit(lu);
            if (type != 0) {
                return type;
            }
            if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != 0) continue;
            lu = lu.getNextLexicalUnit();
        }
        return -1;
    }

    private static short firstArgumentUnit(LexicalUnit lunit) {
        LexicalUnit lu = lunit.getParameters();
        if (lu != null) {
            return lu.getLexicalUnitType();
        }
        return -1;
    }

    private static boolean isColorFunction(LexicalUnit lunit) {
        String name = lunit.getFunctionName().toLowerCase(Locale.ROOT);
        return "hsl".equals(name) || "hsla".equals(name) || "hwb".equals(name) || name.endsWith("-gradient") || "rgba".equals(name);
    }

    public StyleValue parseProperty(String value) throws DOMException {
        return this.parseProperty(value, SACParserFactory.createSACParser());
    }

    public StyleValue parseProperty(String value, Parser parser) throws DOMException {
        return this.parseProperty("", value, parser);
    }

    public StyleValue parseProperty(String propertyName, String value, CSSParser parser) throws DOMException {
        StringReader re = new StringReader(value);
        LexicalUnit2 lunit = null;
        try {
            lunit = parser.parsePropertyValue(propertyName, re);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        StyleValue css = this.createCSSValue(lunit);
        if (css == null) {
            css = this.createUnknownValue(value, lunit);
        }
        return css;
    }

    public StyleValue parseProperty(String propertyName, String value, Parser parser) throws DOMException {
        InputSource source = new InputSource();
        StringReader re = new StringReader(value);
        source.setCharacterStream((Reader)re);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        StyleValue css = this.createCSSValue(lunit);
        if (css == null) {
            css = this.createUnknownValue(value, lunit);
        }
        return css;
    }

    private UnknownValue createUnknownValue(String value, LexicalUnit lunit) {
        switch (lunit.getLexicalUnitType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        UnknownValue css = new UnknownValue();
        css.setCssText(value);
        ((PrimitiveValue)css).newLexicalSetter().setLexicalUnit(lunit);
        return css;
    }

    public PrimitiveValue parseMediaFeature(String feature) throws DOMException {
        return this.parseMediaFeature(feature, new CSSParser());
    }

    public PrimitiveValue parseMediaFeature(String feature, Parser2 parser) throws DOMException {
        PrimitiveValue css;
        InputSource source = new InputSource();
        StringReader re = new StringReader(feature);
        source.setCharacterStream((Reader)re);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        try {
            css = this.createCSSPrimitiveValue(lunit, false);
        }
        catch (DOMException e) {
            return this.createUnknownValue(feature, lunit);
        }
        LexicalUnit nlu = lunit.getNextLexicalUnit();
        if (nlu != null && nlu.getLexicalUnitType() == 4) {
            if ((nlu = nlu.getNextLexicalUnit()) == null) {
                throw new DOMException(12, "Ratio lacks second value.");
            }
            PrimitiveValue css2 = this.createCSSPrimitiveValue(nlu, false);
            RatioValue ratio = new RatioValue();
            ratio.setAntecedentValue(css);
            ratio.setConsequentValue(css2);
            return ratio;
        }
        return css;
    }

    public StyleValue createCSSValue(LexicalUnit lunit) throws DOMException {
        return this.createCSSValue(lunit, null);
    }

    public StyleValue createCSSValue(LexicalUnit lunit, AbstractCSSStyleDeclaration style) throws DOMException {
        if (lunit.getNextLexicalUnit() != null) {
            StyleValue value;
            ValueList superlist = null;
            ValueList list = ValueList.createWSValueList();
            LexicalUnit nlu = lunit;
            do {
                if (nlu.getLexicalUnitType() != 68) {
                    StyleDeclarationErrorHandler errHandler;
                    ValueItem item = this.createCSSValueItem(nlu, false);
                    if (item.hasWarnings() && style != null && (errHandler = style.getStyleDeclarationErrorHandler()) != null) {
                        item.handleSyntaxWarnings(errHandler);
                    }
                    nlu = (value = item.getCSSValue()).getCssValueType() == 1 ? item.getNextLexicalUnit() : nlu.getNextLexicalUnit();
                } else {
                    if ((nlu = nlu.getNextLexicalUnit()) == null) {
                        throw new DOMException(12, "Unmatched '['");
                    }
                    ListValueItem listitem = this.parseBracketList(nlu, style, false);
                    if (listitem != null) {
                        value = listitem.getCSSValue();
                        nlu = listitem.getNextLexicalUnit();
                    } else {
                        nlu = nlu.getNextLexicalUnit();
                        continue;
                    }
                }
                if (nlu != null) {
                    if (nlu.getLexicalUnitType() == 0) {
                        nlu = nlu.getNextLexicalUnit();
                        if (superlist == null) {
                            superlist = ValueList.createCSValueList();
                        }
                        if (list.getLength() > 0) {
                            list.add(value);
                            superlist.add(list);
                            list = ValueList.createWSValueList();
                            continue;
                        }
                        superlist.add(value);
                        continue;
                    }
                    list.add(value);
                    continue;
                }
                if (superlist == null) {
                    list.add(value);
                    break;
                }
                if (list.getLength() > 0) {
                    list.add(value);
                    superlist.add(list);
                    break;
                }
                superlist.add(value);
                break;
            } while (nlu != null);
            if (superlist != null) {
                value = ValueFactory.listOrFirstItem(superlist);
                if (value.getCssValueType() == 2) {
                    return ValueFactory.listOrFirstItem((ValueList)value);
                }
                return value;
            }
            return ValueFactory.listOrFirstItem(list);
        }
        return this.createCSSValueItem(lunit, false).getCSSValue();
    }

    public ListValueItem parseBracketList(LexicalUnit nlu, AbstractCSSStyleDeclaration style, boolean subproperty) {
        ListValueItem listitem = new ListValueItem();
        listitem.list = ValueList.createBracketValueList();
        while (nlu.getLexicalUnitType() != 69) {
            StyleValue value;
            StyleDeclarationErrorHandler errHandler;
            ValueItem item = this.createCSSValueItem(nlu, subproperty);
            if (item.hasWarnings() && style != null && (errHandler = style.getStyleDeclarationErrorHandler()) != null) {
                item.handleSyntaxWarnings(errHandler);
            }
            nlu = (value = item.getCSSValue()).getCssValueType() == 1 ? item.getNextLexicalUnit() : nlu.getNextLexicalUnit();
            listitem.list.add(value);
            if (nlu != null) {
                if (nlu.getLexicalUnitType() != 0 || (nlu = nlu.getNextLexicalUnit()) != null) continue;
                throw new DOMException(12, "Unmatched '['");
            }
            throw new DOMException(12, "Unmatched '['");
        }
        if (listitem.list.getLength() != 0) {
            listitem.nextLexicalUnit = nlu.getNextLexicalUnit();
        } else {
            listitem = null;
        }
        return listitem;
    }

    private static StyleValue listOrFirstItem(ValueList list) {
        int ll = list.getLength();
        if (ll > 1) {
            return list;
        }
        if (ll == 1) {
            return list.item(0);
        }
        return null;
    }

    public ValueItem createCSSValueItem(LexicalUnit lunit, boolean subproperty) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case 12: {
                InheritValue value = InheritValue.getValue();
                if (subproperty) {
                    value = value.asSubproperty();
                }
                return value;
            }
        }
        return this.createCSSPrimitiveValueItem(lunit, subproperty);
    }

    PrimitiveValue createCSSPrimitiveValue(LexicalUnit lunit, boolean subp) throws DOMException {
        return this.createCSSPrimitiveValueItem(lunit, subp).getCSSValue();
    }

    PrimitiveValue.LexicalSetter createCSSPrimitiveValueItem(LexicalUnit lunit, boolean subp) throws DOMException {
        PrimitiveValue.LexicalSetter setter;
        PrimitiveValue primi;
        short unitType = lunit.getLexicalUnitType();
        try {
            switch (unitType) {
                case 35: {
                    primi = new IdentifierValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 37: {
                    primi = new AttrValue(this.flags);
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 36: {
                    primi = new StringValue(this.flags);
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 24: {
                    primi = new URIValue(this.flags);
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 23: {
                    primi = new PercentageValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 42: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    primi = new NumberValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    ((NumberValue)primi).lengthUnitType = true;
                    break;
                }
                case 14: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: {
                    primi = new NumberValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 13: {
                    primi = new NumberValue();
                    ((NumberValue)primi).setIntegerValue(lunit.getIntegerValue());
                    setter = primi.newLexicalSetter();
                    primi.newLexicalSetter().nextLexicalUnit = lunit.getNextLexicalUnit();
                    break;
                }
                case 27: {
                    primi = new ColorValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 41: {
                    String func = lunit.getFunctionName().toLowerCase(Locale.ROOT);
                    if ("rgb".equals(func) || "rgba".equals(func) || "hsl".equals(func) || "hsla".equals(func) || "hwb".equals(func)) {
                        primi = new ColorValue();
                    } else if ("calc".equals(func)) {
                        primi = new CalcValue();
                    } else {
                        if (func.endsWith("linear-gradient") || func.endsWith("radial-gradient") || func.endsWith("conic-gradient")) {
                            primi = new GradientValue();
                            setter = primi.newLexicalSetter();
                            try {
                                setter.setLexicalUnit(lunit);
                                break;
                            }
                            catch (RuntimeException e) {
                                if (func.charAt(0) == '-') {
                                    primi = new FunctionValue();
                                    setter = primi.newLexicalSetter();
                                    setter.setLexicalUnit(lunit);
                                    break;
                                }
                                throw e;
                            }
                        }
                        primi = "var".equals(func) ? this.createCustomProperty(lunit) : ("env".equals(func) ? new EnvVariableValue() : new FunctionValue());
                    }
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 39: {
                    primi = new UnicodeRangeValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 70: {
                    primi = new UnicodeWildcardValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 38: {
                    primi = new OMCSSRectValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 25: {
                    primi = new CounterValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 26: {
                    primi = new CountersValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 73: {
                    primi = new ElementReferenceValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                    break;
                }
                case 0: {
                    throw new DOMException(12, "A comma is not a valid primitive");
                }
                default: {
                    primi = new UnknownValue();
                    setter = primi.newLexicalSetter();
                    setter.setLexicalUnit(lunit);
                }
            }
        }
        catch (DOMException e) {
            throw e;
        }
        catch (RuntimeException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        primi.setSubproperty(subp);
        return setter;
    }

    private PrimitiveValue createCustomProperty(LexicalUnit lunit) {
        CustomPropertyValue primi;
        LexicalUnit lu = lunit.getParameters();
        if (lu == null || lu.getLexicalUnitType() != 35) {
            throw new DOMException(17, "Variable name must be an identifier");
        }
        if ((lu = lu.getNextLexicalUnit()) != null) {
            if (lu.getLexicalUnitType() != 0) {
                throw new DOMException(12, "Fallback must be separated by comma");
            }
            if ((lu = lu.getNextLexicalUnit()) == null) {
                throw new DOMException(12, "No fallback found after comma");
            }
            StyleValue fallback = this.createCSSValue(lu);
            primi = new CustomPropertyValue(fallback);
        } else {
            primi = new CustomPropertyValue();
        }
        return primi;
    }

    public LexicalUnit appendValueString(StringBuilder buf, LexicalUnit lunit) {
        LexicalUnit nlu;
        short type = lunit.getLexicalUnitType();
        if (type == 0) {
            nlu = lunit.getNextLexicalUnit();
            buf.append(',');
        } else if (type == 4) {
            nlu = lunit.getNextLexicalUnit();
            buf.append(' ').append('/');
        } else if (type != 68) {
            ValueItem item = this.createCSSValueItem(lunit, true);
            nlu = item.getNextLexicalUnit();
            StyleValue cssValue = item.getCSSValue();
            String cssText = cssValue.getCssText();
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append(cssText);
        } else {
            nlu = lunit.getNextLexicalUnit();
            ListValueItem item = this.parseBracketList(nlu, null, false);
            if (item != null) {
                nlu = item.getNextLexicalUnit();
                buf.append(item.getCSSValue().getCssText());
            } else {
                nlu = nlu.getNextLexicalUnit();
            }
        }
        return nlu;
    }

    public LexicalUnit appendMinifiedValueString(StringBuilder buf, LexicalUnit lunit) {
        LexicalUnit nlu;
        short type = lunit.getLexicalUnitType();
        if (type == 0) {
            nlu = lunit.getNextLexicalUnit();
            buf.append(',');
        } else if (type == 4) {
            nlu = lunit.getNextLexicalUnit();
            buf.append('/');
        } else if (type != 68) {
            char c;
            ValueItem item = this.createCSSValueItem(lunit, true);
            nlu = item.getNextLexicalUnit();
            StyleValue cssValue = item.getCSSValue();
            String cssText = cssValue.getMinifiedCssText("");
            int len = buf.length();
            if (len != 0 && (c = buf.charAt(len - 1)) != ',' && c != '/') {
                buf.append(' ');
            }
            buf.append(cssText);
        } else {
            nlu = lunit.getNextLexicalUnit();
            ListValueItem item = this.parseBracketList(nlu, null, false);
            if (item != null) {
                nlu = item.getNextLexicalUnit();
                buf.append(item.getCSSValue().getMinifiedCssText(""));
            } else {
                nlu = nlu.getNextLexicalUnit();
            }
        }
        return nlu;
    }

    public boolean hasFactoryFlag(byte flag) {
        return (this.flags & flag) == flag;
    }

    static short domPrimitiveType(LexicalUnit lunit) {
        short primiType;
        short sacType = lunit.getLexicalUnitType();
        if (sacType == 41) {
            LexicalUnit lu = lunit.getParameters();
            while (lu != null) {
                if (ValueFactory.isNumericSACUnit(lu)) {
                    return 1;
                }
                if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != 0) continue;
                lu = lu.getNextLexicalUnit();
            }
            primiType = 0;
        } else {
            primiType = ValueFactory.domPrimitiveType(sacType);
        }
        return primiType;
    }

    public static short domPrimitiveType(short sacType) {
        short primiType;
        switch (sacType) {
            case 37: {
                primiType = 22;
                break;
            }
            case 35: {
                primiType = 21;
                break;
            }
            case 36: {
                primiType = 19;
                break;
            }
            case 24: {
                primiType = 20;
                break;
            }
            case 19: {
                primiType = 6;
                break;
            }
            case 28: {
                primiType = 11;
                break;
            }
            case 42: {
                primiType = 18;
                break;
            }
            case 15: {
                primiType = 3;
                break;
            }
            case 16: {
                primiType = 4;
                break;
            }
            case 29: {
                primiType = 13;
                break;
            }
            case 33: {
                primiType = 16;
                break;
            }
            case 18: {
                primiType = 8;
                break;
            }
            case 34: {
                primiType = 17;
                break;
            }
            case 20: {
                primiType = 7;
                break;
            }
            case 31: {
                primiType = 14;
                break;
            }
            case 23: {
                primiType = 2;
                break;
            }
            case 22: {
                primiType = 10;
                break;
            }
            case 17: {
                primiType = 5;
                break;
            }
            case 21: {
                primiType = 9;
                break;
            }
            case 30: {
                primiType = 12;
                break;
            }
            case 32: {
                primiType = 15;
                break;
            }
            case 13: 
            case 14: {
                primiType = 1;
                break;
            }
            case 27: {
                primiType = 25;
                break;
            }
            case 50: {
                primiType = 26;
                break;
            }
            case 51: {
                primiType = 27;
                break;
            }
            case 52: {
                primiType = 28;
                break;
            }
            case 54: {
                primiType = 29;
                break;
            }
            case 62: {
                primiType = 30;
                break;
            }
            case 53: {
                primiType = 31;
                break;
            }
            case 55: {
                primiType = 32;
                break;
            }
            case 63: {
                primiType = 33;
                break;
            }
            case 59: {
                primiType = 34;
                break;
            }
            case 57: {
                primiType = 35;
                break;
            }
            case 58: {
                primiType = 36;
                break;
            }
            case 61: {
                primiType = 37;
                break;
            }
            case 60: {
                primiType = 38;
                break;
            }
            case 56: {
                primiType = 39;
                break;
            }
            case 65: {
                primiType = 41;
                break;
            }
            case 64: {
                primiType = 40;
                break;
            }
            case 66: {
                primiType = 42;
                break;
            }
            case 67: {
                primiType = 43;
                break;
            }
            case 39: {
                primiType = 130;
                break;
            }
            case 70: {
                primiType = 132;
                break;
            }
            case 73: {
                primiType = 133;
                break;
            }
            case 38: {
                primiType = 24;
                break;
            }
            case 25: {
                primiType = 23;
                break;
            }
            case 26: {
                primiType = 134;
                break;
            }
            default: {
                primiType = 0;
            }
        }
        return primiType;
    }

    public static class ListValueItem
    extends BasicValueItem {
        private ValueList list = null;

        @Override
        public ValueList getCSSValue() {
            return this.list;
        }
    }

    static class BasicValueItem
    implements ValueItem {
        LexicalUnit nextLexicalUnit = null;

        BasicValueItem() {
        }

        @Override
        public StyleValue getCSSValue() {
            return null;
        }

        @Override
        public LexicalUnit getNextLexicalUnit() {
            return this.nextLexicalUnit;
        }

        @Override
        public boolean hasWarnings() {
            return false;
        }

        @Override
        public void handleSyntaxWarnings(StyleDeclarationErrorHandler handler) {
        }
    }
}

