/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.ExtendedCSSValue;
import io.sf.carte.doc.style.css.ExtendedCSSValueList;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.URIValueWrapper;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public abstract class ValueList
extends StyleValue
implements ExtendedCSSValueList<StyleValue> {
    protected final List<StyleValue> valueList;

    private ValueList() {
        super((short)2);
        this.valueList = new ArrayList<StyleValue>();
    }

    private ValueList(ValueList copy) {
        super((short)2);
        this.valueList = new ArrayList<StyleValue>(copy.valueList);
    }

    @Override
    public int getLength() {
        return this.valueList.size();
    }

    @Override
    public StyleValue item(int index) {
        if (index < 0 || index >= this.valueList.size()) {
            return null;
        }
        return this.valueList.get(index);
    }

    @Override
    public Iterator<StyleValue> iterator() {
        return this.valueList.iterator();
    }

    @Override
    public boolean add(StyleValue value) {
        if (value == null) {
            throw new NullPointerException("Null value added to CSSValueList");
        }
        return this.valueList.add(value);
    }

    public boolean addAll(ValueList list) {
        if (list == null) {
            throw new NullPointerException("Null list added to CSSValueList");
        }
        if (this.isCommaSeparated() != list.isCommaSeparated() || this.isBracketList() != list.isBracketList()) {
            throw new DOMException(13, "Attempted to add lists of different types");
        }
        return this.valueList.addAll(list.valueList);
    }

    @Override
    public StyleValue remove(int index) {
        return this.valueList.remove(index);
    }

    @Override
    public StyleValue set(int index, StyleValue value) {
        if (value == null) {
            throw new NullPointerException("Null value set to CSSValueList");
        }
        return this.valueList.set(index, value);
    }

    @Override
    public boolean isEmpty() {
        return this.valueList.isEmpty();
    }

    @Override
    public void clear() {
        this.valueList.clear();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode() * 31;
        if (this.valueList != null) {
            for (ExtendedCSSValue extendedCSSValue : this.valueList) {
                result = 31 * result + (extendedCSSValue == null ? 0 : extendedCSSValue.hashCode());
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueList other = (ValueList)obj;
        if (this.valueList.isEmpty()) {
            if (!other.valueList.isEmpty()) {
                return false;
            }
        } else {
            if (this.valueList.size() != other.valueList.size()) {
                return false;
            }
            int sz = this.valueList.size();
            for (int i = 0; i < sz; ++i) {
                ExtendedCSSValue item = this.valueList.get(i);
                ExtendedCSSValue oitem = other.valueList.get(i);
                if (!(item == null ? oitem != null : !item.equals(oitem))) continue;
                return false;
            }
        }
        return true;
    }

    public void setSubproperty(boolean subp) {
        if (this.valueList != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                StyleValue val = this.item(i);
                if (val.getCssValueType() == 1) {
                    ((PrimitiveValue)val).setSubproperty(true);
                    continue;
                }
                if (val.getCssValueType() == 0) {
                    this.set(i, ((InheritValue)val).asSubproperty());
                    continue;
                }
                if (val.getCssValueType() != 2) continue;
                ((ValueList)val).setSubproperty(true);
            }
        }
    }

    @Override
    public boolean isSubproperty() {
        if (this.valueList != null) {
            Iterator<StyleValue> it = this.valueList.iterator();
            while (it.hasNext()) {
                if (it.next().isSubproperty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This value has to be modified by accessing its elements.");
    }

    public abstract boolean isCommaSeparated();

    public boolean isBracketList() {
        return false;
    }

    @Override
    public abstract ValueList clone();

    public static ValueList createCSValueList() {
        return new CSValueList();
    }

    public static ValueList createWSValueList() {
        return new WSValueList();
    }

    public static ValueList createBracketValueList() {
        return new BracketValueList();
    }

    public abstract ValueList wrap(String var1, String var2);

    private static class CSValueList
    extends ValueList {
        private CSValueList() {
        }

        private CSValueList(ValueList copy) {
            super(copy);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "";
            }
            BufferSimpleWriter sw = new BufferSimpleWriter(this.valueList.size() * 24 + 16);
            try {
                this.writeCssText(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        @Override
        public String getMinifiedCssText(String propertyName) {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((StyleValue)this.item(0)).getMinifiedCssText(propertyName));
            int sz = this.valueList.size();
            for (int i = 1; i < sz; ++i) {
                buf.append(',').append(((StyleValue)this.item(i)).getMinifiedCssText(propertyName));
            }
            return buf.toString();
        }

        @Override
        public void writeCssText(SimpleWriter wri) throws IOException {
            if (!this.valueList.isEmpty()) {
                ((StyleValue)this.valueList.get(0)).writeCssText(wri);
                int sz = this.valueList.size();
                for (int i = 1; i < sz; ++i) {
                    wri.write(',');
                    wri.write(' ');
                    ((StyleValue)this.valueList.get(i)).writeCssText(wri);
                }
            }
        }

        @Override
        public boolean isCommaSeparated() {
            return true;
        }

        @Override
        public ValueList clone() {
            return new CSValueList(this);
        }

        @Override
        public ValueList wrap(String oldHrefContext, String parentSheetHref) {
            return new CSValueListWrapper(this, oldHrefContext, parentSheetHref);
        }

        public static class CSValueListWrapper
        extends CSValueList
        implements WrappedValue {
            private final String oldHrefContext;
            private final String parentSheetHref;

            CSValueListWrapper(ValueList copy, String oldHrefContext, String parentSheetHref) {
                super(copy);
                this.parentSheetHref = parentSheetHref;
                this.oldHrefContext = oldHrefContext;
            }

            @Override
            public String getParentSheetHref() {
                return this.parentSheetHref;
            }

            @Override
            public StyleValue item(int index) {
                ExtendedCSSValue val = super.item(index);
                if (val != null && ((StyleValue)val).getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)val)).getPrimitiveType() == 20) {
                    return new URIValueWrapper((URIValue)val, this.oldHrefContext, this.parentSheetHref);
                }
                return val;
            }

            @Override
            public ValueList clone() {
                return new CSValueListWrapper(super.clone(), this.oldHrefContext, this.parentSheetHref);
            }
        }
    }

    private static class WSValueList
    extends ValueList {
        private WSValueList() {
        }

        private WSValueList(ValueList copy) {
            super(copy);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "";
            }
            BufferSimpleWriter sw = new BufferSimpleWriter(this.valueList.size() * 24 + 16);
            try {
                this.writeCssText(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        @Override
        public String getMinifiedCssText(String propertyName) {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((StyleValue)this.item(0)).getMinifiedCssText(propertyName));
            int sz = this.valueList.size();
            for (int i = 1; i < sz; ++i) {
                buf.append(' ').append(((StyleValue)this.item(i)).getMinifiedCssText(propertyName));
            }
            return buf.toString();
        }

        @Override
        public void writeCssText(SimpleWriter wri) throws IOException {
            if (!this.valueList.isEmpty()) {
                ((StyleValue)this.valueList.get(0)).writeCssText(wri);
                int sz = this.valueList.size();
                for (int i = 1; i < sz; ++i) {
                    wri.write(' ');
                    ((StyleValue)this.valueList.get(i)).writeCssText(wri);
                }
            }
        }

        @Override
        public boolean isCommaSeparated() {
            return false;
        }

        @Override
        public ValueList clone() {
            return new WSValueList(this);
        }

        @Override
        public ValueList wrap(String oldHrefContext, String parentSheetHref) {
            return new WSValueListWrapper(this, oldHrefContext, parentSheetHref);
        }

        public static class WSValueListWrapper
        extends WSValueList
        implements WrappedValue {
            private final String parentSheetHref;
            final String oldHrefContext;

            WSValueListWrapper(ValueList copy, String oldHrefContext, String parentSheetHref) {
                super(copy);
                this.parentSheetHref = parentSheetHref;
                this.oldHrefContext = oldHrefContext;
            }

            @Override
            public String getParentSheetHref() {
                return this.parentSheetHref;
            }

            @Override
            public StyleValue item(int index) {
                ExtendedCSSValue val = super.item(index);
                if (val != null && ((StyleValue)val).getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)val)).getPrimitiveType() == 20) {
                    return new URIValueWrapper((URIValue)val, this.oldHrefContext, this.parentSheetHref);
                }
                return val;
            }

            @Override
            public ValueList clone() {
                return new WSValueListWrapper(super.clone(), this.oldHrefContext, this.parentSheetHref);
            }
        }
    }

    private static class BracketValueList
    extends ValueList {
        private BracketValueList() {
        }

        private BracketValueList(BracketValueList copy) {
            super(copy);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "[]";
            }
            BufferSimpleWriter sw = new BufferSimpleWriter(this.valueList.size() * 24 + 18);
            try {
                this.writeCssText(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        @Override
        public String getMinifiedCssText(String propertyName) {
            if (this.valueList.isEmpty()) {
                return "[]";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append('[').append(((StyleValue)this.item(0)).getCssText());
            int sz = this.valueList.size();
            for (int i = 1; i < sz; ++i) {
                buf.append(' ').append(((StyleValue)this.item(i)).getMinifiedCssText(propertyName));
            }
            buf.append(']');
            return buf.toString();
        }

        @Override
        public void writeCssText(SimpleWriter wri) throws IOException {
            if (!this.valueList.isEmpty()) {
                wri.write('[');
                ((StyleValue)this.valueList.get(0)).writeCssText(wri);
                int sz = this.valueList.size();
                for (int i = 1; i < sz; ++i) {
                    wri.write(' ');
                    ((StyleValue)this.valueList.get(i)).writeCssText(wri);
                }
                wri.write(']');
            } else {
                wri.write("[]");
            }
        }

        @Override
        public boolean isBracketList() {
            return true;
        }

        @Override
        public boolean isCommaSeparated() {
            return false;
        }

        @Override
        public ValueList clone() {
            return new BracketValueList(this);
        }

        @Override
        public ValueList wrap(String oldHrefContext, String parentSheetHref) {
            return new BracketValueListWrapper(this, oldHrefContext, parentSheetHref);
        }

        public static class BracketValueListWrapper
        extends WSValueList.WSValueListWrapper {
            BracketValueListWrapper(ValueList copy, String oldHrefContext, String parentSheetHref) {
                super(copy, oldHrefContext, parentSheetHref);
            }

            @Override
            public ValueList clone() {
                return new BracketValueListWrapper(super.clone(), this.oldHrefContext, this.getParentSheetHref());
            }
        }
    }
}

