/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.xml.dtd;

import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenHandler;
import io.sf.carte.uparser.TokenProducer;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class EntityFinder {
    private final EntityResolver2 resolver;

    public EntityFinder(EntityResolver2 resolver) {
        this.resolver = resolver;
    }

    public int findEntities(Map<Integer, String> codePoint2Entity, Reader dtdReader) throws IOException {
        DTDTokenHandler handler = new DTDTokenHandler(codePoint2Entity);
        int[] allowInWords = new int[]{60, 33};
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        try {
            tp.parse(dtdReader, "<!--", "-->");
        }
        catch (StopParsingException stopParsingException) {
            // empty catch block
        }
        return handler.mapCount;
    }

    private class DTDTokenHandler
    implements TokenHandler {
        private final Map<Integer, String> codePoint2Entity;
        private int mapCount = 0;
        private final int mapInitialSize;
        private byte stage = 0;
        private String lastEntity = null;

        DTDTokenHandler(Map<Integer, String> codePoint2Entity) {
            this.codePoint2Entity = codePoint2Entity;
            this.mapInitialSize = codePoint2Entity.size();
        }

        @Override
        public void tokenControl(TokenControl control) {
        }

        @Override
        public void word(int index, CharSequence word) {
            if ("<!ENTITY".contentEquals(word)) {
                this.stage = 1;
            } else if (this.stage == 1) {
                this.lastEntity = word.toString();
                this.stage = (byte)2;
            } else if (this.stage == 10) {
                if ("SYSTEM".contentEquals(word)) {
                    this.stage = (byte)11;
                }
            } else {
                this.stage = (byte)-1;
            }
        }

        @Override
        public void separator(int index, int codePoint) {
        }

        @Override
        public void quoted(int index, CharSequence quoted, int quote) {
            if (this.stage == 2) {
                int cp;
                if (quoted.charAt(2) == 'x') {
                    String s = quoted.subSequence(3, quoted.length() - 1).toString();
                    try {
                        cp = Integer.parseInt(s, 16);
                    }
                    catch (NumberFormatException e) {
                        this.stage = (byte)-1;
                        return;
                    }
                }
                String s = quoted.subSequence(2, quoted.length() - 1).toString();
                try {
                    cp = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    this.stage = (byte)-1;
                    return;
                }
                if (this.codePoint2Entity.containsKey(cp) && this.codePoint2Entity.get(cp) == null) {
                    this.codePoint2Entity.put(cp, this.lastEntity);
                    ++this.mapCount;
                    if (this.mapCount + this.mapInitialSize == this.codePoint2Entity.size()) {
                        throw new StopParsingException();
                    }
                }
                this.stage = (byte)3;
            } else if (this.stage == 11) {
                try {
                    InputSource is = EntityFinder.this.resolver.resolveEntity(null, quoted.toString());
                    if (is != null) {
                        this.mapCount += EntityFinder.this.findEntities(this.codePoint2Entity, is.getCharacterStream());
                        if (this.mapCount + this.mapInitialSize == this.codePoint2Entity.size()) {
                            throw new StopParsingException();
                        }
                    }
                }
                catch (IOException | SAXException exception) {
                    // empty catch block
                }
                this.stage = 0;
            }
        }

        @Override
        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
        }

        @Override
        public void quotedNewlineChar(int index, int codePoint) {
        }

        @Override
        public void openGroup(int index, int codePoint) {
            this.stage = (byte)-1;
        }

        @Override
        public void closeGroup(int index, int codePoint) {
            this.stage = (byte)-1;
        }

        @Override
        public void character(int index, int codePoint) {
            if (codePoint == 62) {
                this.stage = 0;
            } else if (codePoint == 37 && this.stage == 1) {
                this.stage = (byte)10;
            }
        }

        @Override
        public void escaped(int index, int codePoint) {
        }

        @Override
        public void control(int index, int codePoint) {
        }

        @Override
        public void commented(int index, int commentType, String comment) {
        }

        @Override
        public void endOfStream(int len) {
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
        }
    }

    private class StopParsingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        StopParsingException() {
        }
    }
}

