/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.util;

import io.sf.carte.util.SimpleWriter;
import java.io.IOException;

public class BufferSimpleWriter
implements SimpleWriter {
    private final StringBuilder buffer;

    public BufferSimpleWriter() {
        this.buffer = new StringBuilder(128);
    }

    public BufferSimpleWriter(int initialCapacity) {
        this.buffer = new StringBuilder(initialCapacity);
    }

    public int length() {
        return this.buffer.length();
    }

    @Override
    public void newLine() throws IOException {
        this.buffer.append('\n');
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void unwrite() {
        int len = this.buffer.length();
        if (len != 0) {
            this.buffer.setLength(len - 1);
        }
    }

    public void unwrite(int numChars) {
        int len = this.buffer.length() - numChars;
        if (len < 0) {
            len = 0;
        }
        this.buffer.setLength(len);
    }

    @Override
    public void write(CharSequence s) throws IOException {
        this.buffer.append(s);
    }

    @Override
    public void write(char[] cbuf, int offset, int len) throws IOException {
        this.buffer.append(cbuf, offset, len);
    }

    @Override
    public void write(char c) throws IOException {
        this.buffer.append(c);
    }

    @Override
    public void write(int num) throws IOException {
        this.buffer.append(num);
    }
}

