/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob;

import io.skodjob.annotations.Label;
import io.skodjob.annotations.Step;
import io.skodjob.annotations.TestDoc;
import io.skodjob.common.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class FmfGenerator {
    private FmfGenerator() {
    }

    public static void generate(Class<?> testClass, String classFilePath) throws IOException {
        List<Method> methods = Arrays.stream(testClass.getDeclaredMethods()).filter(method -> method.getAnnotation(TestDoc.class) != null).sorted(Comparator.comparing(Method::getName)).toList();
        if (!methods.isEmpty()) {
            PrintWriter printWriter = Utils.createFilesForTestClass(classFilePath);
            FmfGenerator.generateDocumentationForTestCases(printWriter, methods);
            printWriter.close();
        }
    }

    private static void generateDocumentationForTestCases(PrintWriter writer, List<Method> methods) {
        if (!methods.isEmpty()) {
            methods.forEach(method -> {
                TestDoc testDoc = method.getAnnotation(TestDoc.class);
                if (testDoc != null) {
                    FmfGenerator.createTestRecord(writer, testDoc, method.getName());
                }
            });
        }
    }

    public static void createTestRecord(PrintWriter write, TestDoc testDoc, String methodName) {
        HashMap<String, Object> testCaseData = new HashMap<String, Object>();
        testCaseData.put("summary", methodName);
        String description = String.format("%s\n", testDoc.description().value());
        testCaseData.put("description", description);
        if (!Objects.equals(testDoc.contact().name(), "")) {
            testCaseData.put("contact", String.format("%s <%s>", testDoc.contact().name(), testDoc.contact().email()));
        }
        if (testDoc.labels().length > 0) {
            testCaseData.put("labels", FmfGenerator.createLabels(testDoc.labels()));
        }
        if (testDoc.steps().length > 0) {
            testCaseData.put("steps", FmfGenerator.createListOfSteps(testDoc.steps()));
        }
        HashMap<String, HashMap<String, Object>> yamlData = new HashMap<String, HashMap<String, Object>>();
        String testCaseKey = String.format("/%s", methodName);
        yamlData.put(testCaseKey, testCaseData);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        yaml.dump(yamlData, (Writer)write);
        write.println();
    }

    private static List<Map<String, String>> createListOfSteps(Step[] steps) {
        ArrayList<Map<String, String>> listOfSteps = new ArrayList<Map<String, String>>();
        for (Step step : steps) {
            HashMap<String, String> stepMap = new HashMap<String, String>();
            stepMap.put("step", step.value());
            stepMap.put("result", step.expected());
            listOfSteps.add(stepMap);
        }
        return listOfSteps;
    }

    private static List<String> createLabels(Label[] labels) {
        ArrayList<String> fmfLabels = new ArrayList<String>();
        Arrays.stream(labels).forEach(testLabel -> fmfLabels.add(testLabel.value()));
        return fmfLabels;
    }
}

