/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob;

import io.skodjob.annotations.Label;
import io.skodjob.annotations.Step;
import io.skodjob.annotations.SuiteDoc;
import io.skodjob.annotations.TestDoc;
import io.skodjob.common.Utils;
import io.skodjob.markdown.Header;
import io.skodjob.markdown.Line;
import io.skodjob.markdown.Table;
import io.skodjob.markdown.TextList;
import io.skodjob.markdown.TextStyle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MdGenerator {
    private static final String LABELS = "labels";
    private static Map<String, Map<String, String>> labelsMap = new HashMap<String, Map<String, String>>();

    private MdGenerator() {
    }

    public static void generate(Class<?> testClass, String docsDirPath, String classFilePath) throws IOException {
        SuiteDoc suiteDoc = testClass.getAnnotation(SuiteDoc.class);
        String classFilePathFull = docsDirPath + classFilePath;
        List<Method> methods = Arrays.stream(testClass.getDeclaredMethods()).filter(method -> method.getAnnotation(TestDoc.class) != null).sorted(Comparator.comparing(Method::getName)).toList();
        if (suiteDoc != null || !methods.isEmpty()) {
            PrintWriter printWriter = Utils.createFilesForTestClass(classFilePathFull);
            printWriter.println(Header.firstLevelHeader(testClass.getSimpleName()));
            String labelsFilesPath = MdGenerator.computePathToLabelFiles(classFilePath);
            MdGenerator.generateDocumentationForTestSuite(printWriter, labelsFilesPath, classFilePathFull, suiteDoc);
            MdGenerator.generateDocumentationForTestCases(printWriter, labelsFilesPath, classFilePathFull, methods);
            printWriter.close();
        }
    }

    private static void generateDocumentationForTestSuite(PrintWriter writer, String labelsFilesPath, String classFilePath, SuiteDoc suiteDoc) {
        if (suiteDoc != null) {
            MdGenerator.createSuiteRecord(writer, labelsFilesPath, classFilePath, suiteDoc);
        }
    }

    private static void generateDocumentationForTestCases(PrintWriter writer, String labelsFilesPath, String classFilePath, List<Method> methods) {
        if (!methods.isEmpty()) {
            methods.forEach(method -> {
                TestDoc testDoc = method.getAnnotation(TestDoc.class);
                if (testDoc != null) {
                    MdGenerator.createTestRecord(writer, testDoc, labelsFilesPath, classFilePath, method.getName());
                }
            });
        }
    }

    public static void createTestRecord(PrintWriter write, TestDoc testDoc, String labelsFilesPath, String classFilePath, String methodName) {
        write.println();
        write.println(Header.secondLevelHeader(methodName));
        write.println();
        write.println(TextStyle.boldText("Description:") + " " + testDoc.description().value());
        write.println();
        if (!Objects.equals(testDoc.contact().name(), "")) {
            write.println(TextStyle.boldText("Contact:") + " `" + testDoc.contact().name() + " <" + testDoc.contact().email() + ">`");
            write.println();
        }
        if (testDoc.steps().length != 0) {
            write.println(TextStyle.boldText("Steps:"));
            write.println();
            write.println(MdGenerator.createTableOfSteps(testDoc.steps()));
        }
        if (testDoc.labels().length != 0) {
            write.println(TextStyle.boldText("Labels:"));
            write.println();
            List<String> labelsWithLinks = MdGenerator.createLabelsLink(testDoc.labels(), labelsFilesPath, classFilePath);
            write.println(TextList.createUnorderedList(labelsWithLinks));
            Arrays.stream(testDoc.labels()).forEach(label -> {
                Map existingMap = labelsMap.getOrDefault(label.value(), new HashMap());
                existingMap.put(methodName, classFilePath);
                labelsMap.put(label.value(), existingMap);
            });
        }
    }

    public static void createSuiteRecord(PrintWriter write, String labelsFilesPath, String classFilePath, SuiteDoc suiteDoc) {
        write.println();
        write.println(TextStyle.boldText("Description:") + " " + suiteDoc.description().value());
        write.println();
        if (!Objects.equals(suiteDoc.contact().name(), "")) {
            write.println(TextStyle.boldText("Contact:") + " `" + suiteDoc.contact().name() + " <" + suiteDoc.contact().email() + ">`");
            write.println();
        }
        if (suiteDoc.beforeTestSteps().length != 0) {
            write.println(TextStyle.boldText("Before tests execution steps:"));
            write.println();
            write.println(MdGenerator.createTableOfSteps(suiteDoc.beforeTestSteps()));
        }
        if (suiteDoc.afterTestSteps().length != 0) {
            write.println(TextStyle.boldText("After tests execution steps:"));
            write.println();
            write.println(MdGenerator.createTableOfSteps(suiteDoc.afterTestSteps()));
        }
        if (suiteDoc.labels().length != 0) {
            write.println(TextStyle.boldText("Labels:"));
            write.println();
            write.println(TextList.createUnorderedList(MdGenerator.createLabelsLink(suiteDoc.labels(), labelsFilesPath, classFilePath)));
        }
        write.println(Line.horizontalLine());
    }

    private static String createTableOfSteps(Step[] steps) {
        ArrayList<String> tableRows = new ArrayList<String>();
        List<String> headers = List.of("Step", "Action", "Result");
        for (int i = 0; i < steps.length; ++i) {
            tableRows.add(Table.createRow(i + 1 + ".", steps[i].value(), steps[i].expected()));
        }
        return Table.createTable(headers, tableRows);
    }

    private static List<String> createLabels(Label[] labels) {
        ArrayList<String> usesText = new ArrayList<String>();
        Arrays.stream(labels).forEach(testLabel -> usesText.add("`" + testLabel.value() + "`"));
        return usesText;
    }

    private static List<String> createLabelsLink(Label[] labels, String labelsFilePath, String classFilePath) {
        ArrayList<String> labelsWithLinks = new ArrayList<String>();
        Arrays.stream(labels).forEach(label -> {
            String pureLabel = label.value().replace("`", "");
            Path path = Paths.get(classFilePath, new String[0]);
            if (new File(path.getParent() + "/" + labelsFilePath + "/" + pureLabel + ".md").exists()) {
                labelsWithLinks.add("[" + pureLabel + "](" + labelsFilePath + "/" + pureLabel + ".md)");
            } else {
                labelsWithLinks.add("`" + pureLabel + "` (description file doesn't exist)");
            }
        });
        return labelsWithLinks;
    }

    private static void updateLabelFile(String labelFilePath, String updatedData) {
        try {
            File markdownFile = new File(labelFilePath);
            StringBuilder fileContent = new StringBuilder();
            boolean foundGeneratedPart = false;
            try (BufferedReader reader = new BufferedReader(new FileReader(markdownFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("<!-- generated part -->")) {
                        foundGeneratedPart = true;
                        fileContent.append(line).append("\n");
                        break;
                    }
                    fileContent.append(line).append("\n");
                }
            }
            if (!foundGeneratedPart) {
                fileContent.append("\n<!-- generated part -->\n");
            }
            fileContent.append(updatedData).append("\n");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(markdownFile));){
                writer.write(fileContent.toString());
            }
            System.out.println("Content of %s updated successfully!".formatted(labelFilePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateLinksInLabels(String docsPath) {
        String labelsPath = docsPath + LABELS;
        if (Files.exists(new File(labelsPath).toPath(), new LinkOption[0])) {
            for (Map.Entry<String, Map<String, String>> entry : labelsMap.entrySet()) {
                String labelsFile = labelsPath + "/" + entry.getKey() + ".md";
                if (Files.exists(new File(labelsFile).toPath(), new LinkOption[0])) {
                    StringBuilder newText = new StringBuilder("**Tests:**");
                    for (Map.Entry<String, String> item : entry.getValue().entrySet()) {
                        String data = String.format("[%s](%s%s)", item.getKey(), "../", item.getValue().replace(docsPath, ""));
                        newText.append("\n- ").append(data);
                    }
                    MdGenerator.updateLabelFile(labelsFile, newText.toString());
                    continue;
                }
                System.out.printf("Label file %s doesn't exists. Skipping it.%n", labelsFile);
            }
        }
    }

    private static String computePathToLabelFiles(String docFilePath) {
        int numberOfDirs = docFilePath.length() - docFilePath.replace("/", "").length();
        return "../".repeat(numberOfDirs) + LABELS;
    }
}

