/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.listeners;

import io.skodjob.testframe.utils.LoggerUtils;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestVisualSeparatorExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private final Logger logger = LoggerFactory.getLogger(TestVisualSeparatorExtension.class);

    private TestVisualSeparatorExtension() {
    }

    public void beforeAll(ExtensionContext extensionContext) {
        LoggerUtils.logSeparator();
        this.logger.info("TestClass {} STARTED", (Object)extensionContext.getRequiredTestClass().getName());
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.logger.info("TestClass {} FINISHED", (Object)extensionContext.getRequiredTestClass().getName());
        LoggerUtils.logSeparator();
    }

    public void beforeEach(ExtensionContext extensionContext) {
        LoggerUtils.logSeparator();
        this.logger.info("Test {}.{} STARTED", (Object)extensionContext.getRequiredTestClass().getName(), (Object)extensionContext.getDisplayName().replace("()", ""));
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.logger.info("Test {}.{} FINISHED", (Object)extensionContext.getRequiredTestClass().getName(), (Object)extensionContext.getDisplayName().replace("()", ""));
        LoggerUtils.logSeparator();
    }
}

