/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class LoggerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerUtils.class);
    static final String SEPARATOR_CHAR = "#";
    public static final String RESOURCE_LOGGER_PATTERN = "{} {}/{}";
    public static final String RESOURCE_WITH_NAMESPACE_LOGGER_PATTERN = "{} {}/{} in {}";

    private LoggerUtils() {
    }

    public static void logSeparator() {
        LoggerUtils.logSeparator(SEPARATOR_CHAR, 76);
    }

    public static void logSeparator(String delimiterChar, int length) {
        LOGGER.info(String.join((CharSequence)"", Collections.nCopies(length, delimiterChar)));
    }

    public static <T extends HasMetadata> void logResource(String operation, T resource) {
        LoggerUtils.logResource(operation, Level.INFO, resource);
    }

    public static <T extends HasMetadata> void logResource(String operation, Level logLevel, T resource) {
        if (resource.getMetadata().getNamespace() == null) {
            LOGGER.atLevel(logLevel).log(RESOURCE_LOGGER_PATTERN, new Object[]{operation, resource.getKind(), resource.getMetadata().getName()});
        } else {
            LOGGER.atLevel(logLevel).log(RESOURCE_WITH_NAMESPACE_LOGGER_PATTERN, new Object[]{operation, resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace()});
        }
    }
}

