/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMappingProvider;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.ConfigValidator;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.Converters;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.ExpressionConfigSourceInterceptor;
import io.smallrye.config.KeyMap;
import io.smallrye.config.NameIterator;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.PropertiesConfigSourceProvider;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SecretKeysConfigSourceInterceptor;
import io.smallrye.config.SecuritySupport;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SysPropConfigSource;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfigBuilder
implements ConfigBuilder {
    public static final String META_INF_MICROPROFILE_CONFIG_PROPERTIES = "META-INF/microprofile-config.properties";
    private final List<ConfigSource> sources = new ArrayList<ConfigSource>();
    private final List<ConfigSourceProvider> sourceProviders = new ArrayList<ConfigSourceProvider>();
    private final Map<Type, ConverterWithPriority> converters = new HashMap<Type, ConverterWithPriority>();
    private final List<String> profiles = new ArrayList<String>();
    private final Set<String> secretKeys = new HashSet<String>();
    private final List<InterceptorWithPriority> interceptors = new ArrayList<InterceptorWithPriority>();
    private final KeyMap<String> defaultValues = new KeyMap();
    private final ConfigMappingProvider.Builder mappingsBuilder = ConfigMappingProvider.builder();
    private ConfigValidator validator = ConfigValidator.EMPTY;
    private ClassLoader classLoader = SecuritySupport.getContextClassLoader();
    private boolean addDefaultSources = false;
    private boolean addDefaultInterceptors = false;
    private boolean addDiscoveredSources = false;
    private boolean addDiscoveredConverters = false;
    private boolean addDiscoveredInterceptors = false;
    private boolean addDiscoveredValidator = false;

    public SmallRyeConfigBuilder addDiscoveredSources() {
        this.addDiscoveredSources = true;
        return this;
    }

    public SmallRyeConfigBuilder addDiscoveredConverters() {
        this.addDiscoveredConverters = true;
        return this;
    }

    public SmallRyeConfigBuilder addDiscoveredInterceptors() {
        this.addDiscoveredInterceptors = true;
        return this;
    }

    public SmallRyeConfigBuilder addDiscoveredValidator() {
        this.addDiscoveredValidator = true;
        return this;
    }

    List<ConfigSource> discoverSources() {
        ArrayList<ConfigSource> discoveredSources = new ArrayList<ConfigSource>();
        ServiceLoader<ConfigSource> configSourceLoader = ServiceLoader.load(ConfigSource.class, this.classLoader);
        for (ConfigSource configSource : configSourceLoader) {
            discoveredSources.add(configSource);
        }
        ServiceLoader<ConfigSourceProvider> configSourceProviderLoader = ServiceLoader.load(ConfigSourceProvider.class, this.classLoader);
        for (ConfigSourceProvider configSourceProvider : configSourceProviderLoader) {
            for (ConfigSource configSource : configSourceProvider.getConfigSources(this.classLoader)) {
                discoveredSources.add(configSource);
            }
        }
        ServiceLoader<ConfigSourceFactory> serviceLoader = ServiceLoader.load(ConfigSourceFactory.class, this.classLoader);
        for (ConfigSourceFactory factory : serviceLoader) {
            discoveredSources.add(new ConfigurableConfigSource(factory));
        }
        return discoveredSources;
    }

    List<Converter<?>> discoverConverters() {
        ArrayList discoveredConverters = new ArrayList();
        for (Converter converter : ServiceLoader.load(Converter.class, this.classLoader)) {
            discoveredConverters.add(converter);
        }
        return discoveredConverters;
    }

    List<InterceptorWithPriority> discoverInterceptors() {
        ArrayList<InterceptorWithPriority> interceptors = new ArrayList<InterceptorWithPriority>();
        ServiceLoader<ConfigSourceInterceptor> interceptorLoader = ServiceLoader.load(ConfigSourceInterceptor.class, this.classLoader);
        for (ConfigSourceInterceptor configSourceInterceptor : interceptorLoader) {
            interceptors.add(new InterceptorWithPriority(configSourceInterceptor));
        }
        ServiceLoader<ConfigSourceInterceptorFactory> interceptorFactoryLoader = ServiceLoader.load(ConfigSourceInterceptorFactory.class, this.classLoader);
        for (ConfigSourceInterceptorFactory interceptor : interceptorFactoryLoader) {
            interceptors.add(new InterceptorWithPriority(interceptor));
        }
        return interceptors;
    }

    ConfigValidator discoverValidator() {
        ServiceLoader<ConfigValidator> validatorLoader = ServiceLoader.load(ConfigValidator.class, this.classLoader);
        Iterator<ConfigValidator> iterator = validatorLoader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return ConfigValidator.EMPTY;
    }

    public SmallRyeConfigBuilder addDefaultSources() {
        this.addDefaultSources = true;
        return this;
    }

    protected List<ConfigSource> getDefaultSources() {
        ArrayList<ConfigSource> defaultSources = new ArrayList<ConfigSource>();
        defaultSources.add((ConfigSource)new EnvConfigSource());
        defaultSources.add((ConfigSource)new SysPropConfigSource());
        defaultSources.addAll(PropertiesConfigSourceProvider.classPathSources(META_INF_MICROPROFILE_CONFIG_PROPERTIES, this.classLoader));
        return defaultSources;
    }

    public SmallRyeConfigBuilder addDefaultInterceptors() {
        this.addDefaultInterceptors = true;
        return this;
    }

    List<InterceptorWithPriority> getDefaultInterceptors() {
        ArrayList<InterceptorWithPriority> interceptors = new ArrayList<InterceptorWithPriority>();
        interceptors.add(new InterceptorWithPriority(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                if (SmallRyeConfigBuilder.this.profiles.isEmpty()) {
                    SmallRyeConfigBuilder.this.profiles.addAll(this.getProfile(context));
                }
                return new ProfileConfigSourceInterceptor(SmallRyeConfigBuilder.this.profiles);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3200);
            }

            private List<String> getProfile(ConfigSourceInterceptorContext context) {
                ArrayList<String> profiles = new ArrayList<String>();
                profiles.addAll(this.getProfiles(context, "smallrye.config.profile.parent"));
                profiles.addAll(this.getProfiles(context, "smallrye.config.profile"));
                return profiles;
            }

            private List<String> getProfiles(ConfigSourceInterceptorContext context, String propertyName) {
                ArrayList<String> profiles = new ArrayList<String>();
                ConfigValue profileValue = context.proceed(propertyName);
                if (profileValue != null) {
                    List<String> convertProfiles = ProfileConfigSourceInterceptor.convertProfile(profileValue.getValue());
                    for (String profile : convertProfiles) {
                        profiles.addAll(this.getProfiles(context, "%" + profile + "." + "smallrye.config.profile.parent"));
                        profiles.add(profile);
                    }
                }
                return profiles;
            }
        }));
        interceptors.add(new InterceptorWithPriority(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                HashMap<String, String> relocations = new HashMap<String, String>();
                relocations.put("smallrye.config.profile", "mp.config.profile");
                ArrayList<MultipleProfileProperty> multipleProfileProperties = new ArrayList<MultipleProfileProperty>();
                Iterator<String> names = context.iterateNames();
                while (names.hasNext()) {
                    NameIterator ni;
                    String profileSegment;
                    List<String> profiles;
                    String name = names.next();
                    if (name.charAt(0) != '%' || (profiles = ProfileConfigSourceInterceptor.convertProfile((profileSegment = (ni = new NameIterator(name)).getNextSegment()).substring(1))).size() <= 1) continue;
                    multipleProfileProperties.add(new MultipleProfileProperty(name, name.substring(profileSegment.length()), profiles));
                }
                for (MultipleProfileProperty multipleProfileProperty : multipleProfileProperties) {
                    for (String profile : multipleProfileProperty.getProfiles()) {
                        relocations.putIfAbsent("%" + profile + multipleProfileProperty.getRelocateName(), multipleProfileProperty.getName());
                    }
                }
                return new RelocateConfigSourceInterceptor(relocations);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3199);
            }

            class MultipleProfileProperty
            implements Comparable<MultipleProfileProperty> {
                private final String name;
                private final String relocateName;
                private final List<String> profiles;

                public MultipleProfileProperty(String name, String relocateName, List<String> profiles) {
                    this.name = name;
                    this.relocateName = relocateName;
                    this.profiles = profiles;
                }

                public String getName() {
                    return this.name;
                }

                public String getRelocateName() {
                    return this.relocateName;
                }

                public List<String> getProfiles() {
                    return this.profiles;
                }

                @Override
                public int compareTo(MultipleProfileProperty o) {
                    return Integer.compare(this.getProfiles().size(), o.getProfiles().size());
                }
            }
        }));
        interceptors.add(new InterceptorWithPriority(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                boolean expressions = true;
                ConfigValue expressionsValue = context.proceed("mp.config.property.expressions.enabled");
                if (expressionsValue != null) {
                    expressions = Boolean.valueOf(expressionsValue.getValue());
                }
                return new ExpressionConfigSourceInterceptor(expressions);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3300);
            }
        }));
        interceptors.add(new InterceptorWithPriority(new SecretKeysConfigSourceInterceptor(this.secretKeys)));
        return interceptors;
    }

    public SmallRyeConfigBuilder forClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SmallRyeConfigBuilder withSources(ConfigSource ... configSources) {
        Collections.addAll(this.sources, configSources);
        return this;
    }

    public SmallRyeConfigBuilder withSources(Collection<ConfigSource> configSources) {
        this.sources.addAll(configSources);
        return this;
    }

    public SmallRyeConfigBuilder withSources(ConfigSourceProvider provider) {
        this.sourceProviders.add(provider);
        return this;
    }

    public SmallRyeConfigBuilder withSources(ConfigSourceFactory ... configSourceFactories) {
        for (ConfigSourceFactory configSourceFactory : configSourceFactories) {
            this.sources.add(new ConfigurableConfigSource(configSourceFactory));
        }
        return this;
    }

    public SmallRyeConfigBuilder withInterceptors(ConfigSourceInterceptor ... interceptors) {
        for (ConfigSourceInterceptor interceptor : interceptors) {
            this.interceptors.add(new InterceptorWithPriority(interceptor));
        }
        return this;
    }

    public SmallRyeConfigBuilder withInterceptorFactories(ConfigSourceInterceptorFactory ... interceptorFactories) {
        for (ConfigSourceInterceptorFactory interceptorFactory : interceptorFactories) {
            this.interceptors.add(new InterceptorWithPriority(interceptorFactory));
        }
        return this;
    }

    public SmallRyeConfigBuilder withProfile(String profile) {
        this.addDefaultInterceptors();
        this.profiles.addAll(ProfileConfigSourceInterceptor.convertProfile(profile));
        return this;
    }

    public SmallRyeConfigBuilder withProfiles(List<String> profiles) {
        this.addDefaultInterceptors();
        this.profiles.addAll(profiles);
        return this;
    }

    public SmallRyeConfigBuilder withSecretKeys(String ... keys) {
        this.secretKeys.addAll(Stream.of(keys).collect(Collectors.toSet()));
        return this;
    }

    public SmallRyeConfigBuilder withDefaultValue(String name, String value) {
        this.defaultValues.findOrAdd(name).putRootValue(value);
        return this;
    }

    public SmallRyeConfigBuilder withDefaultValues(Map<String, String> defaultValues) {
        for (Map.Entry<String, String> entry : defaultValues.entrySet()) {
            this.defaultValues.findOrAdd(entry.getKey()).putRootValue(entry.getValue());
        }
        return this;
    }

    public SmallRyeConfigBuilder withMapping(Class<?> klass) {
        return this.withMapping(klass, ConfigMappings.getPrefix(klass));
    }

    public SmallRyeConfigBuilder withMapping(Class<?> klass, String prefix) {
        this.mappingsBuilder.addRoot(prefix, klass);
        return this;
    }

    public SmallRyeConfigBuilder withMappingIgnore(String path) {
        this.mappingsBuilder.addIgnored(path);
        return this;
    }

    public SmallRyeConfigBuilder withValidateUnknown(boolean validateUnknown) {
        this.mappingsBuilder.validateUnknown(validateUnknown);
        this.withDefaultValue("smallrye.config.mapping.validate-unknown", Boolean.toString(validateUnknown));
        return this;
    }

    public SmallRyeConfigBuilder withValidator(ConfigValidator validator) {
        this.validator = validator;
        return this;
    }

    public SmallRyeConfigBuilder withConverters(Converter<?>[] converters) {
        for (Converter<?> converter : converters) {
            Type type = Converters.getConverterType(converter.getClass());
            if (type == null) {
                throw ConfigMessages.msg.unableToAddConverter(converter);
            }
            SmallRyeConfigBuilder.addConverter(type, SmallRyeConfigBuilder.getPriority(converter), converter, this.converters);
        }
        return this;
    }

    public <T> SmallRyeConfigBuilder withConverter(Class<T> type, int priority, Converter<T> converter) {
        SmallRyeConfigBuilder.addConverter(type, priority, converter, this.converters);
        return this;
    }

    static void addConverter(Type type, Converter<?> converter, Map<Type, ConverterWithPriority> converters) {
        SmallRyeConfigBuilder.addConverter(type, SmallRyeConfigBuilder.getPriority(converter), converter, converters);
    }

    static void addConverter(Type type, int priority, Converter<?> converter, Map<Type, ConverterWithPriority> converters) {
        ConverterWithPriority oldConverter = converters.get(type);
        if (oldConverter == null || priority > oldConverter.priority) {
            converters.put(type, new ConverterWithPriority(converter, priority));
        }
    }

    private static int getPriority(Converter<?> converter) {
        int priority = 100;
        Priority priorityAnnotation = converter.getClass().getAnnotation(Priority.class);
        if (priorityAnnotation != null) {
            priority = priorityAnnotation.value();
        }
        return priority;
    }

    public List<ConfigSource> getSources() {
        return this.sources;
    }

    public List<ConfigSourceProvider> getSourceProviders() {
        return this.sourceProviders;
    }

    public Map<Type, ConverterWithPriority> getConverters() {
        return this.converters;
    }

    public List<InterceptorWithPriority> getInterceptors() {
        return this.interceptors;
    }

    public ConfigValidator getValidator() {
        if (this.isAddDiscoveredValidator()) {
            this.validator = this.discoverValidator();
        }
        return this.validator;
    }

    public KeyMap<String> getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isAddDefaultSources() {
        return this.addDefaultSources;
    }

    public boolean isAddDefaultInterceptors() {
        return this.addDefaultInterceptors;
    }

    public boolean isAddDiscoveredSources() {
        return this.addDiscoveredSources;
    }

    public boolean isAddDiscoveredConverters() {
        return this.addDiscoveredConverters;
    }

    public boolean isAddDiscoveredInterceptors() {
        return this.addDiscoveredInterceptors;
    }

    public boolean isAddDiscoveredValidator() {
        return this.addDiscoveredValidator;
    }

    public SmallRyeConfigBuilder setAddDefaultSources(boolean addDefaultSources) {
        this.addDefaultSources = addDefaultSources;
        return this;
    }

    public SmallRyeConfigBuilder setAddDefaultInterceptors(boolean addDefaultInterceptors) {
        this.addDefaultInterceptors = addDefaultInterceptors;
        return this;
    }

    public SmallRyeConfigBuilder setAddDiscoveredSources(boolean addDiscoveredSources) {
        this.addDiscoveredSources = addDiscoveredSources;
        return this;
    }

    public SmallRyeConfigBuilder setAddDiscoveredConverters(boolean addDiscoveredConverters) {
        this.addDiscoveredConverters = addDiscoveredConverters;
        return this;
    }

    public SmallRyeConfigBuilder setAddDiscoveredInterceptors(boolean addDiscoveredInterceptors) {
        this.addDiscoveredInterceptors = addDiscoveredInterceptors;
        return this;
    }

    public SmallRyeConfigBuilder setAddDiscoveredValidator(boolean addDiscoveredValidator) {
        this.addDiscoveredValidator = addDiscoveredValidator;
        return this;
    }

    public SmallRyeConfig build() {
        for (ConfigSourceProvider sourceProvider : this.sourceProviders) {
            for (ConfigSource configSource : sourceProvider.getConfigSources(this.classLoader)) {
                this.sources.add(configSource);
            }
        }
        ConfigMappingProvider mappingProvider = this.mappingsBuilder.build();
        this.defaultValues.putAll(mappingProvider.getDefaultValues());
        try {
            ConfigMappings configMappings = new ConfigMappings(this.getValidator());
            SmallRyeConfig config = new SmallRyeConfig(this, configMappings);
            mappingProvider.mapConfiguration(config);
            return config;
        }
        catch (ConfigValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    static class InterceptorWithPriority
    implements Comparable<InterceptorWithPriority> {
        private final ConfigSourceInterceptorFactory factory;
        private final int priority;

        InterceptorWithPriority(final ConfigSourceInterceptor interceptor) {
            this(new ConfigSourceInterceptorFactory(){

                @Override
                public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                    return interceptor;
                }

                @Override
                public OptionalInt getPriority() {
                    OptionalInt priority = ConfigSourceInterceptorFactory.super.getPriority();
                    if (priority.isPresent()) {
                        return priority;
                    }
                    return OptionalInt.of(InterceptorWithPriority.getPriority(interceptor.getClass()));
                }
            });
        }

        InterceptorWithPriority(ConfigSourceInterceptorFactory factory) {
            this.factory = factory;
            this.priority = factory.getPriority().orElse(5000);
        }

        ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
            return this.factory.getInterceptor(context);
        }

        int getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(InterceptorWithPriority other) {
            return Integer.compare(this.priority, other.priority);
        }

        private static int getPriority(Class<? extends ConfigSourceInterceptor> klass) {
            Priority priorityAnnotation = klass.getAnnotation(Priority.class);
            if (priorityAnnotation != null) {
                return priorityAnnotation.value();
            }
            Class<? extends ConfigSourceInterceptor> parentClass = klass.getSuperclass();
            if (ConfigSourceInterceptor.class.isAssignableFrom(parentClass)) {
                return InterceptorWithPriority.getPriority(parentClass);
            }
            return 5000;
        }
    }

    static class ConverterWithPriority {
        private final Converter<?> converter;
        private final int priority;

        private ConverterWithPriority(Converter<?> converter, int priority) {
            this.converter = converter;
            this.priority = priority;
        }

        Converter<?> getConverter() {
            return this.converter;
        }
    }
}

