/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigProducerUtil;
import io.smallrye.config.inject.InjectionMessages;
import io.smallrye.config.inject.MetadataInjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigInjectionBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Set<Annotation> QUALIFIERS = new HashSet<Annotation>();
    private final BeanManager bm;
    private final Class<?> clazz;
    private Config _config;

    public ConfigInjectionBean(BeanManager bm, Class<?> clazz) {
        this.bm = bm;
        this.clazz = clazz;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<?> getBeanClass() {
        return ConfigInjectionBean.class;
    }

    public boolean isNullable() {
        return false;
    }

    public T create(CreationalContext<T> context) {
        InjectionPoint ip = (InjectionPoint)this.bm.getInjectableReference((InjectionPoint)new MetadataInjectionPoint(), context);
        Annotated annotated = ip.getAnnotated();
        ConfigProperty configProperty = (ConfigProperty)annotated.getAnnotation(ConfigProperty.class);
        String key = ConfigProducerUtil.getConfigKey(ip, configProperty);
        String defaultValue = configProperty.defaultValue();
        if (annotated.getBaseType() instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)annotated.getBaseType();
            Type rawType = paramType.getRawType();
            if (rawType instanceof Class && (((Class)rawType).isAssignableFrom(Provider.class) || ((Class)rawType).isAssignableFrom(Instance.class)) && paramType.getActualTypeArguments().length == 1) {
                Class paramTypeClass = (Class)paramType.getActualTypeArguments()[0];
                return (T)this.getConfig().getValue(key, paramTypeClass);
            }
        } else {
            Class annotatedTypeClass = (Class)annotated.getBaseType();
            if (defaultValue.length() == 0) {
                return (T)this.getConfig().getValue(key, annotatedTypeClass);
            }
            Optional optionalValue = this.getConfig().getOptionalValue(key, annotatedTypeClass);
            return (T)optionalValue.orElseGet(() -> ((SmallRyeConfig)this.getConfig().unwrap(SmallRyeConfig.class)).convert(defaultValue, annotatedTypeClass));
        }
        throw InjectionMessages.msg.unhandledConfigProperty();
    }

    public Config getConfig() {
        if (this._config == null) {
            this._config = ConfigProvider.getConfig();
        }
        return this._config;
    }

    public void destroy(T instance, CreationalContext<T> context) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.clazz);
    }

    public Set<Annotation> getQualifiers() {
        return QUALIFIERS;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return "ConfigInjectionBean_" + this.clazz;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return "ConfigInjectionBean_" + this.clazz;
    }

    static {
        QUALIFIERS.add((Annotation)((Object)new ConfigPropertyLiteral()));
    }

    private static class ConfigPropertyLiteral
    extends AnnotationLiteral<ConfigProperty>
    implements ConfigProperty {
        private ConfigPropertyLiteral() {
        }

        public String name() {
            return "";
        }

        public String defaultValue() {
            return "";
        }
    }
}

