/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiOnSubscribeCall;
import io.smallrye.mutiny.operators.multi.MultiOnSubscribeInvokeOp;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;

public class MultiOnSubscribe<T> {
    private final Multi<T> upstream;

    public MultiOnSubscribe(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> invoke(Consumer<? super Subscription> callback) {
        return Infrastructure.onMultiCreation(new MultiOnSubscribeInvokeOp<T>(this.upstream, ParameterValidation.nonNull(callback, "callback")));
    }

    public Multi<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((? super Subscription ignored) -> actual.run());
    }

    public Multi<T> call(Function<? super Subscription, Uni<?>> action) {
        return Infrastructure.onMultiCreation(new MultiOnSubscribeCall<T>(this.upstream, ParameterValidation.nonNull(action, "action")));
    }

    public Multi<T> call(Supplier<Uni<?>> action) {
        Supplier<Uni<?>> actual = ParameterValidation.nonNull(action, "action");
        return this.call((? super Subscription ignored) -> (Uni)actual.get());
    }

    @Deprecated
    public Multi<T> invokeUni(Function<? super Subscription, Uni<?>> action) {
        return this.call(action);
    }
}

