/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;

public final class MultiRetryOp<T>
extends AbstractMultiOperator<T, T> {
    private final long times;

    public MultiRetryOp(Multi<? extends T> upstream, long times) {
        super(upstream);
        this.times = times;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        RetrySubscriber<T> subscriber = new RetrySubscriber<T>(this.upstream, downstream, this.times);
        downstream.onSubscribe(subscriber);
        if (!subscriber.isCancelled()) {
            subscriber.resubscribe();
        }
    }

    static final class RetrySubscriber<T>
    extends SwitchableSubscriptionSubscriber<T> {
        private final Publisher<? extends T> upstream;
        private final AtomicInteger wip = new AtomicInteger();
        private long remaining;
        long produced;

        RetrySubscriber(Publisher<? extends T> upstream, MultiSubscriber<? super T> downstream, long attempts) {
            super(downstream);
            this.upstream = upstream;
            this.remaining = attempts;
        }

        @Override
        public void onItem(T t) {
            ++this.produced;
            this.downstream.onItem(t);
        }

        @Override
        public void onFailure(Throwable t) {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                if (r == 0L) {
                    this.downstream.onFailure(t);
                    return;
                }
                this.remaining = r - 1L;
            }
            this.resubscribe();
        }

        void resubscribe() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.emitted(c);
                    }
                    this.upstream.subscribe(Infrastructure.onMultiSubscription(this.upstream, this));
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }
}

