/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItemDelay;
import io.smallrye.mutiny.groups.UniOnItemIgnore;
import io.smallrye.mutiny.groups.UniOnNotNull;
import io.smallrye.mutiny.groups.UniOnNull;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniFlatMapCompletionStageOnItem;
import io.smallrye.mutiny.operators.UniOnItemConsume;
import io.smallrye.mutiny.operators.UniOnItemFlatMap;
import io.smallrye.mutiny.operators.UniOnItemMap;
import io.smallrye.mutiny.operators.UniProduceMultiOnItem;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class UniOnItem<T> {
    private final Uni<T> upstream;

    public UniOnItem(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(Consumer<? super T> callback) {
        return Infrastructure.onUniCreation(new UniOnItemConsume<T>(this.upstream, ParameterValidation.nonNull(callback, "callback"), null));
    }

    public <R> Uni<R> apply(Function<? super T, ? extends R> mapper) {
        return Infrastructure.onUniCreation(new UniOnItemMap<T, R>(this.upstream, mapper));
    }

    public <R> Uni<R> produceUni(Function<? super T, ? extends Uni<? extends R>> mapper) {
        return Infrastructure.onUniCreation(new UniOnItemFlatMap(this.upstream, mapper));
    }

    public <R> Multi<R> produceMulti(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return Infrastructure.onMultiCreation(new UniProduceMultiOnItem(this.upstream, mapper));
    }

    public <R> Uni<R> produceCompletionStage(Function<? super T, ? extends CompletionStage<? extends R>> mapper) {
        return Infrastructure.onUniCreation(new UniFlatMapCompletionStageOnItem(this.upstream, mapper));
    }

    public <R> Uni<R> produceUni(BiConsumer<? super T, UniEmitter<? super R>> consumer) {
        ParameterValidation.nonNull(consumer, "consumer");
        return this.produceUni((? super T x) -> Uni.createFrom().emitter(emitter -> consumer.accept((Object)x, (UniEmitter)emitter)));
    }

    public UniOnItemDelay<T> delayIt() {
        return new UniOnItemDelay<T>(this.upstream, null);
    }

    public UniOnItemIgnore<T> ignore() {
        return new UniOnItemIgnore(this);
    }

    public Uni<T> failWith(Function<? super T, ? extends Throwable> mapper) {
        ParameterValidation.nonNull(mapper, "mapper");
        return Infrastructure.onUniCreation(this.produceUni((? super T t) -> Uni.createFrom().failure((Throwable)mapper.apply(t))));
    }

    public <O> Uni<O> castTo(Class<O> target) {
        ParameterValidation.nonNull(target, "target");
        return this.apply(target::cast);
    }

    public UniOnNull<T> ifNull() {
        return new UniOnNull<T>(this.upstream);
    }

    public UniOnNotNull<T> ifNotNull() {
        return new UniOnNotNull<T>(this.upstream);
    }
}

