/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.queues;

import io.smallrye.mutiny.helpers.queues.EmptyQueue;
import io.smallrye.mutiny.helpers.queues.MpscLinkedQueue;
import io.smallrye.mutiny.helpers.queues.SingletonQueue;
import io.smallrye.mutiny.helpers.queues.SpscArrayQueue;
import io.smallrye.mutiny.helpers.queues.SpscLinkedArrayQueue;
import java.util.Queue;
import java.util.function.Supplier;

public class Queues {
    public static final int TO_LARGE_TO_BE_BOUNDED = 10000000;
    public static final int BUFFER_XS = Math.max(8, Integer.parseInt(System.getProperty("mutiny.buffer-size.xs", "32")));
    public static final int BUFFER_S = Math.max(16, Integer.parseInt(System.getProperty("mutiny.buffer-size.s", "256")));
    static final Supplier EMPTY_QUEUE_SUPPLIER = EmptyQueue::new;
    static final Supplier SINGLETON_QUEUE_SUPPLIER = SingletonQueue::new;
    static final Supplier XS_QUEUE_SUPPLIER = () -> new SpscArrayQueue(BUFFER_XS);
    static final Supplier S_QUEUE_SUPPLIER = () -> new SpscArrayQueue(BUFFER_S);
    static final Supplier UNBOUNDED_QUEUE_SUPPLIER = () -> new SpscLinkedArrayQueue(BUFFER_S);
    static final Supplier XS_UNBOUNDED_QUEUE_SUPPLIER = () -> new SpscLinkedArrayQueue(BUFFER_XS);

    private Queues() {
    }

    public static <T> Supplier<Queue<T>> getXsQueueSupplier() {
        return XS_QUEUE_SUPPLIER;
    }

    public static <T> Supplier<Queue<T>> get(int bufferSize) {
        if (bufferSize == BUFFER_XS) {
            return XS_QUEUE_SUPPLIER;
        }
        if (bufferSize == BUFFER_S) {
            return S_QUEUE_SUPPLIER;
        }
        if (bufferSize == 1) {
            return SINGLETON_QUEUE_SUPPLIER;
        }
        if (bufferSize == 0) {
            return EMPTY_QUEUE_SUPPLIER;
        }
        int computedSize = Math.max(8, bufferSize);
        if (computedSize > 10000000) {
            return UNBOUNDED_QUEUE_SUPPLIER;
        }
        return () -> new SpscArrayQueue(computedSize);
    }

    public static <T> Supplier<Queue<T>> unbounded(int size) {
        if (size == BUFFER_XS) {
            return XS_UNBOUNDED_QUEUE_SUPPLIER;
        }
        if (size == Integer.MAX_VALUE || size == BUFFER_S) {
            return UNBOUNDED_QUEUE_SUPPLIER;
        }
        return () -> new SpscLinkedArrayQueue(size);
    }

    public static <T> Queue<T> createMpscQueue() {
        return new MpscLinkedQueue();
    }
}

