/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A timeout stream is triggered by a timer, the {@link io.vertx.core.Handler} will be call when the timer is fired,
 * it can be once or several times depending on the nature of the timer related to this stream. The
 *  will be called after the timer handler has been called.
 * <p>
 * Pausing the timer inhibits the timer shots until the stream is resumed. Setting a null handler callback cancels
 * the timer.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.TimeoutStream original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.TimeoutStream.class)
public class TimeoutStream implements io.vertx.axle.core.streams.ReadStream<Long> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TimeoutStream that = (TimeoutStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<TimeoutStream> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new TimeoutStream((io.vertx.core.TimeoutStream) obj),
    TimeoutStream::getDelegate
  );

  private final io.vertx.core.TimeoutStream delegate;
  
  public TimeoutStream(io.vertx.core.TimeoutStream delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  TimeoutStream() {    this.delegate = null;
  }

  public io.vertx.core.TimeoutStream getDelegate() {
    return delegate;
  }

  private org.reactivestreams.Publisher<Long> publisher;

  public synchronized org.reactivestreams.Publisher<Long> toPublisher() {
    if (publisher == null) {
      publisher = io.vertx.axle.PublisherHelper.toPublisher(this.getDelegate());
    }
    return publisher;
  }

  public synchronized org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder<Long> toPublisherBuilder() {
    if (publisher == null) {
      publisher = io.vertx.axle.PublisherHelper.toPublisher(this.getDelegate());
    }
    return org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams.fromPublisher(publisher);
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.axle.core.streams.Pipe<Long> pipe() { 
    io.vertx.axle.core.streams.Pipe<Long> ret = io.vertx.axle.core.streams.Pipe.newInstance(delegate.pipe(), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.axle.core.streams.WriteStream<Long> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public CompletionStage<Void> pipeTo(io.vertx.axle.core.streams.WriteStream<Long> dst) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __pipeTo(dst, handler);
    });
  }

  private io.vertx.axle.core.TimeoutStream __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.axle.core.TimeoutStream exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.TimeoutStream __handler(Handler<Long> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.axle.core.TimeoutStream handler(Consumer<Long> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.axle.core.TimeoutStream pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.axle.core.TimeoutStream resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.axle.core.TimeoutStream fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.axle.core.TimeoutStream __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.axle.core.TimeoutStream endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  /**
   * Cancels the timeout. Note this has the same effect as calling {@link io.vertx.axle.core.TimeoutStream#handler} with a null
   * argument.
   */
  public void cancel() { 
    delegate.cancel();
  }


  public static  TimeoutStream newInstance(io.vertx.core.TimeoutStream arg) {
    return arg != null ? new TimeoutStream(arg) : null;
  }
}
