/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An executor for executing blocking code in Vert.x .<p>
 *
 * It provides the same <code>executeBlocking</code> operation than {@link io.vertx.axle.core.Context} and
 * {@link io.vertx.axle.core.Vertx} but on a separate worker pool.<p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.WorkerExecutor original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.WorkerExecutor.class)
public class WorkerExecutor implements io.vertx.axle.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WorkerExecutor that = (WorkerExecutor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<WorkerExecutor> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new WorkerExecutor((io.vertx.core.WorkerExecutor) obj),
    WorkerExecutor::getDelegate
  );

  private final io.vertx.core.WorkerExecutor delegate;
  
  public WorkerExecutor(io.vertx.core.WorkerExecutor delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  WorkerExecutor() {    this.delegate = null;
  }

  public io.vertx.core.WorkerExecutor getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.axle.core.Promise#complete} or {@link io.vertx.axle.core.Promise#complete} method, or the {@link io.vertx.axle.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @param resultHandler handler that will be called when the blocking code is complete
   */
  private <T> void __executeBlocking(Handler<io.vertx.axle.core.Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        blockingCodeHandler.handle(io.vertx.axle.core.Promise.newInstance(event, io.vertx.lang.axle.TypeArg.unknown()));
      }
    }, ordered, resultHandler);
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.axle.core.Promise#complete} or {@link io.vertx.axle.core.Promise#complete} method, or the {@link io.vertx.axle.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   */
  public <T> CompletionStage<T> executeBlocking(Handler<io.vertx.axle.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __executeBlocking(blockingCodeHandler, ordered, handler);
    });
  }

  /**
   * Like {@link io.vertx.axle.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @param resultHandler 
   */
  private <T> void __executeBlocking(Handler<io.vertx.axle.core.Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        blockingCodeHandler.handle(io.vertx.axle.core.Promise.newInstance(event, io.vertx.lang.axle.TypeArg.unknown()));
      }
    }, resultHandler);
  }

  /**
   * Like {@link io.vertx.axle.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> CompletionStage<T> executeBlocking(Handler<io.vertx.axle.core.Promise<T>> blockingCodeHandler) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __executeBlocking(blockingCodeHandler, handler);
    });
  }

  /**
   * Close the executor.
   */
  public void close() { 
    delegate.close();
  }


  public static  WorkerExecutor newInstance(io.vertx.core.WorkerExecutor arg) {
    return arg != null ? new WorkerExecutor(arg) : null;
  }
}
