/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.datagram;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;

/**
 * A received datagram packet (UDP) which contains the data and information about the sender of the data itself.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.DatagramPacket original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.datagram.DatagramPacket.class)
public class DatagramPacket {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatagramPacket that = (DatagramPacket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<DatagramPacket> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new DatagramPacket((io.vertx.core.datagram.DatagramPacket) obj),
    DatagramPacket::getDelegate
  );

  private final io.vertx.core.datagram.DatagramPacket delegate;
  
  public DatagramPacket(io.vertx.core.datagram.DatagramPacket delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  DatagramPacket() {    this.delegate = null;
  }

  public io.vertx.core.datagram.DatagramPacket getDelegate() {
    return delegate;
  }

  /**
   * Returns the {@link io.vertx.axle.core.net.SocketAddress} of the sender that sent
   * this {@link io.vertx.axle.core.datagram.DatagramPacket}.
   * @return the address of the sender
   */
  public io.vertx.axle.core.net.SocketAddress sender() { 
    io.vertx.axle.core.net.SocketAddress ret = io.vertx.axle.core.net.SocketAddress.newInstance(delegate.sender());
    return ret;
  }

  /**
   * Returns the data of the {@link io.vertx.axle.core.datagram.DatagramPacket}
   * @return the data
   */
  public io.vertx.axle.core.buffer.Buffer data() { 
    io.vertx.axle.core.buffer.Buffer ret = io.vertx.axle.core.buffer.Buffer.newInstance(delegate.data());
    return ret;
  }


  public static  DatagramPacket newInstance(io.vertx.core.datagram.DatagramPacket arg) {
    return arg != null ? new DatagramPacket(arg) : null;
  }
}
