/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.eventbus;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;

/**
 *
 * Encapsulates a message being delivered by Vert.x as well as providing control over the message delivery.
 * <p/>
 * Used with event bus interceptors.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.DeliveryContext original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.eventbus.DeliveryContext.class)
public class DeliveryContext<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DeliveryContext that = (DeliveryContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<DeliveryContext> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new DeliveryContext((io.vertx.core.eventbus.DeliveryContext) obj),
    DeliveryContext::getDelegate
  );

  private final io.vertx.core.eventbus.DeliveryContext<T> delegate;
  public final io.vertx.lang.axle.TypeArg<T> __typeArg_0;
  
  public DeliveryContext(io.vertx.core.eventbus.DeliveryContext delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.axle.TypeArg.unknown();  }

  public DeliveryContext(io.vertx.core.eventbus.DeliveryContext delegate, io.vertx.lang.axle.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  DeliveryContext() {    this.delegate = null;
    this.__typeArg_0 = io.vertx.lang.axle.TypeArg.unknown();  }

  public io.vertx.core.eventbus.DeliveryContext getDelegate() {
    return delegate;
  }

  /**
   * @return The message being delivered
   */
  public io.vertx.axle.core.eventbus.Message<T> message() { 
    io.vertx.axle.core.eventbus.Message<T> ret = io.vertx.axle.core.eventbus.Message.newInstance(delegate.message(), __typeArg_0);
    return ret;
  }

  /**
   * Call the next interceptor
   */
  public void next() { 
    delegate.next();
  }

  /**
   * @return true if the message is being sent (point to point) or False if the message is being published
   */
  public boolean send() { 
    boolean ret = delegate.send();
    return ret;
  }

  /**
   * @return the value delivered by the message (before or after being processed by the codec)
   */
  public Object body() { 
    Object ret = (Object) delegate.body();
    return ret;
  }


  public static <T>DeliveryContext<T> newInstance(io.vertx.core.eventbus.DeliveryContext arg) {
    return arg != null ? new DeliveryContext<T>(arg) : null;
  }

  public static <T>DeliveryContext<T> newInstance(io.vertx.core.eventbus.DeliveryContext arg, io.vertx.lang.axle.TypeArg<T> __typeArg_T) {
    return arg != null ? new DeliveryContext<T>(arg, __typeArg_T) : null;
  }
}
