/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.http;

import java.util.Map;
import org.reactivestreams.Publisher;
import io.reactivex.Flowable;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.http.StreamPriority;
import java.util.List;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a client-side HTTP response.
 * <p>
 * Vert.x provides you with one of these via the handler that was provided when creating the {@link io.vertx.axle.core.http.HttpClientRequest}
 * or that was set on the {@link io.vertx.axle.core.http.HttpClientRequest} instance.
 * <p>
 * It implements {@link io.vertx.axle.core.streams.ReadStream} so it can be used with
 * {@link io.vertx.axle.core.streams.Pump} to pump data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpClientResponse original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.http.HttpClientResponse.class)
public class HttpClientResponse implements io.vertx.axle.core.streams.ReadStream<io.vertx.axle.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpClientResponse that = (HttpClientResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<HttpClientResponse> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new HttpClientResponse((io.vertx.core.http.HttpClientResponse) obj),
    HttpClientResponse::getDelegate
  );

  private final io.vertx.core.http.HttpClientResponse delegate;
  
  public HttpClientResponse(io.vertx.core.http.HttpClientResponse delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  HttpClientResponse() {    this.delegate = null;
  }

  public io.vertx.core.http.HttpClientResponse getDelegate() {
    return delegate;
  }

  private org.reactivestreams.Publisher<io.vertx.axle.core.buffer.Buffer> publisher;

  public synchronized org.reactivestreams.Publisher<io.vertx.axle.core.buffer.Buffer> toPublisher() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.axle.core.buffer.Buffer> conv = io.vertx.axle.core.buffer.Buffer::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return publisher;
  }

  public synchronized org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder<io.vertx.axle.core.buffer.Buffer> toPublisherBuilder() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.axle.core.buffer.Buffer> conv = io.vertx.axle.core.buffer.Buffer::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams.fromPublisher(publisher);
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.buffer.Buffer> pipe() { 
    io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.buffer.Buffer> ret = io.vertx.axle.core.streams.Pipe.newInstance(delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public CompletionStage<Void> pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> dst) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __pipeTo(dst, handler);
    });
  }

  public io.vertx.axle.core.http.HttpClientResponse fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.axle.core.http.HttpClientResponse resume() { 
    delegate.resume();
    return this;
  }

  private io.vertx.axle.core.http.HttpClientResponse __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.axle.core.http.HttpClientResponse exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.http.HttpClientResponse __handler(Handler<io.vertx.axle.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.axle.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.axle.core.http.HttpClientResponse handler(Consumer<io.vertx.axle.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.axle.core.http.HttpClientResponse pause() { 
    delegate.pause();
    return this;
  }

  private io.vertx.axle.core.http.HttpClientResponse __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.axle.core.http.HttpClientResponse endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  /**
   * @return the version of the response
   */
  public HttpVersion version() { 
    HttpVersion ret = delegate.version();
    return ret;
  }

  /**
   * @return the status code of the response
   */
  public int statusCode() { 
    int ret = delegate.statusCode();
    return ret;
  }

  /**
   * @return the status message of the response
   */
  public String statusMessage() { 
    String ret = delegate.statusMessage();
    return ret;
  }

  /**
   * @return the headers
   */
  public io.vertx.axle.core.MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.axle.core.MultiMap ret = io.vertx.axle.core.MultiMap.newInstance(delegate.headers());
    cached_0 = ret;
    return ret;
  }

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(String headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * Return the first trailer value with the specified name
   * @param trailerName the trailer name
   * @return the trailer value
   */
  public String getTrailer(String trailerName) { 
    String ret = delegate.getTrailer(trailerName);
    return ret;
  }

  /**
   * @return the trailers
   */
  public io.vertx.axle.core.MultiMap trailers() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.axle.core.MultiMap ret = io.vertx.axle.core.MultiMap.newInstance(delegate.trailers());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the Set-Cookie headers (including trailers)
   */
  public List<String> cookies() { 
    if (cached_2 != null) {
      return cached_2;
    }
    List<String> ret = delegate.cookies();
    cached_2 = ret;
    return ret;
  }

  /**
   * Convenience method for receiving the entire request body in one piece.
   * <p>
   * This saves you having to manually set a dataHandler and an endHandler and append the chunks of the body until
   * the whole body received. Don't use this if your request body is large - you could potentially run out of RAM.
   * @param bodyHandler This handler will be called after all the body has been received
   * @return 
   */
  private io.vertx.axle.core.http.HttpClientResponse __bodyHandler(Handler<io.vertx.axle.core.buffer.Buffer> bodyHandler) { 
    delegate.bodyHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        bodyHandler.handle(io.vertx.axle.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Convenience method for receiving the entire request body in one piece.
   * <p>
   * This saves you having to manually set a dataHandler and an endHandler and append the chunks of the body until
   * the whole body received. Don't use this if your request body is large - you could potentially run out of RAM.
   * @param bodyHandler This handler will be called after all the body has been received
   * @return 
   */
  public io.vertx.axle.core.http.HttpClientResponse bodyHandler(Consumer<io.vertx.axle.core.buffer.Buffer> bodyHandler) {
    return __bodyHandler(bodyHandler != null ? bodyHandler::accept : null);
  }

  /**
   * Set an custom frame handler. The handler will get notified when the http stream receives an custom HTTP/2
   * frame. HTTP/2 permits extension of the protocol.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.HttpClientResponse __customFrameHandler(Handler<io.vertx.axle.core.http.HttpFrame> handler) { 
    delegate.customFrameHandler(new Handler<io.vertx.core.http.HttpFrame>() {
      public void handle(io.vertx.core.http.HttpFrame event) {
        handler.handle(io.vertx.axle.core.http.HttpFrame.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set an custom frame handler. The handler will get notified when the http stream receives an custom HTTP/2
   * frame. HTTP/2 permits extension of the protocol.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.HttpClientResponse customFrameHandler(Consumer<io.vertx.axle.core.http.HttpFrame> handler) {
    return __customFrameHandler(handler != null ? handler::accept : null);
  }

  /**
   * Get a net socket for the underlying connection of this request.
   * <p>
   * USE THIS WITH CAUTION! Writing to the socket directly if you don't know what you're doing can easily break the HTTP protocol.
   * <p>
   * HTTP/1.1 pipe-lined requests cannot support net socket upgrade.
   * <p>
   * One valid use-case for calling this is to receive the {@link io.vertx.axle.core.net.NetSocket} after a HTTP CONNECT was issued to the
   * remote peer and it responded with a status code of 200.
   * @return the net socket
   */
  public io.vertx.axle.core.net.NetSocket netSocket() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.axle.core.net.NetSocket ret = io.vertx.axle.core.net.NetSocket.newInstance(delegate.netSocket());
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the corresponding request
   */
  public io.vertx.axle.core.http.HttpClientRequest request() { 
    if (cached_4 != null) {
      return cached_4;
    }
    io.vertx.axle.core.http.HttpClientRequest ret = io.vertx.axle.core.http.HttpClientRequest.newInstance(delegate.request());
    cached_4 = ret;
    return ret;
  }

  /**
   * Set an handler for stream priority changes.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler to be called when the stream priority changes
   * @return 
   */
  private io.vertx.axle.core.http.HttpClientResponse __streamPriorityHandler(Handler<StreamPriority> handler) { 
    delegate.streamPriorityHandler(handler);
    return this;
  }

  /**
   * Set an handler for stream priority changes.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler to be called when the stream priority changes
   * @return 
   */
  public io.vertx.axle.core.http.HttpClientResponse streamPriorityHandler(Consumer<StreamPriority> handler) {
    return __streamPriorityHandler(handler != null ? handler::accept : null);
  }

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(CharSequence headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.buffer.Buffer> TYPE_ARG_0 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.buffer.Buffer>(o1 -> io.vertx.axle.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  private io.vertx.axle.core.MultiMap cached_0;
  private io.vertx.axle.core.MultiMap cached_1;
  private List<String> cached_2;
  private io.vertx.axle.core.net.NetSocket cached_3;
  private io.vertx.axle.core.http.HttpClientRequest cached_4;

  public static  HttpClientResponse newInstance(io.vertx.core.http.HttpClientResponse arg) {
    return arg != null ? new HttpClientResponse(arg) : null;
  }
}
