/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.datagram;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A datagram socket can be used to send {@link io.vertx.axle.core.datagram.DatagramPacket}'s to remote datagram servers
 * and receive {@link io.vertx.axle.core.datagram.DatagramPacket}s .
 * <p>
 * Usually you use a datagram socket to send UDP over the wire. UDP is connection-less which means you are not connected
 * to the remote peer in a persistent way. Because of this you have to supply the address and port of the remote peer
 * when sending data.
 * <p>
 * You can send data to ipv4 or ipv6 addresses, which also include multicast addresses.
 * <p>
 * Please consult the documentation for more information on datagram sockets.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.DatagramSocket original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket implements io.vertx.axle.core.streams.ReadStream<io.vertx.axle.core.datagram.DatagramPacket>, io.vertx.axle.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatagramSocket that = (DatagramSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<DatagramSocket> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket) obj),
    DatagramSocket::getDelegate
  );

  private final io.vertx.core.datagram.DatagramSocket delegate;
  
  public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  DatagramSocket() {    this.delegate = null;
  }

  public io.vertx.core.datagram.DatagramSocket getDelegate() {
    return delegate;
  }

  private org.reactivestreams.Publisher<io.vertx.axle.core.datagram.DatagramPacket> publisher;

  public synchronized org.reactivestreams.Publisher<io.vertx.axle.core.datagram.DatagramPacket> toPublisher() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.datagram.DatagramPacket, io.vertx.axle.core.datagram.DatagramPacket> conv = io.vertx.axle.core.datagram.DatagramPacket::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return publisher;
  }

  public synchronized org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder<io.vertx.axle.core.datagram.DatagramPacket> toPublisherBuilder() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.datagram.DatagramPacket, io.vertx.axle.core.datagram.DatagramPacket> conv = io.vertx.axle.core.datagram.DatagramPacket::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams.fromPublisher(publisher);
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.datagram.DatagramPacket> pipe() { 
    io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.datagram.DatagramPacket> ret = io.vertx.axle.core.streams.Pipe.newInstance(delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.datagram.DatagramPacket> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public CompletionStage<Void> pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.datagram.DatagramPacket> dst) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * Write the given {@link io.vertx.axle.core.buffer.Buffer} to the {@link io.vertx.axle.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.axle.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.datagram.DatagramSocket __send(io.vertx.axle.core.buffer.Buffer packet, int port, String host, Handler<AsyncResult<io.vertx.axle.core.datagram.DatagramSocket>> handler) { 
    delegate.send(packet.getDelegate(), port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Write the given {@link io.vertx.axle.core.buffer.Buffer} to the {@link io.vertx.axle.core.net.SocketAddress}.
   * The {@link io.vertx.core.Handler} will be notified once the write completes.
   * @param packet the {@link io.vertx.axle.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.datagram.DatagramSocket> send(io.vertx.axle.core.buffer.Buffer packet, int port, String host) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __send(packet, port, host, handler);
    });
  }

  /**
   * Returns a <code>WriteStream<Buffer></code> able to send  to the
   * {@link io.vertx.axle.core.net.SocketAddress}.
   * @param port the port of the remote peer
   * @param host the host address of the remote peer
   * @return the write stream for sending packets
   */
  public io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> sender(int port, String host) { 
    io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> ret = io.vertx.axle.core.streams.WriteStream.newInstance(delegate.sender(port, host), TYPE_ARG_1);
    return ret;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.axle.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.datagram.DatagramSocket __send(String str, int port, String host, Handler<AsyncResult<io.vertx.axle.core.datagram.DatagramSocket>> handler) { 
    delegate.send(str, port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.axle.core.net.SocketAddress} using UTF8 encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.datagram.DatagramSocket> send(String str, int port, String host) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __send(str, port, host, handler);
    });
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.axle.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @param handler the {@link io.vertx.core.Handler} to notify once the write completes.
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.datagram.DatagramSocket __send(String str, String enc, int port, String host, Handler<AsyncResult<io.vertx.axle.core.datagram.DatagramSocket>> handler) { 
    delegate.send(str, enc, port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.axle.core.net.SocketAddress} using the given encoding.
   * The  will be notified once the write completes.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.datagram.DatagramSocket> send(String str, String enc, int port, String host) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __send(str, enc, port, host, handler);
    });
  }

  /**
   * Closes the {@link io.vertx.axle.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @param handler the handler to notify once complete
   */
  private void __close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Closes the {@link io.vertx.axle.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @return 
   */
  public CompletionStage<Void> close() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __close(handler);
    });
  }

  /**
   * Return the {@link io.vertx.axle.core.net.SocketAddress} to which
   * this {@link io.vertx.axle.core.datagram.DatagramSocket} is bound.
   * @return the socket address
   */
  public io.vertx.axle.core.net.SocketAddress localAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.axle.core.net.SocketAddress ret = io.vertx.axle.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.datagram.DatagramSocket __listenMulticastGroup(String multicastAddress, Handler<AsyncResult<io.vertx.axle.core.datagram.DatagramSocket>> handler) { 
    delegate.listenMulticastGroup(multicastAddress, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.datagram.DatagramSocket> listenMulticastGroup(String multicastAddress) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __listenMulticastGroup(multicastAddress, handler);
    });
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.datagram.DatagramSocket __listenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<io.vertx.axle.core.datagram.DatagramSocket>> handler) { 
    delegate.listenMulticastGroup(multicastAddress, networkInterface, source, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.datagram.DatagramSocket> listenMulticastGroup(String multicastAddress, String networkInterface, String source) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __listenMulticastGroup(multicastAddress, networkInterface, source, handler);
    });
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @param handler then handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.datagram.DatagramSocket __unlistenMulticastGroup(String multicastAddress, Handler<AsyncResult<io.vertx.axle.core.datagram.DatagramSocket>> handler) { 
    delegate.unlistenMulticastGroup(multicastAddress, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to leave
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.datagram.DatagramSocket> unlistenMulticastGroup(String multicastAddress) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __unlistenMulticastGroup(multicastAddress, handler);
    });
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.datagram.DatagramSocket __unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<io.vertx.axle.core.datagram.DatagramSocket>> handler) { 
    delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * The  is notified once the operation completes.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.datagram.DatagramSocket> unlistenMulticastGroup(String multicastAddress, String networkInterface, String source) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __unlistenMulticastGroup(multicastAddress, networkInterface, source, handler);
    });
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.datagram.DatagramSocket __blockMulticastGroup(String multicastAddress, String sourceToBlock, Handler<AsyncResult<io.vertx.axle.core.datagram.DatagramSocket>> handler) { 
    delegate.blockMulticastGroup(multicastAddress, sourceToBlock, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.datagram.DatagramSocket> blockMulticastGroup(String multicastAddress, String sourceToBlock) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __blockMulticastGroup(multicastAddress, sourceToBlock, handler);
    });
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @param handler the handler to notify once the operation completes
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.datagram.DatagramSocket __blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, Handler<AsyncResult<io.vertx.axle.core.datagram.DatagramSocket>> handler) { 
    delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.datagram.DatagramSocket> blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, handler);
    });
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param handler the handler will be called when listening
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.datagram.DatagramSocket __listen(int port, String host, Handler<AsyncResult<io.vertx.axle.core.datagram.DatagramSocket>> handler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>() {
      public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.axle.core.datagram.DatagramSocket.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public CompletionStage<io.vertx.axle.core.datagram.DatagramSocket> listen(int port, String host) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __listen(port, host, handler);
    });
  }

  public io.vertx.axle.core.datagram.DatagramSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.axle.core.datagram.DatagramSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.axle.core.datagram.DatagramSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.axle.core.datagram.DatagramSocket __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.axle.core.datagram.DatagramSocket endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  private io.vertx.axle.core.datagram.DatagramSocket __handler(Handler<io.vertx.axle.core.datagram.DatagramPacket> handler) { 
    delegate.handler(new Handler<io.vertx.core.datagram.DatagramPacket>() {
      public void handle(io.vertx.core.datagram.DatagramPacket event) {
        handler.handle(io.vertx.axle.core.datagram.DatagramPacket.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.axle.core.datagram.DatagramSocket handler(Consumer<io.vertx.axle.core.datagram.DatagramPacket> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.datagram.DatagramSocket __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.axle.core.datagram.DatagramSocket exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.buffer.Buffer> TYPE_ARG_1 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.buffer.Buffer>(o1 -> io.vertx.axle.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.datagram.DatagramPacket> TYPE_ARG_0 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.datagram.DatagramPacket>(o1 -> io.vertx.axle.core.datagram.DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)o1), o1 -> o1.getDelegate());
  private io.vertx.axle.core.net.SocketAddress cached_0;

  public static  DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
    return arg != null ? new DatagramSocket(arg) : null;
  }
}
