/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.http;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.SSLSession;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a server side WebSocket.
 * <p>
 * Instances of this class are passed into a {@link io.vertx.axle.core.http.HttpServer#webSocketHandler} or provided
 * when a WebSocket handshake is manually {@link io.vertx.axle.core.http.HttpServerRequest#upgrade}ed.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.ServerWebSocket original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.http.ServerWebSocket.class)
public class ServerWebSocket implements io.vertx.axle.core.http.WebSocketBase {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerWebSocket that = (ServerWebSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<ServerWebSocket> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new ServerWebSocket((io.vertx.core.http.ServerWebSocket) obj),
    ServerWebSocket::getDelegate
  );

  private final io.vertx.core.http.ServerWebSocket delegate;
  
  public ServerWebSocket(io.vertx.core.http.ServerWebSocket delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  ServerWebSocket() {    this.delegate = null;
  }

  public io.vertx.core.http.ServerWebSocket getDelegate() {
    return delegate;
  }

  private org.reactivestreams.Publisher<io.vertx.axle.core.buffer.Buffer> publisher;

  public synchronized org.reactivestreams.Publisher<io.vertx.axle.core.buffer.Buffer> toPublisher() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.axle.core.buffer.Buffer> conv = io.vertx.axle.core.buffer.Buffer::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return publisher;
  }

  public synchronized org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder<io.vertx.axle.core.buffer.Buffer> toPublisherBuilder() {
    if (publisher == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.axle.core.buffer.Buffer> conv = io.vertx.axle.core.buffer.Buffer::newInstance;
      publisher = io.vertx.axle.PublisherHelper.toPublisher(delegate, conv);
    }
    return org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams.fromPublisher(publisher);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  private void __end(io.vertx.axle.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public CompletionStage<Void> end(io.vertx.axle.core.buffer.Buffer data) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __end(data, handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.axle.core.http.ServerWebSocket#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.buffer.Buffer> pipe() { 
    io.vertx.axle.core.streams.Pipe<io.vertx.axle.core.buffer.Buffer> ret = io.vertx.axle.core.streams.Pipe.newInstance(delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  private void __pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public CompletionStage<Void> pipeTo(io.vertx.axle.core.streams.WriteStream<io.vertx.axle.core.buffer.Buffer> dst) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __pipeTo(dst, handler);
    });
  }

  /**
   * When a <code>WebSocket</code> is created it automatically registers an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public String binaryHandlerID() { 
    String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * When a <code>WebSocket</code> is created it automatically registers an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return 
   */
  public String textHandlerID() { 
    String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * Returns the WebSocket sub protocol selected by the WebSocket handshake.
   * <p/>
   * On the server, the value will be <code>null</code> when the handler receives the websocket callback as the
   * handshake will not be completed yet.
   * @return 
   */
  public String subProtocol() { 
    String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * Returns the close status code received from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public Short closeStatusCode() { 
    Short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * Returns the close reason message from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public String closeReason() { 
    String ret = delegate.closeReason();
    return ret;
  }

  /**
   *  Returns the HTTP headers when the WebSocket is first obtained in the handler.
   *  <p/>
   *  The headers will be <code>null</code> on subsequent interactions.
   * @return the headers
   */
  public io.vertx.axle.core.MultiMap headers() { 
    io.vertx.axle.core.MultiMap ret = io.vertx.axle.core.MultiMap.newInstance(delegate.headers());
    return ret;
  }

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.WebSocketBase writePing(io.vertx.axle.core.buffer.Buffer data) { 
    delegate.writePing(data.getDelegate());
    return this;
  }

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.WebSocketBase writePong(io.vertx.axle.core.buffer.Buffer data) { 
    delegate.writePong(data.getDelegate());
    return this;
  }

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * {@link io.vertx.axle.core.http.WebSocketBase#binaryMessageHandler}, but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.WebSocketBase __textMessageHandler(Handler<String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * {@link io.vertx.axle.core.http.WebSocketBase#binaryMessageHandler}, but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.WebSocketBase textMessageHandler(Consumer<String> handler) {
    return __textMessageHandler(handler != null ? handler::accept : null);
  }

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.axle.core.http.ServerWebSocket#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.axle.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.WebSocketBase __binaryMessageHandler(Handler<io.vertx.axle.core.buffer.Buffer> handler) { 
    delegate.binaryMessageHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.axle.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.axle.core.http.ServerWebSocket#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.axle.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.WebSocketBase binaryMessageHandler(Consumer<io.vertx.axle.core.buffer.Buffer> handler) {
    return __binaryMessageHandler(handler != null ? handler::accept : null);
  }

  /**
   * Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
   * on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  private io.vertx.axle.core.http.WebSocketBase __pongHandler(Handler<io.vertx.axle.core.buffer.Buffer> handler) { 
    delegate.pongHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.axle.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
   * on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.axle.core.http.WebSocketBase pongHandler(Consumer<io.vertx.axle.core.buffer.Buffer> handler) {
    return __pongHandler(handler != null ? handler::accept : null);
  }

  /**
   * Calls {@link io.vertx.axle.core.http.WebSocketBase#close}
   * @param handler 
   */
  private void __end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Calls {@link io.vertx.axle.core.http.WebSocketBase#close}
   * @return 
   */
  public CompletionStage<Void> end() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __end(handler);
    });
  }

  /**
   * Same as {@link io.vertx.axle.core.http.ServerWebSocket#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  private void __close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.axle.core.http.ServerWebSocket#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public CompletionStage<Void> close() { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __close(handler);
    });
  }

  /**
   * Same as {@link io.vertx.axle.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param handler 
   */
  private void __close(short statusCode, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, handler);
  }

  /**
   * Same as {@link io.vertx.axle.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @return 
   */
  public CompletionStage<Void> close(short statusCode) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __close(statusCode, handler);
    });
  }

  /**
   * Same as {@link io.vertx.axle.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @param handler 
   */
  private void __close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, reason, handler);
  }

  /**
   * Same as {@link io.vertx.axle.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @return 
   */
  public CompletionStage<Void> close(short statusCode, String reason) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __close(statusCode, reason, handler);
    });
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.axle.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.axle.core.net.SocketAddress ret = io.vertx.axle.core.net.SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.axle.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.axle.core.net.SocketAddress ret = io.vertx.axle.core.net.SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.axle.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  private io.vertx.axle.core.http.ServerWebSocket __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.axle.core.http.ServerWebSocket exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.http.ServerWebSocket __handler(Handler<io.vertx.axle.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.axle.core.buffer.Buffer.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.axle.core.http.ServerWebSocket handler(Consumer<io.vertx.axle.core.buffer.Buffer> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  public io.vertx.axle.core.http.ServerWebSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.axle.core.http.ServerWebSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.axle.core.http.ServerWebSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  private io.vertx.axle.core.http.ServerWebSocket __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.axle.core.http.ServerWebSocket endHandler(Consumer<Void> endHandler) {
    return __endHandler(endHandler != null ? endHandler::accept : null);
  }

  private io.vertx.axle.core.http.ServerWebSocket __write(io.vertx.axle.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

  public CompletionStage<Void> write(io.vertx.axle.core.buffer.Buffer data) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __write(data, handler);
    });
  }

  public io.vertx.axle.core.http.ServerWebSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  private io.vertx.axle.core.http.ServerWebSocket __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.axle.core.http.ServerWebSocket drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.http.ServerWebSocket __writeFrame(io.vertx.axle.core.http.WebSocketFrame frame, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFrame(frame.getDelegate(), handler);
    return this;
  }

  public CompletionStage<Void> writeFrame(io.vertx.axle.core.http.WebSocketFrame frame) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __writeFrame(frame, handler);
    });
  }

  private io.vertx.axle.core.http.ServerWebSocket __writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalTextFrame(text, handler);
    return this;
  }

  public CompletionStage<Void> writeFinalTextFrame(String text) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __writeFinalTextFrame(text, handler);
    });
  }

  private io.vertx.axle.core.http.ServerWebSocket __writeFinalBinaryFrame(io.vertx.axle.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
    return this;
  }

  public CompletionStage<Void> writeFinalBinaryFrame(io.vertx.axle.core.buffer.Buffer data) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __writeFinalBinaryFrame(data, handler);
    });
  }

  private io.vertx.axle.core.http.ServerWebSocket __writeBinaryMessage(io.vertx.axle.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeBinaryMessage(data.getDelegate(), handler);
    return this;
  }

  public CompletionStage<Void> writeBinaryMessage(io.vertx.axle.core.buffer.Buffer data) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __writeBinaryMessage(data, handler);
    });
  }

  private io.vertx.axle.core.http.ServerWebSocket __writeTextMessage(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeTextMessage(text, handler);
    return this;
  }

  public CompletionStage<Void> writeTextMessage(String text) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __writeTextMessage(text, handler);
    });
  }

  private io.vertx.axle.core.http.ServerWebSocket __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  public io.vertx.axle.core.http.ServerWebSocket closeHandler(Consumer<Void> handler) {
    return __closeHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.axle.core.http.ServerWebSocket __frameHandler(Handler<io.vertx.axle.core.http.WebSocketFrame> handler) { 
    delegate.frameHandler(new Handler<io.vertx.core.http.WebSocketFrame>() {
      public void handle(io.vertx.core.http.WebSocketFrame event) {
        handler.handle(io.vertx.axle.core.http.WebSocketFrame.newInstance(event));
      }
    });
    return this;
  }

  public io.vertx.axle.core.http.ServerWebSocket frameHandler(Consumer<io.vertx.axle.core.http.WebSocketFrame> handler) {
    return __frameHandler(handler != null ? handler::accept : null);
  }

  public String uri() { 
    String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the WebSocket handshake path.
   */
  public String path() { 
    String ret = delegate.path();
    return ret;
  }

  /**
   * @return the WebSocket handshake query string.
   */
  public String query() { 
    String ret = delegate.query();
    return ret;
  }

  /**
   * Accept the WebSocket and terminate the WebSocket handshake.
   * <p/>
   * This method should be called from the WebSocket handler to explicitly accept the WebSocket and
   * terminate the WebSocket handshake.
   */
  public void accept() { 
    delegate.accept();
  }

  /**
   * Reject the WebSocket.
   * <p>
   * Calling this method from the WebSocket handler when it is first passed to you gives you the opportunity to reject
   * the WebSocket, which will cause the WebSocket handshake to fail by returning
   * a  response code.
   * <p>
   * You might use this method, if for example you only want to accept WebSockets with a particular path.
   */
  public void reject() { 
    delegate.reject();
  }

  /**
   * Like {@link io.vertx.axle.core.http.ServerWebSocket#reject} but with a <code>status</code>.
   * @param status 
   */
  public void reject(int status) { 
    delegate.reject(status);
  }

  /**
   * Set an asynchronous result for the handshake, upon completion of the specified <code>future</code>, the
   * WebSocket will either be
   *
   * <ul>
   *   <li>accepted when the <code>future</code> succeeds with the HTTP  status code</li>
   *   <li>rejected when the <code>future</code> is succeeds with an HTTP status code different than </li>
   *   <li>rejected when the <code>future</code> fails with the HTTP status code <code>500</code></li>
   * </ul>
   *
   * The provided future might be completed by the WebSocket itself, e.g calling the {@link io.vertx.axle.core.http.ServerWebSocket#close} method
   * will try to accept the handshake and close the WebSocket afterward. Thus it is advised to try to complete
   * the <code>future</code> with  or .
   * <p>
   * This method should be called from the WebSocket handler to explicitly set an asynchronous handshake.
   * <p>
   * Calling this method will override the <code>future</code> completion handler.
   * @param future the future to complete with
   * @param handler the completion handler
   */
  private void __setHandshake(io.vertx.axle.core.Future<Integer> future, Handler<AsyncResult<Integer>> handler) { 
    delegate.setHandshake(future.getDelegate(), handler);
  }

  /**
   * Set an asynchronous result for the handshake, upon completion of the specified <code>future</code>, the
   * WebSocket will either be
   *
   * <ul>
   *   <li>accepted when the <code>future</code> succeeds with the HTTP  status code</li>
   *   <li>rejected when the <code>future</code> is succeeds with an HTTP status code different than </li>
   *   <li>rejected when the <code>future</code> fails with the HTTP status code <code>500</code></li>
   * </ul>
   *
   * The provided future might be completed by the WebSocket itself, e.g calling the {@link io.vertx.axle.core.http.ServerWebSocket#close} method
   * will try to accept the handshake and close the WebSocket afterward. Thus it is advised to try to complete
   * the <code>future</code> with  or .
   * <p>
   * This method should be called from the WebSocket handler to explicitly set an asynchronous handshake.
   * <p>
   * Calling this method will override the <code>future</code> completion handler.
   * @param future the future to complete with
   * @return 
   */
  public CompletionStage<Integer> setHandshake(io.vertx.axle.core.Future<Integer> future) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __setHandshake(future, handler);
    });
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public SSLSession sslSession() { 
    SSLSession ret = delegate.sslSession();
    return ret;
  }

  private static final io.vertx.lang.axle.TypeArg<io.vertx.axle.core.buffer.Buffer> TYPE_ARG_0 = new io.vertx.lang.axle.TypeArg<io.vertx.axle.core.buffer.Buffer>(o1 -> io.vertx.axle.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  private io.vertx.axle.core.net.SocketAddress cached_0;
  private io.vertx.axle.core.net.SocketAddress cached_1;

  public static  ServerWebSocket newInstance(io.vertx.core.http.ServerWebSocket arg) {
    return arg != null ? new ServerWebSocket(arg) : null;
  }
}
