/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.core.net;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;

/**
 * A self-signed certificate helper for testing and development purposes.
 * <p>
 * While it helps for testing and development, it should never ever be used in production settings.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.SelfSignedCertificate original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.core.net.SelfSignedCertificate.class)
public class SelfSignedCertificate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SelfSignedCertificate that = (SelfSignedCertificate) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<SelfSignedCertificate> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new SelfSignedCertificate((io.vertx.core.net.SelfSignedCertificate) obj),
    SelfSignedCertificate::getDelegate
  );

  private final io.vertx.core.net.SelfSignedCertificate delegate;
  
  public SelfSignedCertificate(io.vertx.core.net.SelfSignedCertificate delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  SelfSignedCertificate() {    this.delegate = null;
  }

  public io.vertx.core.net.SelfSignedCertificate getDelegate() {
    return delegate;
  }

  /**
   * Provides the {@link io.vertx.core.net.KeyCertOptions} RSA private key file in PEM format corresponding to the {@link io.vertx.axle.core.net.SelfSignedCertificate#privateKeyPath}
   * @return a {@link io.vertx.core.net.PemKeyCertOptions} based on the generated certificate.
   */
  public PemKeyCertOptions keyCertOptions() { 
    PemKeyCertOptions ret = delegate.keyCertOptions();
    return ret;
  }

  /**
   * Provides the {@link io.vertx.core.net.TrustOptions} X.509 certificate file in PEM format corresponding to the {@link io.vertx.axle.core.net.SelfSignedCertificate#certificatePath}
   * @return a {@link io.vertx.core.net.PemTrustOptions} based on the generated certificate.
   */
  public PemTrustOptions trustOptions() { 
    PemTrustOptions ret = delegate.trustOptions();
    return ret;
  }

  /**
   * Filesystem path to the RSA private key file in PEM format
   * @return the absolute path to the private key.
   */
  public String privateKeyPath() { 
    String ret = delegate.privateKeyPath();
    return ret;
  }

  /**
   * Filesystem path to the X.509 certificate file in PEM format .
   * @return the absolute path to the certificate.
   */
  public String certificatePath() { 
    String ret = delegate.certificatePath();
    return ret;
  }

  /**
   * Delete the private key and certificate files.
   */
  public void delete() { 
    delegate.delete();
  }

  /**
   * Create a new <code>SelfSignedCertificate</code> instance.
   * @return a new instance.
   */
  public static io.vertx.axle.core.net.SelfSignedCertificate create() { 
    io.vertx.axle.core.net.SelfSignedCertificate ret = io.vertx.axle.core.net.SelfSignedCertificate.newInstance(io.vertx.core.net.SelfSignedCertificate.create());
    return ret;
  }

  /**
   * Create a new <code>SelfSignedCertificate</code> instance with a fully-qualified domain name,
   * @param fqdn a fully qualified domain name.
   * @return a new instance.
   */
  public static io.vertx.axle.core.net.SelfSignedCertificate create(String fqdn) { 
    io.vertx.axle.core.net.SelfSignedCertificate ret = io.vertx.axle.core.net.SelfSignedCertificate.newInstance(io.vertx.core.net.SelfSignedCertificate.create(fqdn));
    return ret;
  }


  public static  SelfSignedCertificate newInstance(io.vertx.core.net.SelfSignedCertificate arg) {
    return arg != null ? new SelfSignedCertificate(arg) : null;
  }
}
