package io.vertx.mutiny.core.cli;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.cli.Option;
import java.util.List;
import io.vertx.core.cli.Argument;

/**
 * Interface defining a command-line interface (in other words a command such as 'run', 'ls'...).
 * This interface is polyglot to ease reuse such as in Vert.x Shell.
 * <p/>
 * A command line interface has a name, and defines a set of options and arguments. Options are key-value pair such
 * as <code>-foo=bar</code> or <code>-flag</code>. The supported formats depend on the used parser. Arguments are unlike
 * options raw values. Options are defined using
 * {@link io.vertx.core.cli.Option}, while argument are defined using {@link io.vertx.core.cli.Argument}.
 * <p/>
 * Command line interfaces also define a summary and a description. These attributes are used in the usage generation
 * . To disable the help generation, set the <code>hidden</code> attribute to <code>true</code>.
 * <p/>
 * Command Line Interface object does not contains "value", it's a model. It must be evaluated by a
 * parser that returns a {@link io.vertx.mutiny.core.cli.CommandLine} object containing the argument and option values.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.cli.CLI original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.cli.CLI.class)
public class CLI {

  public static final io.smallrye.mutiny.vertx.TypeArg<CLI> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CLI((io.vertx.core.cli.CLI) obj),
    CLI::getDelegate
  );

  private final io.vertx.core.cli.CLI delegate;
  
  public CLI(io.vertx.core.cli.CLI delegate) {
    this.delegate = delegate;
  }

  public CLI(Object delegate) {
    this.delegate = (io.vertx.core.cli.CLI)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CLI() {
    this.delegate = null;
  }

  public io.vertx.core.cli.CLI getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CLI that = (CLI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param name the name of the CLI (must not be <code>null</code>)
   * @return the created instance of {@link io.vertx.mutiny.core.cli.CLI}
   */
  public static io.vertx.mutiny.core.cli.CLI create(String name) { 
    io.vertx.mutiny.core.cli.CLI ret = io.vertx.mutiny.core.cli.CLI.newInstance((io.vertx.core.cli.CLI)io.vertx.core.cli.CLI.create(name));
    return ret;
  }

  /**
   * @param arguments the arguments
   * @return the creates command line
   */
  public io.vertx.mutiny.core.cli.CommandLine parse(List<String> arguments) { 
    io.vertx.mutiny.core.cli.CommandLine ret = io.vertx.mutiny.core.cli.CommandLine.newInstance((io.vertx.core.cli.CommandLine)delegate.parse(arguments));
    return ret;
  }

  /**
   * @param arguments the arguments
   * @param validate enable / disable parsing validation
   * @return the creates command line
   */
  public io.vertx.mutiny.core.cli.CommandLine parse(List<String> arguments, boolean validate) { 
    io.vertx.mutiny.core.cli.CommandLine ret = io.vertx.mutiny.core.cli.CommandLine.newInstance((io.vertx.core.cli.CommandLine)delegate.parse(arguments, validate));
    return ret;
  }

  /**
   * @return the CLI name.
   */
  public String getName() { 
    String ret = delegate.getName();
    return ret;
  }

  /**
   * @param name the name
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI setName(String name) { 
    delegate.setName(name);
    return this;
  }

  /**
   * @return the CLI description.
   */
  public String getDescription() { 
    String ret = delegate.getDescription();
    return ret;
  }

  @Fluent
  public io.vertx.mutiny.core.cli.CLI setDescription(String desc) { 
    delegate.setDescription(desc);
    return this;
  }

  /**
   * @return the CLI summary.
   */
  public String getSummary() { 
    String ret = delegate.getSummary();
    return ret;
  }

  /**
   * @param summary the summary
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI setSummary(String summary) { 
    delegate.setSummary(summary);
    return this;
  }

  /**
   * @return <code>true</code> if the current {@link io.vertx.mutiny.core.cli.CLI} is hidden,  otherwise
   */
  public boolean isHidden() { 
    boolean ret = delegate.isHidden();
    return ret;
  }

  /**
   * @param hidden enables or disables the hidden aspect of the CI
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI setHidden(boolean hidden) { 
    delegate.setHidden(hidden);
    return this;
  }

  /**
   * @return the list of options, empty if none.
   */
  public List<io.vertx.core.cli.Option> getOptions() { 
    List<io.vertx.core.cli.Option> ret = delegate.getOptions();
    return ret;
  }

  /**
   * @param option the option, must not be <code>null</code>.
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI addOption(io.vertx.core.cli.Option option) { 
    delegate.addOption(option);
    return this;
  }

  /**
   * @param options the options, must not be <code>null</code>
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI addOptions(List<io.vertx.core.cli.Option> options) { 
    delegate.addOptions(options);
    return this;
  }

  /**
   * @param options the list of options, must not be <code>null</code>
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI setOptions(List<io.vertx.core.cli.Option> options) { 
    delegate.setOptions(options);
    return this;
  }

  /**
   * @return the list of argument, empty if none.
   */
  public List<io.vertx.core.cli.Argument> getArguments() { 
    List<io.vertx.core.cli.Argument> ret = delegate.getArguments();
    return ret;
  }

  /**
   * @param arg the argument, must not be <code>null</code>
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI addArgument(io.vertx.core.cli.Argument arg) { 
    delegate.addArgument(arg);
    return this;
  }

  /**
   * @param args the arguments, must not be <code>null</code>
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI addArguments(List<io.vertx.core.cli.Argument> args) { 
    delegate.addArguments(args);
    return this;
  }

  /**
   * @param args the list of arguments, must not be <code>null</code>
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI setArguments(List<io.vertx.core.cli.Argument> args) { 
    delegate.setArguments(args);
    return this;
  }

  /**
   * @param name the name, must not be <code>null</code>
   * @return the {@link io.vertx.core.cli.Option}, <code>null</code> if not found
   */
  public io.vertx.core.cli.Option getOption(String name) { 
    io.vertx.core.cli.Option ret = delegate.getOption(name);
    return ret;
  }

  /**
   * @param name the name of the argument, must not be <code>null</code>
   * @return the {@link io.vertx.core.cli.Argument}, <code>null</code> if not found.
   */
  public io.vertx.core.cli.Argument getArgument(String name) { 
    io.vertx.core.cli.Argument ret = delegate.getArgument(name);
    return ret;
  }

  /**
   * @param index the index, must be positive or zero.
   * @return the {@link io.vertx.core.cli.Argument}, <code>null</code> if not found.
   */
  public io.vertx.core.cli.Argument getArgument(int index) { 
    io.vertx.core.cli.Argument ret = delegate.getArgument(index);
    return ret;
  }

  /**
   * @param name the option name
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI removeOption(String name) { 
    delegate.removeOption(name);
    return this;
  }

  /**
   * @param index the argument index
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI removeArgument(int index) { 
    delegate.removeArgument(index);
    return this;
  }

  /**
   * @return the CLI priority.
   */
  public int getPriority() { 
    int ret = delegate.getPriority();
    return ret;
  }

  /**
   * @param priority the priority
   * @return the current {@link io.vertx.mutiny.core.cli.CLI} instance
   */
  @Fluent
  public io.vertx.mutiny.core.cli.CLI setPriority(int priority) { 
    delegate.setPriority(priority);
    return this;
  }

  public static  CLI newInstance(io.vertx.core.cli.CLI arg) {
    return arg != null ? new CLI(arg) : null;
  }

}
