package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import javax.net.ssl.SSLSession;
import io.vertx.core.http.HttpVersion;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.core.http.StreamPriority;
import java.util.Set;
import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.Handler;

/**
 * Represents a server-side HTTP request.
 * <p>
 * Instances are created for each request and passed to the user via a handler.
 * <p>
 * Each instance of this class is associated with a corresponding {@link io.vertx.mutiny.core.http.HttpServerResponse} instance via
 * {@link io.vertx.mutiny.core.http.HttpServerRequest#response}.<p>
 * It implements {@link io.vertx.mutiny.core.streams.ReadStream} so it can be used with
 * {@link io.vertx.mutiny.core.streams.Pipe} to pipe data with flow control.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServerRequest original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpServerRequest.class)
public class HttpServerRequest implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpServerRequest> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpServerRequest((io.vertx.core.http.HttpServerRequest) obj),
    HttpServerRequest::getDelegate
  );

  private final io.vertx.core.http.HttpServerRequest delegate;
  
  public HttpServerRequest(io.vertx.core.http.HttpServerRequest delegate) {
    this.delegate = delegate;
  }

  public HttpServerRequest(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpServerRequest)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpServerRequest() {
    this.delegate = null;
  }

  public io.vertx.core.http.HttpServerRequest getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.Cookie> TYPE_ARG_2 = new TypeArg<io.vertx.mutiny.core.http.Cookie>(o1 -> io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.Cookie> TYPE_ARG_3 = new TypeArg<io.vertx.mutiny.core.http.Cookie>(o1 -> io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.Cookie> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.core.http.Cookie>(o1 -> io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServerRequest that = (HttpServerRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpServerRequest __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerRequest exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpServerRequest __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerRequest handler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.core.http.HttpServerRequest pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.http.HttpServerRequest resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.http.HttpServerRequest fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpServerRequest __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerRequest endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  /**
   * @return the HTTP version of the request
   */
  public io.vertx.core.http.HttpVersion version() { 
    io.vertx.core.http.HttpVersion ret = delegate.version();
    return ret;
  }

  /**
   * @return the HTTP method for the request.
   */
  public io.vertx.core.http.HttpMethod method() { 
    io.vertx.core.http.HttpMethod ret = delegate.method();
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.mutiny.core.net.NetSocket} is encrypted via SSL/TLS
   */
  public boolean isSSL() { 
    boolean ret = delegate.isSSL();
    return ret;
  }

  /**
   * @return the scheme of the request
   */
  public String scheme() { 
    String ret = delegate.scheme();
    return ret;
  }

  /**
   * @return the URI of the request. This is usually a relative URI
   */
  public String uri() { 
    String ret = delegate.uri();
    return ret;
  }

  /**
   * @return The path part of the uri. For example /somepath/somemorepath/someresource.foo
   */
  public String path() { 
    String ret = delegate.path();
    return ret;
  }

  /**
   * @return the query part of the uri. For example someparam=32&amp;someotherparam=x
   */
  public String query() { 
    String ret = delegate.query();
    return ret;
  }

  /**
   * @return the request authority. For HTTP/2 the  pseudo header is returned, for HTTP/1.x the  header is returned or <code>null</code> when no such header is present. When the authority string does not carry a port, the  returns <code>-1</code> to indicate the scheme port is prevalent.
   */
  public io.vertx.mutiny.core.net.HostAndPort authority() { 
    io.vertx.mutiny.core.net.HostAndPort ret = io.vertx.mutiny.core.net.HostAndPort.newInstance((io.vertx.core.net.HostAndPort)delegate.authority());
    return ret;
  }

  /**
   * @return the request host. For HTTP2 it returns the  pseudo header otherwise it returns the  header
   * @deprecated instead use {@link #authority()}   */
  @Deprecated
  public String host() { 
    String ret = delegate.host();
    return ret;
  }

  /**
   * @return the total number of bytes read for the body of the request.
   */
  public long bytesRead() { 
    long ret = delegate.bytesRead();
    return ret;
  }

  /**
   * @return the response. Each instance of this class has an {@link io.vertx.mutiny.core.http.HttpServerResponse} instance attached to it. This is used to send the response back to the client.
   */
  public io.vertx.mutiny.core.http.HttpServerResponse response() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.http.HttpServerResponse ret = io.vertx.mutiny.core.http.HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)delegate.response());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the headers in the request.
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    cached_1 = ret;
    return ret;
  }

  /**
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(String headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * @param charset the charset to use for decoding query params
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerRequest setParamsCharset(String charset) { 
    delegate.setParamsCharset(charset);
    return this;
  }

  /**
   * @return the charset used for decoding query parameters
   */
  public String getParamsCharset() { 
    String ret = delegate.getParamsCharset();
    return ret;
  }

  /**
   * @return the query parameters in the request
   */
  public io.vertx.mutiny.core.MultiMap params() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.params());
    cached_2 = ret;
    return ret;
  }

  /**
   * @param semicolonIsNormalChar whether semicolon is treated as a normal character or a query parameter separator
   * @return the query parameters in the request
   */
  public io.vertx.mutiny.core.MultiMap params(boolean semicolonIsNormalChar) { 
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.params(semicolonIsNormalChar));
    return ret;
  }

  /**
   * @param paramName the param name
   * @return the param value
   */
  public String getParam(String paramName) { 
    String ret = delegate.getParam(paramName);
    return ret;
  }

  /**
   * @param paramName the param name
   * @param defaultValue the default value, must be non-null
   * @return the param value or <code>defaultValue</code> when not present
   */
  public String getParam(String paramName, String defaultValue) { 
    String ret = delegate.getParam(paramName, defaultValue);
    return ret;
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_4 != null) {
      return cached_4;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_4 = ret;
    return ret;
  }

  /**
   * @return the absolute URI corresponding to the HTTP request
   */
  public String absoluteURI() { 
    String ret = delegate.absoluteURI();
    return ret;
  }

  /**
   * @param bodyHandler This handler will be called after all the body has been received
   * @return the instance of HttpServerRequest to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpServerRequest __bodyHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> bodyHandler) { 
    delegate.bodyHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(bodyHandler, event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  /**
   * @param bodyHandler This handler will be called after all the body has been received
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerRequest bodyHandler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> bodyHandler) {
    return __bodyHandler(bodyHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(bodyHandler) : null);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerRequest#body} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.buffer.Buffer> body() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.body(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerRequest#body}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Buffer instance produced by the operation.
   */
  public io.vertx.mutiny.core.buffer.Buffer bodyAndAwait() { 
    return (io.vertx.mutiny.core.buffer.Buffer) body().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerRequest#body} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerRequest#body}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerRequest#body} but you don't need to compose it with other operations.
   */
  public void bodyAndForget() { 
    body().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerRequest#end} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerRequest#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerRequest#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerRequest#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerRequest#end} but you don't need to compose it with other operations.
   */
  public void endAndForget() { 
    end().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Establish a TCP <a href="https://tools.ietf.org/html/rfc7231#section-4.3.6">tunnel<a/> with the client.
   *
   * <p> This must be called only for <code>CONNECT</code> HTTP method or for HTTP connection upgrade, before any response is sent.
   *
   * <p> Calling this sends a <code>200</code> response for a <code>CONNECT</code> or a <code>101</code> for a connection upgrade wit
   * no <code>content-length</code> header set and then provides the <code>NetSocket</code> for handling the created tunnel.
   * Any HTTP header set on the response before calling this method will be sent.
   *
   * <pre>
   * server.requestHandler(req -> {
   *   if (req.method() == HttpMethod.CONNECT) {
   *     // Send a 200 response to accept the connect
   *     NetSocket socket = req.netSocket();
   *     socket.handler(buff -> {
   *       socket.write(buff);
   *     });
   *   }
   *   ...
   * });
   * </pre>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.net.NetSocket> toNetSocket() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.toNetSocket(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerRequest#toNetSocket}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the NetSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.net.NetSocket toNetSocketAndAwait() { 
    return (io.vertx.mutiny.core.net.NetSocket) toNetSocket().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerRequest#toNetSocket} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerRequest#toNetSocket}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerRequest#toNetSocket} but you don't need to compose it with other operations.
   */
  public void toNetSocketAndForget() { 
    toNetSocket().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param expect true - if you are expecting a multi-part body
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerRequest setExpectMultipart(boolean expect) { 
    delegate.setExpectMultipart(expect);
    return this;
  }

  /**
   * @return true if we are expecting a multi-part body for this request. See {@link io.vertx.mutiny.core.http.HttpServerRequest#setExpectMultipart}.
   */
  public boolean isExpectMultipart() { 
    boolean ret = delegate.isExpectMultipart();
    return ret;
  }

  /**
   * @param uploadHandler 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpServerRequest __uploadHandler(Handler<io.vertx.mutiny.core.http.HttpServerFileUpload> uploadHandler) { 
    delegate.uploadHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(uploadHandler, event -> io.vertx.mutiny.core.http.HttpServerFileUpload.newInstance((io.vertx.core.http.HttpServerFileUpload)event)));
    return this;
  }

  /**
   * @param uploadHandler 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerRequest uploadHandler(java.util.function.Consumer<io.vertx.mutiny.core.http.HttpServerFileUpload> uploadHandler) {
    return __uploadHandler(uploadHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(uploadHandler) : null);
  }

  /**
   * @return the form attributes
   */
  public io.vertx.mutiny.core.MultiMap formAttributes() { 
    if (cached_5 != null) {
      return cached_5;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.formAttributes());
    cached_5 = ret;
    return ret;
  }

  /**
   * @param attributeName the attribute name
   * @return the attribute value
   */
  public String getFormAttribute(String attributeName) { 
    String ret = delegate.getFormAttribute(attributeName);
    return ret;
  }

  /**
   * @return the id of the stream of this request,  when it is not yet determined, i.e the request has not been yet sent or it is not supported HTTP/1.x
   */
  public int streamId() { 
    if (cached_6 != null) {
      return cached_6;
    }
    int ret = delegate.streamId();
    cached_6 = ret;
    return ret;
  }

  /**
   * Upgrade the connection of the current request to a WebSocket.
   * <p>
   * This is an alternative way of handling WebSockets and can only be used if no WebSocket handler is set on the
   * <code>HttpServer</code>, and can only be used during the upgrade request during the WebSocket handshake.
   *
   * <p> Both {@link io.vertx.mutiny.core.http.HttpServerRequest#handler} and {@link io.vertx.mutiny.core.http.HttpServerRequest#endHandler} will be set to get the full body of the
   * request that is necessary to perform the WebSocket handshake.
   *
   * <p> If you need to do an asynchronous upgrade, i.e not performed immediately in your request handler,
   * you need to {@link io.vertx.mutiny.core.http.HttpServerRequest#pause} the request in order to not lose HTTP events necessary to upgrade the
   * request.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.ServerWebSocket> toWebSocket() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.toWebSocket(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerRequest#toWebSocket}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the ServerWebSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.ServerWebSocket toWebSocketAndAwait() { 
    return (io.vertx.mutiny.core.http.ServerWebSocket) toWebSocket().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerRequest#toWebSocket} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerRequest#toWebSocket}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerRequest#toWebSocket} but you don't need to compose it with other operations.
   */
  public void toWebSocketAndForget() { 
    toWebSocket().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return true if ended
   */
  public boolean isEnded() { 
    boolean ret = delegate.isEnded();
    return ret;
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpServerRequest __customFrameHandler(Handler<io.vertx.mutiny.core.http.HttpFrame> handler) { 
    delegate.customFrameHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.core.http.HttpFrame.newInstance((io.vertx.core.http.HttpFrame)event)));
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerRequest customFrameHandler(java.util.function.Consumer<io.vertx.mutiny.core.http.HttpFrame> handler) {
    return __customFrameHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @return the {@link io.vertx.mutiny.core.http.HttpConnection} associated with this request
   */
  public io.vertx.mutiny.core.http.HttpConnection connection() { 
    if (cached_7 != null) {
      return cached_7;
    }
    io.vertx.mutiny.core.http.HttpConnection ret = io.vertx.mutiny.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)delegate.connection());
    cached_7 = ret;
    return ret;
  }

  /**
   * @return the priority of the associated HTTP/2 stream for HTTP/2 otherwise <code>null</code>
   */
  public io.vertx.core.http.StreamPriority streamPriority() { 
    io.vertx.core.http.StreamPriority ret = delegate.streamPriority();
    return ret;
  }

  /**
   * @param handler the handler to be called when stream priority changes
   * @return the instance of HttpServerRequest to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpServerRequest __streamPriorityHandler(Handler<io.vertx.core.http.StreamPriority> handler) { 
    delegate.streamPriorityHandler(handler);
    return this;
  }

  /**
   * @param handler the handler to be called when stream priority changes
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerRequest streamPriorityHandler(java.util.function.Consumer<io.vertx.core.http.StreamPriority> handler) {
    return __streamPriorityHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param name the cookie name
   * @return the cookie or <code>null</code> if not found.
   */
  public io.vertx.mutiny.core.http.Cookie getCookie(String name) { 
    io.vertx.mutiny.core.http.Cookie ret = io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)delegate.getCookie(name));
    return ret;
  }

  /**
   * @param name the cookie name
   * @param domain the cookie domain
   * @param path the cookie path
   * @return the cookie or <code>null</code> if not found.
   */
  public io.vertx.mutiny.core.http.Cookie getCookie(String name, String domain, String path) { 
    io.vertx.mutiny.core.http.Cookie ret = io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)delegate.getCookie(name, domain, path));
    return ret;
  }

  /**
   * @return the number of cookies in the cookie jar.
   */
  public int cookieCount() { 
    int ret = delegate.cookieCount();
    return ret;
  }

  /**
   * @return a map of all the cookies.
   * @deprecated the implementation made a wrong assumption that cookies could be identified only by their name. The RFC states that the tuple of {@code <name, domain, path>} is the unique identifier. When more than one cookie has the same name, the map will hold that lost one to be parsed and any previously parsed value will be silently overwritten.   */
  @Deprecated
  public java.util.Map<String, io.vertx.mutiny.core.http.Cookie> cookieMap() { 
    java.util.Map<String, io.vertx.mutiny.core.http.Cookie> ret = delegate.cookieMap().entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)_e.getValue())));
    return ret;
  }

  /**
   * @param name the name to be matches
   * @return the matching cookies or empty set
   */
  public Set<io.vertx.mutiny.core.http.Cookie> cookies(String name) { 
    Set<io.vertx.mutiny.core.http.Cookie> ret = delegate.cookies(name).stream().map(elt -> io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)elt)).collect(java.util.stream.Collectors.toSet());
    return ret;
  }

  /**
   * @return a set with all cookies in the cookie jar.
   */
  public Set<io.vertx.mutiny.core.http.Cookie> cookies() { 
    Set<io.vertx.mutiny.core.http.Cookie> ret = delegate.cookies().stream().map(elt -> io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)elt)).collect(java.util.stream.Collectors.toSet());
    return ret;
  }

  /**
   * @param route The route this request has been routed to.
   * @return the instance of HttpServerRequest to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerRequest routed(String route) { 
    delegate.routed(route);
    return this;
  }

  /**
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(java.lang.CharSequence headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.mutiny.core.http.HttpServerResponse cached_0;
  private io.vertx.mutiny.core.MultiMap cached_1;
  private io.vertx.mutiny.core.MultiMap cached_2;
  private io.vertx.mutiny.core.net.SocketAddress cached_3;
  private io.vertx.mutiny.core.net.SocketAddress cached_4;
  private io.vertx.mutiny.core.MultiMap cached_5;
  private java.lang.Integer cached_6;
  private io.vertx.mutiny.core.http.HttpConnection cached_7;
  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  HttpServerRequest newInstance(io.vertx.core.http.HttpServerRequest arg) {
    return arg != null ? new HttpServerRequest(arg) : null;
  }

}
