package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.http.StreamPriority;
import java.util.Set;
import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a server-side HTTP response.
 * <p>
 * An instance of this is created and associated to every instance of
 * {@link io.vertx.mutiny.core.http.HttpServerRequest} that.
 * <p>
 * It allows the developer to control the HTTP response that is sent back to the
 * client for a particular HTTP request.
 * <p>
 * It contains methods that allow HTTP headers and trailers to be set, and for a body to be written out to the response.
 * <p>
 * It also allows files to be streamed by the kernel directly from disk to the
 * outgoing HTTP connection, bypassing user space altogether (where supported by
 * the underlying operating system). This is a very efficient way of
 * serving files from the server since buffers do not have to be read one by one
 * from the file and written to the outgoing socket.
 * <p>
 * It implements {@link io.vertx.mutiny.core.streams.WriteStream} so it can be used with
 * {@link io.vertx.mutiny.core.streams.Pipe} to pipe data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServerResponse original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpServerResponse.class)
public class HttpServerResponse implements io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpServerResponse> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpServerResponse((io.vertx.core.http.HttpServerResponse) obj),
    HttpServerResponse::getDelegate
  );

  private final io.vertx.core.http.HttpServerResponse delegate;
  
  public HttpServerResponse(io.vertx.core.http.HttpServerResponse delegate) {
    this.delegate = delegate;
  }

  public HttpServerResponse(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpServerResponse)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpServerResponse() {
    this.delegate = null;
  }

  public io.vertx.core.http.HttpServerResponse getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.Cookie> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.core.http.Cookie>(o1 -> io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.Cookie> TYPE_ARG_2 = new TypeArg<io.vertx.mutiny.core.http.Cookie>(o1 -> io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.http.HttpServerResponse> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.http.HttpServerResponse>(o1 -> io.vertx.mutiny.core.http.HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServerResponse that = (HttpServerResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  private io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> subscriber;

  @CheckReturnValue
  public synchronized io.smallrye.mutiny.vertx.WriteStreamSubscriber<io.vertx.mutiny.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<io.vertx.mutiny.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::getDelegate;
      subscriber = io.smallrye.mutiny.vertx.MutinyHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> write(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.write(data.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation.
   */
  public Void writeAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (Void) write(data).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#write(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data 
   */
  public void writeAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    write(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#end} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end} but you don't need to compose it with other operations.
   */
  public void endAndForget() { 
    end().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpServerResponse __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerResponse exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpServerResponse __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerResponse drainHandler(java.lang.Runnable handler) {
    return __drainHandler(ignored -> handler.run()
);
  }

  /**
   * @return the HTTP status code of the response. The default is <code>200</code> representing <code>OK</code>.
   */
  public int getStatusCode() { 
    int ret = delegate.getStatusCode();
    return ret;
  }

  /**
   * @param statusCode 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse setStatusCode(int statusCode) { 
    delegate.setStatusCode(statusCode);
    return this;
  }

  /**
   * @return the HTTP status message of the response. If this is not specified a default value will be used depending on what {@link io.vertx.mutiny.core.http.HttpServerResponse#setStatusCode} has been set to.
   */
  public String getStatusMessage() { 
    String ret = delegate.getStatusMessage();
    return ret;
  }

  /**
   * @param statusMessage 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse setStatusMessage(String statusMessage) { 
    delegate.setStatusMessage(statusMessage);
    return this;
  }

  /**
   * @param chunked 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse setChunked(boolean chunked) { 
    delegate.setChunked(chunked);
    return this;
  }

  /**
   * @return is the response chunked?
   */
  public boolean isChunked() { 
    boolean ret = delegate.isChunked();
    return ret;
  }

  /**
   * @return The HTTP headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    cached_0 = ret;
    return ret;
  }

  /**
   * @param name the header name
   * @param value the header value.
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse putHeader(String name, String value) { 
    delegate.putHeader(name, value);
    return this;
  }

  /**
   * @return The HTTP trailers
   */
  public io.vertx.mutiny.core.MultiMap trailers() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.trailers());
    cached_1 = ret;
    return ret;
  }

  /**
   * @param name the trailer name
   * @param value the trailer value
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse putTrailer(String name, String value) { 
    delegate.putTrailer(name, value);
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpServerResponse __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpServerResponse __endHandler(Handler<Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse endHandler(java.lang.Runnable handler) {
    return __endHandler(ignored -> handler.run()
);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#write} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param chunk 
   * @param enc 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> write(String chunk, String enc) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.write(chunk, enc, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param chunk 
   * @param enc 
   * @return the Void instance produced by the operation.
   */
  public Void writeAndAwait(String chunk, String enc) { 
    return (Void) write(chunk, enc).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String,String)} but you don't need to compose it with other operations.
   * @param chunk 
   * @param enc 
   */
  public void writeAndForget(String chunk, String enc) { 
    write(chunk, enc).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#write} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param chunk 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> write(String chunk) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.write(chunk, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param chunk 
   * @return the Void instance produced by the operation.
   */
  public Void writeAndAwait(String chunk) { 
    return (Void) write(chunk).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#write(String)} but you don't need to compose it with other operations.
   * @param chunk 
   */
  public void writeAndForget(String chunk) { 
    write(chunk).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse writeContinue() { 
    delegate.writeContinue();
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#writeEarlyHints} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param headers headers to write
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> writeEarlyHints(io.vertx.mutiny.core.MultiMap headers) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.writeEarlyHints(headers.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#writeEarlyHints(io.vertx.mutiny.core.MultiMap)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param headers headers to write
   * @return the Void instance produced by the operation.
   */
  public Void writeEarlyHintsAndAwait(io.vertx.mutiny.core.MultiMap headers) { 
    return (Void) writeEarlyHints(headers).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#writeEarlyHints(io.vertx.mutiny.core.MultiMap)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#writeEarlyHints(io.vertx.mutiny.core.MultiMap)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#writeEarlyHints(io.vertx.mutiny.core.MultiMap)} but you don't need to compose it with other operations.
   * @param headers headers to write
   */
  public void writeEarlyHintsAndForget(io.vertx.mutiny.core.MultiMap headers) { 
    writeEarlyHints(headers).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#end} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param chunk 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end(String chunk) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(chunk, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param chunk 
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait(String chunk) { 
    return (Void) end(chunk).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String)} but you don't need to compose it with other operations.
   * @param chunk 
   */
  public void endAndForget(String chunk) { 
    end(chunk).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#end} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param chunk 
   * @param enc 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end(String chunk, String enc) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(chunk, enc, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param chunk 
   * @param enc 
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait(String chunk, String enc) { 
    return (Void) end(chunk, enc).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#end(String,String)} but you don't need to compose it with other operations.
   * @param chunk 
   * @param enc 
   */
  public void endAndForget(String chunk, String enc) { 
    end(chunk, enc).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#end} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param chunk 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end(io.vertx.mutiny.core.buffer.Buffer chunk) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(chunk.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param chunk 
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait(io.vertx.mutiny.core.buffer.Buffer chunk) { 
    return (Void) end(chunk).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param chunk 
   */
  public void endAndForget(io.vertx.mutiny.core.buffer.Buffer chunk) { 
    end(chunk).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Send the request with an empty body.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> send() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.send(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#send}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void sendAndAwait() { 
    return (Void) send().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#send} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#send}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#send} but you don't need to compose it with other operations.
   */
  public void sendAndForget() { 
    send().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Send the request with a string <code>body</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> send(String body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.send(body, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body 
   * @return the Void instance produced by the operation.
   */
  public Void sendAndAwait(String body) { 
    return (Void) send(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#send(String)} but you don't need to compose it with other operations.
   * @param body 
   */
  public void sendAndForget(String body) { 
    send(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Send the request with a buffer <code>body</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> send(io.vertx.mutiny.core.buffer.Buffer body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.send(body.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body 
   * @return the Void instance produced by the operation.
   */
  public Void sendAndAwait(io.vertx.mutiny.core.buffer.Buffer body) { 
    return (Void) send(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#send(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param body 
   */
  public void sendAndForget(io.vertx.mutiny.core.buffer.Buffer body) { 
    send(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Send the request with a stream <code>body</code>.
   *
   * <p> If the {@link io.vertx.mutiny.core.http.HttpHeaders} is set then the request assumes this is the
   * length of the {stream}, otherwise the request will set a chunked {@link io.vertx.mutiny.core.http.HttpHeaders}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> send(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.send(body.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(io.vertx.mutiny.core.streams.ReadStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body 
   * @return the Void instance produced by the operation.
   */
  public Void sendAndAwait(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> body) { 
    return (Void) send(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(io.vertx.mutiny.core.streams.ReadStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(io.vertx.mutiny.core.streams.ReadStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#send(io.vertx.mutiny.core.streams.ReadStream)} but you don't need to compose it with other operations.
   * @param body 
   */
  public void sendAndForget(io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> body) { 
    send(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Send the request with a stream <code>body</code>.
   *
   * <p> If the {@link io.vertx.mutiny.core.http.HttpHeaders} is set then the request assumes this is the
   * length of the {stream}, otherwise the request will set a chunked {@link io.vertx.mutiny.core.http.HttpHeaders}.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param body 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> send(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> body) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.send(io.smallrye.mutiny.vertx.ReadStreamSubscriber.asReadStream(body,obj -> (io.vertx.core.buffer.Buffer) obj.getDelegate()).resume(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(Flow$Publisher)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param body 
   * @return the Void instance produced by the operation.
   */
  public Void sendAndAwait(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> body) { 
    return (Void) send(body).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(Flow$Publisher)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#send(Flow$Publisher)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#send(Flow$Publisher)} but you don't need to compose it with other operations.
   * @param body 
   */
  public void sendAndForget(java.util.concurrent.Flow.Publisher<io.vertx.mutiny.core.buffer.Buffer> body) { 
    send(body).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile} but providing a handler which will be notified once the file has been completely
   * written to the wire.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename path to the file to serve
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> sendFile(String filename) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.sendFile(filename, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename path to the file to serve
   * @return the Void instance produced by the operation.
   */
  public Void sendFileAndAwait(String filename) { 
    return (Void) sendFile(filename).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String)} but you don't need to compose it with other operations.
   * @param filename path to the file to serve
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse sendFileAndForget(String filename) { 
    sendFile(filename).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile} but providing a handler which will be notified once the file has been completely
   * written to the wire.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> sendFile(String filename, long offset) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.sendFile(filename, offset, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @return the Void instance produced by the operation.
   */
  public Void sendFileAndAwait(String filename, long offset) { 
    return (Void) sendFile(filename, offset).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long)} but you don't need to compose it with other operations.
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse sendFileAndForget(String filename, long offset) { 
    sendFile(filename, offset).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile} but providing a handler which will be notified once the file has been
   * completely written to the wire.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @param length length the number of bytes to send
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> sendFile(String filename, long offset, long length) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.sendFile(filename, offset, length, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @param length length the number of bytes to send
   * @return the Void instance produced by the operation.
   */
  public Void sendFileAndAwait(String filename, long offset, long length) { 
    return (Void) sendFile(filename, offset, length).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#sendFile(String,long,long)} but you don't need to compose it with other operations.
   * @param filename path to the file to serve
   * @param offset the offset to serve from
   * @param length length the number of bytes to send
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse sendFileAndForget(String filename, long offset, long length) { 
    sendFile(filename, offset, length).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @deprecated instead use {@link HttpConnection#close()} or {@link #reset(long)}, this method is removed in Vert.x 5   */
  @Deprecated
  public void close() { 
    delegate.close();
  }

  /**
   * @return has the response already ended?
   */
  public boolean ended() { 
    boolean ret = delegate.ended();
    return ret;
  }

  /**
   * @return has the underlying TCP connection corresponding to the request already been closed?
   */
  public boolean closed() { 
    boolean ret = delegate.closed();
    return ret;
  }

  /**
   * @return have the headers for the response already been written?
   */
  public boolean headWritten() { 
    boolean ret = delegate.headWritten();
    return ret;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpServerResponse __headersEndHandler(Handler<Void> handler) { 
    delegate.headersEndHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse headersEndHandler(java.lang.Runnable handler) {
    return __headersEndHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpServerResponse __bodyEndHandler(Handler<Void> handler) { 
    delegate.bodyEndHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpServerResponse bodyEndHandler(java.lang.Runnable handler) {
    return __bodyEndHandler(ignored -> handler.run()
);
  }

  /**
   * @return the total number of bytes written for the body of the response.
   */
  public long bytesWritten() { 
    long ret = delegate.bytesWritten();
    return ret;
  }

  /**
   * @return the id of the stream of this response,  for HTTP/1.x
   */
  public int streamId() { 
    int ret = delegate.streamId();
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#push} with no headers.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method 
   * @param host 
   * @param path 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpServerResponse> push(io.vertx.core.http.HttpMethod method, String host, String path) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.push(method, host, path, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.http.HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method 
   * @param host 
   * @param path 
   * @return the HttpServerResponse instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndAwait(io.vertx.core.http.HttpMethod method, String host, String path) { 
    return (io.vertx.mutiny.core.http.HttpServerResponse) push(method, host, path).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,String)} but you don't need to compose it with other operations.
   * @param method 
   * @param host 
   * @param path 
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndForget(io.vertx.core.http.HttpMethod method, String host, String path) { 
    push(method, host, path).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#push} with the host copied from the current request.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method 
   * @param path 
   * @param headers 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpServerResponse> push(io.vertx.core.http.HttpMethod method, String path, io.vertx.mutiny.core.MultiMap headers) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.push(method, path, headers.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.http.HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,io.vertx.mutiny.core.MultiMap)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method 
   * @param path 
   * @param headers 
   * @return the HttpServerResponse instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndAwait(io.vertx.core.http.HttpMethod method, String path, io.vertx.mutiny.core.MultiMap headers) { 
    return (io.vertx.mutiny.core.http.HttpServerResponse) push(method, path, headers).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,io.vertx.mutiny.core.MultiMap)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,io.vertx.mutiny.core.MultiMap)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,io.vertx.mutiny.core.MultiMap)} but you don't need to compose it with other operations.
   * @param method 
   * @param path 
   * @param headers 
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndForget(io.vertx.core.http.HttpMethod method, String path, io.vertx.mutiny.core.MultiMap headers) { 
    push(method, path, headers).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpServerResponse#push} with the host copied from the current request.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method 
   * @param path 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpServerResponse> push(io.vertx.core.http.HttpMethod method, String path) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.push(method, path, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.http.HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method 
   * @param path 
   * @return the HttpServerResponse instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndAwait(io.vertx.core.http.HttpMethod method, String path) { 
    return (io.vertx.mutiny.core.http.HttpServerResponse) push(method, path).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String)} but you don't need to compose it with other operations.
   * @param method 
   * @param path 
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndForget(io.vertx.core.http.HttpMethod method, String path) { 
    push(method, path).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Push a response to the client.<p/>
   *
   * The <code>handler</code> will be notified with a <i>success</i> when the push can be sent and with
   * a <i>failure</i> when the client has disabled push or reset the push before it has been sent.<p/>
   *
   * The <code>handler</code> may be queued if the client has reduced the maximum number of streams the server can push
   * concurrently.<p/>
   *
   * Push can be sent only for peer initiated streams and if the response is not ended.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method the method of the promised request
   * @param host 
   * @param path the path of the promised request
   * @param headers the headers of the promised request
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpServerResponse> push(io.vertx.core.http.HttpMethod method, String host, String path, io.vertx.mutiny.core.MultiMap headers) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.push(method, host, path, headers.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.core.http.HttpServerResponse.newInstance((io.vertx.core.http.HttpServerResponse)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,String,io.vertx.mutiny.core.MultiMap)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method the method of the promised request
   * @param host 
   * @param path the path of the promised request
   * @param headers the headers of the promised request
   * @return the HttpServerResponse instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndAwait(io.vertx.core.http.HttpMethod method, String host, String path, io.vertx.mutiny.core.MultiMap headers) { 
    return (io.vertx.mutiny.core.http.HttpServerResponse) push(method, host, path, headers).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,String,io.vertx.mutiny.core.MultiMap)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,String,io.vertx.mutiny.core.MultiMap)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,String,String,io.vertx.mutiny.core.MultiMap)} but you don't need to compose it with other operations.
   * @param method the method of the promised request
   * @param host 
   * @param path the path of the promised request
   * @param headers the headers of the promised request
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndForget(io.vertx.core.http.HttpMethod method, String host, String path, io.vertx.mutiny.core.MultiMap headers) { 
    push(method, host, path, headers).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpServerResponse#push} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param method 
   * @param authority 
   * @param path 
   * @param headers 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpServerResponse> push(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.HostAndPort authority, String path, io.vertx.mutiny.core.MultiMap headers) { 
    return io.smallrye.mutiny.vertx.UniHelper.toUni(delegate.push(method, authority.getDelegate(), path, headers.getDelegate()).map(x -> HttpServerResponse.newInstance(x)));}

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,io.vertx.mutiny.core.net.HostAndPort,String,io.vertx.mutiny.core.MultiMap)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param method 
   * @param authority 
   * @param path 
   * @param headers 
   * @return the HttpServerResponse instance produced by the operation.
   */
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndAwait(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.HostAndPort authority, String path, io.vertx.mutiny.core.MultiMap headers) { 
    return push(method, authority, path, headers).await().indefinitely();
  }


  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,io.vertx.mutiny.core.net.HostAndPort,String,io.vertx.mutiny.core.MultiMap)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,io.vertx.mutiny.core.net.HostAndPort,String,io.vertx.mutiny.core.MultiMap)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerResponse#push(HttpMethod,io.vertx.mutiny.core.net.HostAndPort,String,io.vertx.mutiny.core.MultiMap)} but you don't need to compose it with other operations.
   * @param method 
   * @param authority 
   * @param path 
   * @param headers 
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse pushAndForget(io.vertx.core.http.HttpMethod method, io.vertx.mutiny.core.net.HostAndPort authority, String path, io.vertx.mutiny.core.MultiMap headers) { 
    push(method, authority, path, headers).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }


  /**
   * @return 
   */
  public boolean reset() { 
    boolean ret = delegate.reset();
    return ret;
  }

  /**
   * @param code the error code
   * @return <code>true</code> when reset has been performed
   */
  public boolean reset(long code) { 
    boolean ret = delegate.reset(code);
    return ret;
  }

  /**
   * @param type the 8-bit frame type
   * @param flags the 8-bit frame flags
   * @param payload the frame payload
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse writeCustomFrame(int type, int flags, io.vertx.mutiny.core.buffer.Buffer payload) { 
    delegate.writeCustomFrame(type, flags, payload.getDelegate());
    return this;
  }

  /**
   * @param frame the frame to write
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse writeCustomFrame(io.vertx.mutiny.core.http.HttpFrame frame) { 
    delegate.writeCustomFrame(frame.getDelegate());
    return this;
  }

  /**
   * @param streamPriority the priority for this request's stream
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse setStreamPriority(io.vertx.core.http.StreamPriority streamPriority) { 
    delegate.setStreamPriority(streamPriority);
    return this;
  }

  /**
   * @param cookie the cookie
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse addCookie(io.vertx.mutiny.core.http.Cookie cookie) { 
    delegate.addCookie(cookie.getDelegate());
    return this;
  }

  /**
   * @param name the name of the cookie
   * @return the cookie, if it existed, or null
   */
  public io.vertx.mutiny.core.http.Cookie removeCookie(String name) { 
    io.vertx.mutiny.core.http.Cookie ret = io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)delegate.removeCookie(name));
    return ret;
  }

  /**
   * @param name the name of the cookie
   * @param invalidate 
   * @return the cookie, if it existed, or <code>null</code>
   */
  public io.vertx.mutiny.core.http.Cookie removeCookie(String name, boolean invalidate) { 
    io.vertx.mutiny.core.http.Cookie ret = io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)delegate.removeCookie(name, invalidate));
    return ret;
  }

  /**
   * @param name the name of the cookie
   * @return a read only set of affected cookies, if they existed, or an empty set.
   */
  public Set<io.vertx.mutiny.core.http.Cookie> removeCookies(String name) { 
    Set<io.vertx.mutiny.core.http.Cookie> ret = delegate.removeCookies(name).stream().map(elt -> io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)elt)).collect(java.util.stream.Collectors.toSet());
    return ret;
  }

  /**
   * @param name the name of the cookie
   * @param invalidate invalidate from the user agent
   * @return a read only set of affected cookies, if they existed, or an empty set.
   */
  public Set<io.vertx.mutiny.core.http.Cookie> removeCookies(String name, boolean invalidate) { 
    Set<io.vertx.mutiny.core.http.Cookie> ret = delegate.removeCookies(name, invalidate).stream().map(elt -> io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)elt)).collect(java.util.stream.Collectors.toSet());
    return ret;
  }

  /**
   * @param name the name of the cookie
   * @param domain the domain of the cookie
   * @param path the path of the cookie
   * @return the cookie, if it existed, or <code>null</code>
   */
  public io.vertx.mutiny.core.http.Cookie removeCookie(String name, String domain, String path) { 
    io.vertx.mutiny.core.http.Cookie ret = io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)delegate.removeCookie(name, domain, path));
    return ret;
  }

  /**
   * @param name the name of the cookie
   * @param domain the domain of the cookie
   * @param path the path of the cookie
   * @param invalidate 
   * @return the cookie, if it existed, or <code>null</code>
   */
  public io.vertx.mutiny.core.http.Cookie removeCookie(String name, String domain, String path, boolean invalidate) { 
    io.vertx.mutiny.core.http.Cookie ret = io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)delegate.removeCookie(name, domain, path, invalidate));
    return ret;
  }

  /**
   * @param name 
   * @param value 
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse putHeader(java.lang.CharSequence name, java.lang.CharSequence value) { 
    delegate.putHeader(name, value);
    return this;
  }

  /**
   * @param name 
   * @param values 
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse putHeader(String name, java.lang.Iterable<String> values) { 
    delegate.putHeader(name, values);
    return this;
  }

  /**
   * @param name 
   * @param values 
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse putHeader(java.lang.CharSequence name, java.lang.Iterable<java.lang.CharSequence> values) { 
    delegate.putHeader(name, values);
    return this;
  }

  /**
   * @param name 
   * @param value 
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse putTrailer(java.lang.CharSequence name, java.lang.CharSequence value) { 
    delegate.putTrailer(name, value);
    return this;
  }

  /**
   * @param name 
   * @param values 
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse putTrailer(String name, java.lang.Iterable<String> values) { 
    delegate.putTrailer(name, values);
    return this;
  }

  /**
   * @param name 
   * @param value 
   * @return the instance of HttpServerResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpServerResponse putTrailer(java.lang.CharSequence name, java.lang.Iterable<java.lang.CharSequence> value) { 
    delegate.putTrailer(name, value);
    return this;
  }

  private io.vertx.mutiny.core.MultiMap cached_0;
  private io.vertx.mutiny.core.MultiMap cached_1;
  public static  HttpServerResponse newInstance(io.vertx.core.http.HttpServerResponse arg) {
    return arg != null ? new HttpServerResponse(arg) : null;
  }

}
