/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.vertx.core.json.JsonObject;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class JsonHelper {
    public static JsonObject asJsonObject(Config config) {
        JsonObject json = new JsonObject();
        Iterable propertyNames = config.getPropertyNames();
        for (String originalKey : propertyNames) {
            JsonHelper.extractConfigKey(config, json, originalKey, "");
        }
        return json;
    }

    public static JsonObject asJsonObject(Config config, String prefix) {
        JsonObject json = new JsonObject();
        Iterable propertyNames = config.getPropertyNames();
        for (String originalKey : propertyNames) {
            if (!originalKey.startsWith(prefix)) continue;
            JsonHelper.extractConfigKey(config, json, originalKey, prefix);
        }
        return json;
    }

    private static void extractConfigKey(Config config, JsonObject json, String originalKey, String prefixToStrip) {
        Optional d2;
        String key = originalKey;
        if (key.contains("_") || JsonHelper.allCaps(key)) {
            key = originalKey.toLowerCase().replace("_", ".");
        }
        String jsonKey = key.substring(prefixToStrip.length());
        try {
            Optional i = config.getOptionalValue(key, Integer.class);
            if (!i.isPresent()) {
                i = config.getOptionalValue(originalKey, Integer.class);
            }
            if (i.isPresent() && i.get() instanceof Integer) {
                json.put(jsonKey, i.get());
                return;
            }
        }
        catch (ClassCastException | IllegalArgumentException i) {
            // empty catch block
        }
        try {
            d2 = config.getOptionalValue(key, Double.class);
            if (!d2.isPresent()) {
                d2 = config.getOptionalValue(originalKey, Double.class);
            }
            if (d2.isPresent() && d2.get() instanceof Double) {
                json.put(jsonKey, d2.get());
                return;
            }
        }
        catch (ClassCastException | IllegalArgumentException d2) {
            // empty catch block
        }
        try {
            String s = config.getOptionalValue(key, String.class).orElseGet(() -> config.getOptionalValue(originalKey, String.class).orElse(null));
            if (s != null) {
                String value = s.trim();
                if (value.equalsIgnoreCase("false")) {
                    json.put(jsonKey, (Object)false);
                } else if (value.equalsIgnoreCase("true")) {
                    json.put(jsonKey, (Object)true);
                } else {
                    json.put(jsonKey, (Object)value);
                }
                return;
            }
        }
        catch (ClassCastException s) {
            // empty catch block
        }
        try {
            d2 = config.getOptionalValue(key, Boolean.class);
            if (!d2.isPresent()) {
                d2 = config.getOptionalValue(originalKey, Boolean.class);
            }
            if (d2.isPresent()) {
                json.put(jsonKey, d2.get());
            }
        }
        catch (ClassCastException | IllegalArgumentException runtimeException) {
            // empty catch block
        }
    }

    private static boolean allCaps(String key) {
        return key.toUpperCase().equals(key);
    }
}

