/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt.session;

import io.netty.handler.logging.ByteBufFormat;
import io.smallrye.reactive.messaging.mqtt.session.ConstantReconnectDelayOptions;
import io.smallrye.reactive.messaging.mqtt.session.ReconnectDelayOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.mqtt.MqttClientOptions;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MqttClientSessionOptions
extends MqttClientOptions {
    private static final ReconnectDelayOptions DEFAULT_RECONNECT_DELAY = new ConstantReconnectDelayOptions();
    private static final Optional<String> DEFAULT_SERVER_NAME = Optional.empty();
    private String hostname = "localhost";
    private Optional<String> serverName = DEFAULT_SERVER_NAME;
    private int port = 1883;
    private ReconnectDelayOptions reconnectDelay = DEFAULT_RECONNECT_DELAY;
    private boolean unsubscribeOnDisconnect = false;

    public MqttClientSessionOptions() {
    }

    public MqttClientSessionOptions(MqttClientSessionOptions other) {
        super((MqttClientOptions)other);
        this.hostname = other.hostname;
        this.port = other.port;
        this.serverName = other.serverName;
        this.reconnectDelay = other.reconnectDelay.copy();
    }

    public int getPort() {
        return this.port;
    }

    public MqttClientSessionOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public MqttClientSessionOptions setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public MqttClientSessionOptions setReconnectDelay(ReconnectDelayOptions reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
        return this;
    }

    public ReconnectDelayOptions getReconnectDelay() {
        return this.reconnectDelay;
    }

    public Optional<String> getServerName() {
        return this.serverName;
    }

    public MqttClientSessionOptions setServerName(Optional<String> serverName) {
        this.serverName = serverName;
        return this;
    }

    public boolean isUnsubscribeOnDisconnect() {
        return this.unsubscribeOnDisconnect;
    }

    public void setUnsubscribeOnDisconnect(boolean unsubscribeOnDisconnect) {
        this.unsubscribeOnDisconnect = unsubscribeOnDisconnect;
    }

    public MqttClientSessionOptions setClientId(String clientId) {
        super.setClientId(clientId);
        return this;
    }

    public MqttClientSessionOptions setUsername(String username) {
        super.setUsername(username);
        return this;
    }

    public MqttClientSessionOptions setPassword(String password) {
        super.setPassword(password);
        return this;
    }

    public MqttClientSessionOptions setWillTopic(String willTopic) {
        super.setWillTopic(willTopic);
        return this;
    }

    @Deprecated
    public MqttClientSessionOptions setWillMessage(String willMessage) {
        super.setWillMessage(willMessage);
        return this;
    }

    public MqttClientOptions setWillMessageBytes(Buffer willMessage) {
        super.setWillMessageBytes(willMessage);
        return this;
    }

    public MqttClientSessionOptions setCleanSession(boolean cleanSession) {
        super.setCleanSession(cleanSession);
        return this;
    }

    public MqttClientSessionOptions setWillFlag(boolean willFlag) {
        super.setWillFlag(willFlag);
        return this;
    }

    public MqttClientSessionOptions setWillQoS(int willQoS) {
        super.setWillQoS(willQoS);
        return this;
    }

    public MqttClientSessionOptions setWillRetain(boolean willRetain) {
        super.setWillRetain(willRetain);
        return this;
    }

    public MqttClientSessionOptions setKeepAliveInterval(int keepAliveInterval) {
        super.setKeepAliveInterval(keepAliveInterval);
        return this;
    }

    public MqttClientSessionOptions setAckTimeout(int ackTimeoutSeconds) {
        super.setAckTimeout(ackTimeoutSeconds);
        return this;
    }

    public MqttClientSessionOptions setMaxInflightQueue(int maxInflightQueue) {
        super.setMaxInflightQueue(maxInflightQueue);
        return this;
    }

    public MqttClientSessionOptions setAutoKeepAlive(boolean isAutoKeepAlive) {
        super.setAutoKeepAlive(isAutoKeepAlive);
        return this;
    }

    public MqttClientSessionOptions setAutoGeneratedClientId(boolean isAutoGeneratedClientId) {
        super.setAutoGeneratedClientId(isAutoGeneratedClientId);
        return this;
    }

    public MqttClientSessionOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public MqttClientSessionOptions setMaxMessageSize(int maxMessageSize) {
        super.setMaxMessageSize(maxMessageSize);
        return this;
    }

    public MqttClientSessionOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    public MqttClientSessionOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public MqttClientSessionOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    public MqttClientSessionOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    public MqttClientSessionOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    public MqttClientSessionOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    public MqttClientSessionOptions setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    public MqttClientSessionOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    public MqttClientSessionOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    public MqttClientSessionOptions setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    public MqttClientSessionOptions setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }

    public MqttClientSessionOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    public MqttClientSessionOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public MqttClientSessionOptions addCrlPath(String crlPath) throws NullPointerException {
        super.addCrlPath(crlPath);
        return this;
    }

    public MqttClientSessionOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        super.addCrlValue(crlValue);
        return this;
    }

    public MqttClientSessionOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    public MqttClientSessionOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    public MqttClientSessionOptions setReusePort(boolean reusePort) {
        super.setReusePort(reusePort);
        return this;
    }

    public MqttClientSessionOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    public MqttClientSessionOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    public MqttClientSessionOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    public MqttClientSessionOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    public MqttClientSessionOptions setReadIdleTimeout(int idleTimeout) {
        super.setReadIdleTimeout(idleTimeout);
        return this;
    }

    public MqttClientSessionOptions setWriteIdleTimeout(int idleTimeout) {
        super.setWriteIdleTimeout(idleTimeout);
        return this;
    }

    public MqttClientSessionOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        super.setIdleTimeoutUnit(idleTimeoutUnit);
        return this;
    }

    public MqttClientSessionOptions removeEnabledCipherSuite(String suite) {
        super.removeEnabledCipherSuite(suite);
        return this;
    }

    public MqttClientSessionOptions removeEnabledSecureTransportProtocol(String protocol) {
        super.removeEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public MqttClientSessionOptions setUseAlpn(boolean useAlpn) {
        super.setUseAlpn(useAlpn);
        return this;
    }

    public MqttClientSessionOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        super.setSslEngineOptions(sslEngineOptions);
        return this;
    }

    public MqttClientSessionOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        super.setJdkSslEngineOptions(sslEngineOptions);
        return this;
    }

    public MqttClientSessionOptions setTcpFastOpen(boolean tcpFastOpen) {
        super.setTcpFastOpen(tcpFastOpen);
        return this;
    }

    public MqttClientSessionOptions setTcpCork(boolean tcpCork) {
        super.setTcpCork(tcpCork);
        return this;
    }

    public MqttClientSessionOptions setTcpQuickAck(boolean tcpQuickAck) {
        super.setTcpQuickAck(tcpQuickAck);
        return this;
    }

    public ClientOptionsBase setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        super.setOpenSslEngineOptions(sslEngineOptions);
        return this;
    }

    public MqttClientSessionOptions setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    public MqttClientSessionOptions setMetricsName(String metricsName) {
        super.setMetricsName(metricsName);
        return this;
    }

    public MqttClientSessionOptions setReconnectAttempts(int attempts) {
        super.setReconnectAttempts(attempts);
        return this;
    }

    public MqttClientSessionOptions setReconnectInterval(long interval) {
        super.setReconnectInterval(interval);
        return this;
    }

    public MqttClientSessionOptions setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        if ("NONE".equalsIgnoreCase(hostnameVerificationAlgorithm)) {
            super.setHostnameVerificationAlgorithm("");
        } else {
            super.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
        }
        return this;
    }

    public MqttClientSessionOptions setApplicationLayerProtocols(List<String> protocols) {
        super.setApplicationLayerProtocols(protocols);
        return this;
    }

    public MqttClientSessionOptions setLogActivity(boolean logEnabled) {
        super.setLogActivity(logEnabled);
        return this;
    }

    public MqttClientSessionOptions setActivityLogDataFormat(ByteBufFormat activityLogDataFormat) {
        super.setActivityLogDataFormat(activityLogDataFormat);
        return this;
    }

    public MqttClientSessionOptions setProxyOptions(ProxyOptions proxyOptions) {
        super.setProxyOptions(proxyOptions);
        return this;
    }

    public MqttClientSessionOptions setNonProxyHosts(List<String> nonProxyHosts) {
        super.setNonProxyHosts(nonProxyHosts);
        return this;
    }

    public MqttClientSessionOptions addNonProxyHost(String nonProxyHost) {
        super.addNonProxyHost(nonProxyHost);
        return this;
    }

    public MqttClientSessionOptions setLocalAddress(String localAddress) {
        super.setLocalAddress(localAddress);
        return this;
    }

    public MqttClientSessionOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
        return this;
    }

    public MqttClientSessionOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        super.setSslHandshakeTimeout(sslHandshakeTimeout);
        return this;
    }

    public MqttClientSessionOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
        return this;
    }

    public ClientOptionsBase setTcpUserTimeout(int tcpUserTimeout) {
        super.setTcpUserTimeout(tcpUserTimeout);
        return this;
    }
}

