/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt.session;

import io.smallrye.reactive.messaging.mqtt.i18n.MqttExceptions;

public enum RequestedQoS {
    QOS_0(0),
    QOS_1(1);

    private final int value;

    private RequestedQoS(int value) {
        this.value = value;
    }

    public int toInteger() {
        return this.value;
    }

    public static RequestedQoS valueOf(Integer qos) {
        if (qos == null) {
            return null;
        }
        switch (qos) {
            case 0: {
                return QOS_0;
            }
            case 1: {
                return QOS_1;
            }
        }
        throw MqttExceptions.ex.illegalArgumentInvalidQoS(qos);
    }
}

