/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.impl;

import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.impl.ConnectorConfig;
import java.util.HashSet;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;

public class ConcurrencyConnectorConfig
extends ConnectorConfig {
    public static final String CONCURRENCY_PROPERTY_KEY = "concurrency";
    public static final String CONCURRENCY_CONFIG_SEPARATOR = "$";
    private final String indexedChannelPrefix;
    private final String indexedChannel;

    public static Optional<Integer> getConcurrency(Config connectorConfig) {
        return connectorConfig.getOptionalValue(CONCURRENCY_PROPERTY_KEY, Integer.class);
    }

    public static Optional<Integer> getConcurrency(String channel, Config rootConfig) {
        String configKey = ConcurrencyConnectorConfig.channelPrefix("mp.messaging.incoming.", channel) + CONCURRENCY_PROPERTY_KEY;
        return rootConfig.getOptionalValue(configKey, Integer.class);
    }

    public static String stripChannelNameOfSeparator(String name) {
        return name.substring(0, name.indexOf(CONCURRENCY_CONFIG_SEPARATOR));
    }

    public static boolean isConcurrencyChannelName(String name) {
        return name.contains(CONCURRENCY_CONFIG_SEPARATOR);
    }

    public ConcurrencyConnectorConfig(String prefix, Config overall, String channel, int index) {
        super(prefix, overall, channel);
        this.indexedChannel = channel + CONCURRENCY_CONFIG_SEPARATOR + index;
        this.indexedChannelPrefix = ConcurrencyConnectorConfig.channelPrefix(prefix, this.indexedChannel);
    }

    public String getIndexedChannel() {
        return this.indexedChannel;
    }

    public ConcurrencyConnectorConfig(ConnectorConfig config, int index) {
        this(config.prefix, config.overall, config.name, index);
    }

    public String indexedChannelKey(String propertyName) {
        return this.indexedChannelPrefix + propertyName;
    }

    @Override
    public <T> T getValue(String propertyName, Class<T> propertyType) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return this.convert(this.indexedChannel, propertyType);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return this.convert(this.connector, propertyType);
        }
        Optional maybeResult = this.overall.getOptionalValue(this.indexedChannelKey(propertyName), propertyType);
        if (maybeResult.isPresent()) {
            return maybeResult.get();
        }
        maybeResult = this.overall.getOptionalValue(this.channelKey(propertyName), propertyType);
        if (maybeResult.isPresent()) {
            return maybeResult.get();
        }
        maybeResult = this.overall.getOptionalValue(this.connectorKey(propertyName), propertyType);
        if (maybeResult.isPresent()) {
            return maybeResult.get();
        }
        throw ProviderExceptions.ex.noSuchElementForAttribute(propertyName, this.name, this.channelKey(propertyName), this.connectorKey(propertyName));
    }

    @Override
    public ConfigValue getConfigValue(String propertyName) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return new ConnectorConfig.ConfigValueImpl("channel-name", this.indexedChannel);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return new ConnectorConfig.ConfigValueImpl("connector", this.connector);
        }
        ConfigValue value = this.overall.getConfigValue(this.indexedChannelKey(propertyName));
        if (value.getRawValue() != null) {
            return value;
        }
        value = this.overall.getConfigValue(this.channelKey(propertyName));
        if (value.getRawValue() == null) {
            return this.overall.getConfigValue(this.connectorKey(propertyName));
        }
        return value;
    }

    @Override
    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return this.convertOptional(this.indexedChannel, propertyType);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return this.convertOptional(this.connector, propertyType);
        }
        Optional maybe = this.overall.getOptionalValue(this.indexedChannelKey(propertyName), propertyType);
        if (maybe.isPresent()) {
            return maybe;
        }
        maybe = this.overall.getOptionalValue(this.channelKey(propertyName), propertyType);
        return maybe.isPresent() ? maybe : this.overall.getOptionalValue(this.connectorKey(propertyName), propertyType);
    }

    @Override
    public Iterable<String> getPropertyNames() {
        String prefix = this.channelPrefix;
        String prefixAlpha = this.toAlpha(prefix);
        String prefixAlphaUpper = prefixAlpha.toUpperCase();
        String indexedPrefix = this.indexedChannelPrefix;
        String indexedPrefixAlpha = this.toAlpha(indexedPrefix);
        String indexedPrefixAlphaUpper = indexedPrefixAlpha.toUpperCase();
        String connectorPrefix = "mp.messaging.connector." + this.connector + ".";
        String connectorPrefixAlpha = this.toAlpha(connectorPrefix);
        String connectorPrefixAlphaUpper = connectorPrefixAlpha.toUpperCase();
        HashSet<String> names = new HashSet<String>();
        for (String name : this.overall.getPropertyNames()) {
            String computed;
            if (name.startsWith(connectorPrefix)) {
                computed = name.substring(connectorPrefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorPrefixAlpha)) {
                computed = name.substring(connectorPrefixAlpha.length());
                if (!this.nameExists(connectorPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorPrefixAlphaUpper)) {
                computed = name.substring(connectorPrefixAlphaUpper.length());
                if (!this.nameExists(connectorPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(indexedPrefix)) {
                computed = name.substring(indexedPrefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(indexedPrefixAlpha)) {
                computed = name.substring(indexedPrefixAlpha.length());
                if (!this.nameExists(indexedPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(indexedPrefixAlphaUpper)) {
                computed = name.substring(indexedPrefixAlphaUpper.length());
                if (!this.nameExists(indexedPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(prefix)) {
                computed = name.substring(prefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(prefixAlpha)) {
                computed = name.substring(prefixAlpha.length());
                if (!this.nameExists(prefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (!name.startsWith(prefixAlphaUpper) || !this.nameExists(prefix + (computed = name.substring(prefixAlphaUpper.length())))) continue;
            names.add(computed);
        }
        names.add("channel-name");
        return names;
    }
}

