/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String[] NO_STRINGS = new String[0];
    private static final Pattern ITEM_PATTERN = Pattern.compile("(,+)|([^\\\\,]+)|\\\\(.)");

    public static String[] split(String text) {
        if (text == null || text.isEmpty()) {
            return NO_STRINGS;
        }
        Matcher matcher = ITEM_PATTERN.matcher(text);
        String item = null;
        StringBuilder b = null;
        ArrayList<String> list = new ArrayList<String>(4);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                if (item == null) continue;
                list.add(item);
                item = null;
                continue;
            }
            if (matcher.group(2) != null) {
                assert (item == null) : "Regular expression matching malfunctioned";
                item = matcher.group(2);
                continue;
            }
            if (matcher.group(3) != null) {
                if (b == null) {
                    b = new StringBuilder();
                }
                if (item != null) {
                    b.append(item);
                    item = null;
                }
                b.append(matcher.group(3));
                while (matcher.find() && matcher.group(1) == null) {
                    if (matcher.group(2) != null) {
                        b.append(matcher.group(2));
                        continue;
                    }
                    if (matcher.group(3) != null) {
                        b.append(matcher.group(3));
                        continue;
                    }
                    throw new IllegalStateException();
                }
                list.add(b.toString());
                b.setLength(0);
                continue;
            }
            throw new IllegalStateException();
        }
        if (item != null) {
            list.add(item);
        }
        return list.toArray(NO_STRINGS);
    }
}

