/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.rate.limit;

import io.smallrye.faulttolerance.api.RateLimitException;
import io.smallrye.faulttolerance.api.RateLimitType;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.rate.limit.RateLimit;
import io.smallrye.faulttolerance.core.rate.limit.RateLimitEvents;
import io.smallrye.faulttolerance.core.rate.limit.RateLimitLogger;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CompletionStageRateLimit<V>
extends RateLimit<CompletionStage<V>> {
    public CompletionStageRateLimit(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, int maxInvocations, long timeWindowInMillis, long minSpacingInMillis, RateLimitType type, Stopwatch stopwatch) {
        super(delegate, description, maxInvocations, timeWindowInMillis, minSpacingInMillis, type, stopwatch);
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) throws Exception {
        RateLimitLogger.LOG.trace("CompletionStageRateLimit started");
        try {
            CompletionStage<V> completionStage = this.doApply(ctx);
            return completionStage;
        }
        finally {
            RateLimitLogger.LOG.trace("CompletionStageRateLimit finished");
        }
    }

    private CompletionStage<V> doApply(InvocationContext<CompletionStage<V>> ctx) {
        CompletableFuture result = new CompletableFuture();
        if (this.timeWindow.record()) {
            try {
                RateLimitLogger.LOG.trace("Task permitted by rate limit");
                ctx.fireEvent(RateLimitEvents.DecisionMade.PERMITTED);
                CompletionStages.propagateCompletion(this.delegate.apply(ctx), result);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        } else {
            RateLimitLogger.LOG.debugf("%s rate limit exceeded", this.description);
            ctx.fireEvent(RateLimitEvents.DecisionMade.REJECTED);
            result.completeExceptionally((Throwable)new RateLimitException(this.description + " rate limit exceeded"));
        }
        return result;
    }
}

