/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.spi.EventingService;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

@Priority(value=0)
public class TracingService
implements EventingService {
    private Logger LOG = Logger.getLogger(TracingService.class);
    private static final Map<String, Span> spans = new ConcurrentHashMap<String, Span>();
    private static final Map<String, Scope> scopes = new ConcurrentHashMap<String, Scope>();
    private Tracer tracer;
    private static final String UNDERSCORE = "_";
    private static final String EMPTY = "";
    private static final String PREFIX = "GraphQL";

    public void beforeExecute(Context context) {
        String operationName = TracingService.getOperationName(context);
        Span span = this.getTracer().spanBuilder(operationName).setAttribute("graphql.executionId", context.getExecutionId()).setAttribute("graphql.operationType", this.getOperationNameString(context.getRequestedOperationTypes())).setAttribute("graphql.operationName", context.getOperationName().orElse(EMPTY)).startSpan();
        this.LOG.trace((Object)("Start span " + span.getSpanContext().getSpanId()));
        spans.put(context.getExecutionId(), span);
        scopes.put(context.getExecutionId(), span.makeCurrent());
    }

    public void afterExecute(Context context) {
        Span span = spans.remove(context.getExecutionId());
        if (span != null) {
            this.LOG.trace((Object)("Finish span " + span.getSpanContext().getSpanId()));
            scopes.remove(context.getExecutionId()).close();
            span.end();
        }
    }

    public void errorExecute(Context context, Throwable t) {
        Span span = spans.remove(context.getExecutionId());
        if (span != null) {
            this.LOG.trace((Object)("Exceptionally finish span " + span.getSpanContext().getSpanId()));
            span.recordException(t);
            span.setStatus(StatusCode.ERROR);
            scopes.remove(context.getExecutionId()).close();
            span.end();
        }
    }

    public String getConfigKey() {
        return "smallrye.graphql.tracing.enabled";
    }

    private Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)CDI.current().select(Tracer.class, new Annotation[0]).get();
        }
        return this.tracer;
    }

    private static String getOperationName(Context context) {
        if (context.getOperationName().isPresent()) {
            return "GraphQL:" + (String)context.getOperationName().get();
        }
        return PREFIX;
    }

    private String getOperationNameString(List<String> types) {
        return String.join((CharSequence)UNDERSCORE, types);
    }
}

