/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx;

import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.vertx.ssl.SSLTools;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import java.security.KeyStore;

public class VertxClientOptionsHelper {
    public static void applyConfigToVertxOptions(HttpClientOptions options, GraphQLClientConfiguration configuration) {
        VertxClientOptionsHelper.configure(options, configuration);
        TrustOptions tlsTrustStoreOptions = (TrustOptions)configuration.getTlsTrustStoreOptions();
        KeyCertOptions tlsKeyStoreOptions = (KeyCertOptions)configuration.getTlsKeyStoreOptions();
        if (tlsTrustStoreOptions != null) {
            options.setSsl(true);
            options.setTrustOptions(tlsTrustStoreOptions);
        } else if (options.getTrustStoreOptions() == null && configuration.getTrustStore() != null) {
            options.setSsl(true);
            JksOptions trustStoreOptions = new JksOptions();
            KeyStore trustStore = SSLTools.createKeyStore(configuration.getTrustStore(), configuration.getTrustStoreType(), configuration.getTrustStorePassword());
            trustStoreOptions.setValue(SSLTools.asBuffer(trustStore, configuration.getTrustStorePassword().toCharArray()));
            trustStoreOptions.setPassword(new String(configuration.getTrustStorePassword()));
            options.setTrustStoreOptions(trustStoreOptions);
        }
        if (tlsKeyStoreOptions != null) {
            options.setSsl(true);
            options.setKeyCertOptions(tlsKeyStoreOptions);
        } else if (options.getKeyStoreOptions() == null && configuration.getKeyStore() != null) {
            options.setSsl(true);
            JksOptions keyStoreOptions = new JksOptions();
            KeyStore keyStore = SSLTools.createKeyStore(configuration.getKeyStore(), configuration.getKeyStoreType(), configuration.getKeyStorePassword());
            keyStoreOptions.setValue(SSLTools.asBuffer(keyStore, configuration.getKeyStorePassword().toCharArray()));
            keyStoreOptions.setPassword(new String(configuration.getKeyStorePassword()));
            options.setKeyStoreOptions(keyStoreOptions);
        }
        if (options.getProxyOptions() == null && configuration.getProxyHost() != null) {
            ProxyOptions proxyOptions = new ProxyOptions();
            proxyOptions.setHost(configuration.getProxyHost());
            proxyOptions.setPort(configuration.getProxyPort().intValue());
            proxyOptions.setUsername(configuration.getProxyUsername());
            proxyOptions.setPassword(configuration.getProxyPassword());
            options.setProxyOptions(proxyOptions);
        }
        if (configuration.getMaxRedirects() != null) {
            options.setMaxRedirects(configuration.getMaxRedirects().intValue());
        }
    }

    private static void configure(HttpClientOptions options, GraphQLClientConfiguration graphQLClientConfiguration) {
        SSLOptions sslOptions;
        options.setForceSni(graphQLClientConfiguration.usesSni() != null && graphQLClientConfiguration.usesSni() != false);
        if (graphQLClientConfiguration.getHostnameVerificationAlgorithm() == null || graphQLClientConfiguration.getHostnameVerificationAlgorithm().equals("NONE")) {
            options.setVerifyHost(false);
        }
        if ((sslOptions = (SSLOptions)graphQLClientConfiguration.getSslOptions()) != null) {
            options.setSslHandshakeTimeout(sslOptions.getSslHandshakeTimeout());
            options.setSslHandshakeTimeoutUnit(sslOptions.getSslHandshakeTimeoutUnit());
            for (String suite : sslOptions.getEnabledCipherSuites()) {
                options.addEnabledCipherSuite(suite);
            }
            for (Buffer buffer : sslOptions.getCrlValues()) {
                options.addCrlValue(buffer);
            }
            options.setEnabledSecureTransportProtocols(sslOptions.getEnabledSecureTransportProtocols());
            options.setUseAlpn(sslOptions.isUseAlpn());
        }
    }
}

