/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.execution.datafetcher.helper.AbstractHelper;
import io.smallrye.graphql.execution.datafetcher.helper.ReflectionInvoker;
import io.smallrye.graphql.schema.model.AdaptWith;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.graphql.transformation.TransformException;
import io.smallrye.graphql.transformation.Transformer;
import java.util.Map;
import java.util.Set;

public class FieldHelper
extends AbstractHelper {
    private final Field field;
    private static final String KEY = "key";

    public FieldHelper(Field field) {
        this.field = field;
    }

    public Object transformOrAdaptResponse(Object argumentValue, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        return super.transformOrAdapt(argumentValue, this.field, dfe);
    }

    @Override
    Object singleTransform(Object argumentValue, Field field) throws AbstractDataFetcherException {
        if (!this.shouldTransform(field)) {
            return argumentValue;
        }
        return this.transformOutput(field, argumentValue);
    }

    @Override
    Object singleAdapting(Object argumentValue, Field field, DataFetchingEnvironment dfe) throws AbstractDataFetcherException {
        if (argumentValue == null) {
            return null;
        }
        if (field.isAdaptingWith()) {
            AdaptWith adaptWith = field.getAdaptWith();
            ReflectionInvoker reflectionInvoker = this.getReflectionInvokerForOutput(adaptWith);
            try {
                Object adaptedObject = reflectionInvoker.invoke(argumentValue);
                return adaptedObject;
            }
            catch (Exception ex) {
                SmallRyeGraphQLServerLogging.log.transformError(ex);
                throw new TransformException(ex, field, argumentValue);
            }
        }
        if (field.isAdaptingTo()) {
            return argumentValue.toString();
        }
        if (field.hasWrapper() && field.getWrapper().isMap()) {
            Object key = null;
            Map arguments = dfe.getArguments();
            if (arguments != null && arguments.size() > 0 && arguments.containsKey(KEY)) {
                key = arguments.get(KEY);
            }
            Set entrySet = this.mapAdapter.to((Map)argumentValue, key, field);
            return this.recursiveAdapting(entrySet, this.mapAdapter.getAdaptedField(field), dfe);
        }
        return argumentValue;
    }

    @Override
    protected Object afterRecursiveTransform(Object fieldValue, Field field, DataFetchingEnvironment dfe) {
        return fieldValue;
    }

    @Override
    protected Class<?> getArrayType(Field field) {
        return this.classloadingService.loadClass(field.getReference().getGraphQLClassName());
    }

    private Object transformOutput(Field field, Object object) throws AbstractDataFetcherException {
        if (object == null) {
            return null;
        }
        if (!this.shouldTransform(field)) {
            return object;
        }
        try {
            Transformer transformer = super.getTransformer(field);
            if (transformer == null) {
                return object;
            }
            return transformer.out(object);
        }
        catch (Exception e) {
            SmallRyeGraphQLServerLogging.log.transformError(e);
            throw new TransformException(e, field, object);
        }
    }
}

