/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import graphql.execution.Async;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DelegatingDataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.smallrye.graphql.spi.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FederationDataFetcher
implements DataFetcher<CompletableFuture<List<Object>>> {
    public static final String TYPENAME = "__typename";
    private final GraphQLObjectType queryType;
    private final GraphQLCodeRegistry codeRegistry;

    public FederationDataFetcher(GraphQLObjectType queryType, GraphQLCodeRegistry codeRegistry) {
        this.queryType = queryType;
        this.codeRegistry = codeRegistry;
    }

    public CompletableFuture<List<Object>> get(DataFetchingEnvironment environment) throws Exception {
        List reps = (List)environment.getArgument("representations");
        List representations = IntStream.range(0, reps.size()).boxed().map(i -> new Representation((Map)reps.get((int)i), (int)i)).collect(Collectors.toList());
        if (Config.get().isFederationBatchResolvingEnabled()) {
            Map<TypeAndArgumentNames, List<Representation>> repsWithPositionPerType = representations.stream().collect(Collectors.groupingBy(r -> r.typeAndArgumentNames));
            Map fieldDefinitions = repsWithPositionPerType.keySet().stream().collect(Collectors.toMap(Function.identity(), typeAndArgumentNames -> {
                GraphQLFieldDefinition batchDefinition = this.findBatchFieldDefinition((TypeAndArgumentNames)typeAndArgumentNames);
                if (batchDefinition == null) {
                    return this.findFieldDefinition((TypeAndArgumentNames)typeAndArgumentNames);
                }
                return batchDefinition;
            }));
            return FederationDataFetcher.sequence(repsWithPositionPerType.entrySet().stream().map(e -> {
                GraphQLFieldDefinition fieldDefinition = (GraphQLFieldDefinition)fieldDefinitions.get(e.getKey());
                if (this.getGraphqlTypeFromField(fieldDefinition) instanceof GraphQLList) {
                    return this.executeList(fieldDefinition, environment, (List)e.getValue());
                }
                return FederationDataFetcher.sequence(((List)e.getValue()).stream().map(r -> this.execute(fieldDefinition, environment, (Representation)r)).collect(Collectors.toList()));
            }).collect(Collectors.toList())).thenApply(l -> l.stream().flatMap(Collection::stream).sorted(Comparator.comparingInt(r -> r.position)).map(r -> r.Result).collect(Collectors.toList()));
        }
        HashMap cache = new HashMap();
        return FederationDataFetcher.sequence(representations.stream().map(rep -> this.fetchEntities(environment, (Representation)rep, cache.computeIfAbsent(rep.typeAndArgumentNames, this::findFieldDefinition))).collect(Collectors.toList())).thenApply(l -> l.stream().map(r -> r.Result).collect(Collectors.toList()));
    }

    private GraphQLFieldDefinition findBatchFieldDefinition(TypeAndArgumentNames typeAndArgumentNames) {
        for (GraphQLFieldDefinition field : this.queryType.getFields()) {
            if (!this.matchesReturnTypeList(field, typeAndArgumentNames.type) || !this.matchesArguments(typeAndArgumentNames, field)) continue;
            return field;
        }
        return null;
    }

    private GraphQLFieldDefinition findFieldDefinition(TypeAndArgumentNames typeAndArgumentNames) {
        for (GraphQLFieldDefinition field : this.queryType.getFields()) {
            if (!this.matchesReturnType(field, typeAndArgumentNames.type) || !this.matchesArguments(typeAndArgumentNames, field)) continue;
            return field;
        }
        throw new RuntimeException("no query found for " + typeAndArgumentNames.type + " by " + typeAndArgumentNames.argumentNames);
    }

    private CompletableFuture<ResultObject> fetchEntities(DataFetchingEnvironment env, Representation representation, GraphQLFieldDefinition field) {
        return this.execute(field, env, representation);
    }

    private boolean matchesReturnType(GraphQLFieldDefinition field, String typename) {
        GraphQLType returnType = this.getGraphqlTypeFromField(field);
        return returnType instanceof GraphQLNamedSchemaElement && ((GraphQLNamedSchemaElement)returnType).getName().equals(typename);
    }

    private boolean matchesReturnTypeList(GraphQLFieldDefinition field, String typename) {
        GraphQLType listType = this.getGraphqlTypeFromField(field);
        if (listType instanceof GraphQLList) {
            GraphQLType returnType = ((GraphQLList)listType).getOriginalWrappedType();
            return returnType instanceof GraphQLNamedSchemaElement && ((GraphQLNamedSchemaElement)returnType).getName().equals(typename);
        }
        return false;
    }

    private GraphQLType getGraphqlTypeFromField(GraphQLFieldDefinition field) {
        GraphQLOutputType type = field.getType();
        if (type instanceof GraphQLNonNull) {
            type = ((GraphQLNonNull)type).getOriginalWrappedType();
        }
        return type;
    }

    private boolean matchesArguments(TypeAndArgumentNames typeAndArgumentNames, GraphQLFieldDefinition field) {
        Set argumentNames = field.getArguments().stream().map(GraphQLArgument::getName).collect(Collectors.toSet());
        return argumentNames.equals(typeAndArgumentNames.argumentNames);
    }

    private CompletableFuture<List<ResultObject>> executeList(GraphQLFieldDefinition field, DataFetchingEnvironment env, List<Representation> representations) {
        DataFetcher dataFetcher = this.codeRegistry.getDataFetcher(this.queryType, field);
        HashMap arguments = new HashMap();
        representations.forEach(r -> r.arguments.forEach((argumentName, argumentValue) -> arguments.computeIfAbsent(argumentName, ignore -> new ArrayList()).add(argumentValue)));
        final HashMap argumentsAsObject = new HashMap(arguments);
        DelegatingDataFetchingEnvironment argsEnv = new DelegatingDataFetchingEnvironment(env){

            public Map<String, Object> getArguments() {
                return argumentsAsObject;
            }

            public boolean containsArgument(String name) {
                return argumentsAsObject.containsKey(name);
            }

            public <T> T getArgument(String name) {
                return (T)argumentsAsObject.get(name);
            }

            public <T> T getArgumentOrDefault(String name, T defaultValue) {
                return this.containsArgument(name) ? this.getArgument(name) : defaultValue;
            }
        };
        try {
            return Async.toCompletableFuture((Object)dataFetcher.get((DataFetchingEnvironment)argsEnv)).thenApply(results -> {
                List resultList;
                if (results instanceof DataFetcherResult) {
                    resultList = (List)((DataFetcherResult)results).getData();
                } else if (results instanceof List) {
                    resultList = (List)results;
                } else {
                    throw new IllegalStateException("Result of batchDataFetcher for Field " + field.getName() + " needs to be a list" + results.toString());
                }
                if (resultList.size() != representations.size()) {
                    throw new IllegalStateException("Size of result list " + resultList.size() + " needs to be equal to size of arguments " + representations.size());
                }
                return IntStream.range(0, resultList.size()).boxed().map(i -> new ResultObject(resultList.get((int)i), ((Representation)representations.get((int)i.intValue())).position)).collect(Collectors.toList());
            });
        }
        catch (Exception e) {
            throw new RuntimeException("can't fetch data from " + field, e);
        }
    }

    private CompletableFuture<ResultObject> execute(GraphQLFieldDefinition field, DataFetchingEnvironment env, final Representation representation) {
        DataFetcher dataFetcher = this.codeRegistry.getDataFetcher(this.queryType, field);
        DelegatingDataFetchingEnvironment argsEnv = new DelegatingDataFetchingEnvironment(env){

            public Map<String, Object> getArguments() {
                return representation.arguments;
            }

            public boolean containsArgument(String name) {
                return representation.arguments.containsKey(name);
            }

            public <T> T getArgument(String name) {
                return (T)representation.arguments.get(name);
            }

            public <T> T getArgumentOrDefault(String name, T defaultValue) {
                return this.containsArgument(name) ? this.getArgument(name) : defaultValue;
            }
        };
        try {
            return Async.toCompletableFuture((Object)dataFetcher.get((DataFetchingEnvironment)argsEnv)).thenApply(o -> new ResultObject(o, representation.position));
        }
        catch (Exception e) {
            throw new RuntimeException("can't fetch data from " + field, e);
        }
    }

    static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> com) {
        return CompletableFuture.allOf(com.toArray(new CompletableFuture[0])).thenApply(v -> com.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    static class TypeAndArgumentNames {
        final Set<String> argumentNames;
        final String type;

        public TypeAndArgumentNames(Set<String> argumentNames, String type) {
            this.argumentNames = argumentNames;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeAndArgumentNames that = (TypeAndArgumentNames)o;
            return Objects.equals(this.argumentNames, that.argumentNames) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.argumentNames, this.type);
        }
    }

    static class Representation {
        final Map<String, Object> arguments;
        final int position;
        final TypeAndArgumentNames typeAndArgumentNames;

        public Representation(Map<String, Object> arguments, int position) {
            this.arguments = arguments;
            this.position = position;
            HashSet<String> argumentNames = new HashSet<String>(arguments.keySet());
            argumentNames.remove(FederationDataFetcher.TYPENAME);
            this.typeAndArgumentNames = new TypeAndArgumentNames(argumentNames, (String)arguments.get(FederationDataFetcher.TYPENAME));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Representation that = (Representation)o;
            return this.position == that.position && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.typeAndArgumentNames, that.typeAndArgumentNames);
        }

        public int hashCode() {
            return Objects.hash(this.arguments, this.position, this.typeAndArgumentNames);
        }
    }

    static class ResultObject {
        final Object Result;
        final int position;

        public ResultObject(Object result, int position) {
            this.Result = result;
            this.position = position;
        }
    }
}

