/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.config;

import io.smallrye.jwt.KeyFormat;
import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.ResourceUtils;
import io.smallrye.jwt.SmallryeJwtUtils;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.config.ConfigLogging;
import io.smallrye.jwt.config.ConfigMessages;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Dependent
public class JWTAuthContextInfoProvider {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_SCHEME = "Bearer";
    private static final String NONE = "NONE";
    private static final String DEFAULT_GROUPS_SEPARATOR = " ";
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey", defaultValue="NONE")
    private Optional<String> mpJwtPublicKey;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.issuer", defaultValue="NONE")
    private String mpJwtIssuer;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.location", defaultValue="NONE")
    private Optional<String> mpJwtLocation;
    @Inject
    @ConfigProperty(name="smallrye.jwt.decrypt.key.location")
    private Optional<String> decryptionKeyLocation;
    @Inject
    @ConfigProperty(name="smallrye.jwt.decrypt.algorithm", defaultValue="RSA_OAEP")
    private KeyEncryptionAlgorithm keyEncryptionAlgorithm;
    @Deprecated
    @Inject
    @ConfigProperty(name="mp.jwt.verify.requireiss", defaultValue="true")
    private Optional<Boolean> mpJwtRequireIss;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.header", defaultValue="Authorization")
    private String tokenHeader;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.cookie")
    private Optional<String> tokenCookie;
    @Inject
    @ConfigProperty(name="smallrye.jwt.always-check-authorization", defaultValue="false")
    private boolean alwaysCheckAuthorization;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.kid")
    private Optional<String> tokenKeyId;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.decryption.kid")
    private Optional<String> tokenDecryptionKeyId;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.schemes", defaultValue="Bearer")
    private Optional<String> tokenSchemes;
    @Inject
    @ConfigProperty(name="smallrye.jwt.require.named-principal", defaultValue="false")
    private Optional<Boolean> requireNamedPrincipal;
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.sub")
    private Optional<String> defaultSubClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.sub")
    private Optional<String> subPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.groups")
    private Optional<String> defaultGroupsClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.groups")
    private Optional<String> groupsPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.groups-separator", defaultValue=" ")
    private String groupsSeparator;
    @Inject
    @ConfigProperty(name="smallrye.jwt.expiration.grace", defaultValue="60")
    private Optional<Integer> expGracePeriodSecs;
    @Inject
    @ConfigProperty(name="smallrye.jwt.time-to-live")
    Optional<Long> maxTimeToLiveSecs;
    @Inject
    @ConfigProperty(name="smallrye.jwt.jwks.refresh-interval", defaultValue="60")
    private Optional<Integer> jwksRefreshInterval;
    @Inject
    @ConfigProperty(name="smallrye.jwt.jwks.forced-refresh-interval", defaultValue="30")
    private int forcedJwksRefreshInterval;
    @Inject
    @ConfigProperty(name="smallrye.jwt.whitelist.algorithms")
    @Deprecated
    private Optional<String> whitelistAlgorithms;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.algorithm", defaultValue="RS256")
    private Optional<SignatureAlgorithm> signatureAlgorithm;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.key-format", defaultValue="ANY")
    private KeyFormat keyFormat;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.relax-key-validation", defaultValue="false")
    private boolean relaxVerificationKeyValidation;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.aud")
    Optional<Set<String>> expectedAudience;
    @Inject
    @ConfigProperty(name="smallrye.jwt.required.claims")
    Optional<Set<String>> requiredClaims;

    public static JWTAuthContextInfoProvider createWithKey(String publicKey, String issuer) {
        return JWTAuthContextInfoProvider.create(publicKey, NONE, issuer);
    }

    public static JWTAuthContextInfoProvider createWithKeyLocation(String publicKeyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, publicKeyLocation, issuer);
    }

    private static JWTAuthContextInfoProvider create(String publicKey, String publicKeyLocation, String issuer) {
        JWTAuthContextInfoProvider provider = new JWTAuthContextInfoProvider();
        provider.mpJwtPublicKey = Optional.of(publicKey);
        provider.mpJwtLocation = Optional.of(publicKeyLocation);
        provider.mpJwtIssuer = issuer;
        provider.decryptionKeyLocation = Optional.empty();
        provider.mpJwtRequireIss = Optional.of(Boolean.TRUE);
        provider.tokenHeader = AUTHORIZATION_HEADER;
        provider.tokenCookie = Optional.empty();
        provider.tokenKeyId = Optional.empty();
        provider.tokenDecryptionKeyId = Optional.empty();
        provider.tokenSchemes = Optional.of(BEARER_SCHEME);
        provider.requireNamedPrincipal = Optional.of(Boolean.TRUE);
        provider.defaultSubClaim = Optional.empty();
        provider.subPath = Optional.empty();
        provider.defaultGroupsClaim = Optional.empty();
        provider.groupsPath = Optional.empty();
        provider.expGracePeriodSecs = Optional.of(60);
        provider.maxTimeToLiveSecs = Optional.empty();
        provider.jwksRefreshInterval = Optional.empty();
        provider.forcedJwksRefreshInterval = 30;
        provider.signatureAlgorithm = Optional.of(SignatureAlgorithm.RS256);
        provider.keyEncryptionAlgorithm = KeyEncryptionAlgorithm.RSA_OAEP;
        provider.keyFormat = KeyFormat.ANY;
        provider.expectedAudience = Optional.empty();
        provider.groupsSeparator = DEFAULT_GROUPS_SEPARATOR;
        provider.requiredClaims = Optional.empty();
        return provider;
    }

    @Produces
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        ConfigLogging.log.configValues(this.mpJwtPublicKey.orElse("missing"), this.mpJwtIssuer, this.mpJwtLocation.orElse("missing"));
        JWTAuthContextInfo contextInfo = new JWTAuthContextInfo();
        if (this.mpJwtIssuer != null && !this.mpJwtIssuer.equals(NONE)) {
            contextInfo.setIssuedBy(this.mpJwtIssuer.trim());
        } else {
            contextInfo.setRequireIssuer(false);
        }
        contextInfo.setRequireIssuer(this.mpJwtRequireIss.orElse(true));
        if (this.mpJwtPublicKey.isPresent() && !NONE.equals(this.mpJwtPublicKey.get())) {
            contextInfo.setPublicKeyContent(this.mpJwtPublicKey.get());
        } else if (this.mpJwtLocation.isPresent() && !NONE.equals(this.mpJwtLocation.get())) {
            String mpJwtLocationTrimmed = this.mpJwtLocation.get().trim();
            if (mpJwtLocationTrimmed.startsWith("http")) {
                contextInfo.setPublicKeyLocation(mpJwtLocationTrimmed);
            } else {
                try {
                    contextInfo.setPublicKeyContent(ResourceUtils.readResource(mpJwtLocationTrimmed));
                    if (contextInfo.getPublicKeyContent() == null) {
                        throw ConfigMessages.msg.invalidPublicKeyLocation();
                    }
                }
                catch (IOException ex) {
                    throw ConfigMessages.msg.readingPublicKeyLocationFailed(ex);
                }
            }
        }
        if (this.decryptionKeyLocation.isPresent() && !NONE.equals(this.decryptionKeyLocation.get())) {
            String decryptionKeyLocationTrimmed = this.decryptionKeyLocation.get().trim();
            if (decryptionKeyLocationTrimmed.startsWith("http")) {
                contextInfo.setDecryptionKeyLocation(decryptionKeyLocationTrimmed);
            } else {
                try {
                    contextInfo.setDecryptionKeyContent(ResourceUtils.readResource(decryptionKeyLocationTrimmed));
                    if (contextInfo.getDecryptionKeyContent() == null) {
                        throw ConfigMessages.msg.invalidDecryptKeyLocation();
                    }
                }
                catch (IOException ex) {
                    throw ConfigMessages.msg.readingDecryptKeyLocationFailed(ex);
                }
            }
        }
        if (this.tokenHeader != null) {
            contextInfo.setTokenHeader(this.tokenHeader);
        }
        contextInfo.setAlwaysCheckAuthorization(this.alwaysCheckAuthorization);
        contextInfo.setTokenKeyId(this.tokenKeyId.orElse(null));
        contextInfo.setTokenDecryptionKeyId(this.tokenDecryptionKeyId.orElse(null));
        contextInfo.setRequireNamedPrincipal((Boolean)this.requireNamedPrincipal.orElse(null));
        SmallryeJwtUtils.setContextTokenCookie(contextInfo, this.tokenCookie);
        SmallryeJwtUtils.setTokenSchemes(contextInfo, this.tokenSchemes);
        contextInfo.setDefaultSubjectClaim(this.defaultSubClaim.orElse(null));
        SmallryeJwtUtils.setContextSubPath(contextInfo, this.subPath);
        contextInfo.setDefaultGroupsClaim(this.defaultGroupsClaim.orElse(null));
        SmallryeJwtUtils.setContextGroupsPath(contextInfo, this.groupsPath);
        contextInfo.setExpGracePeriodSecs((Integer)this.expGracePeriodSecs.orElse(null));
        contextInfo.setMaxTimeToLiveSecs(this.maxTimeToLiveSecs.orElse(null));
        contextInfo.setJwksRefreshInterval(this.jwksRefreshInterval.orElse(null));
        contextInfo.setForcedJwksRefreshInterval(this.forcedJwksRefreshInterval);
        if (this.signatureAlgorithm.orElse(null) == SignatureAlgorithm.HS256) {
            throw ConfigMessages.msg.hs256NotSupported();
        }
        contextInfo.setSignatureAlgorithm(this.signatureAlgorithm.orElse(SignatureAlgorithm.RS256));
        contextInfo.setKeyEncryptionAlgorithm(this.keyEncryptionAlgorithm);
        contextInfo.setKeyFormat(this.keyFormat);
        contextInfo.setExpectedAudience(this.expectedAudience.orElse(null));
        contextInfo.setGroupsSeparator(this.groupsSeparator);
        contextInfo.setRequiredClaims(this.requiredClaims.orElse(null));
        contextInfo.setRelaxVerificationKeyValidation(this.relaxVerificationKeyValidation);
        return Optional.of(contextInfo);
    }

    protected void decodeMpJwtPublicKey(JWTAuthContextInfo contextInfo) {
        if (!this.mpJwtPublicKey.isPresent() || NONE.equals(this.mpJwtPublicKey.get())) {
            return;
        }
        try {
            RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodeJWKSPublicKey(this.mpJwtPublicKey.get());
            contextInfo.setSignerKey(pk);
            ConfigLogging.log.publicKeyParsedAsJwk();
        }
        catch (Exception e) {
            ConfigLogging.log.parsingPublicKeyAsJwkFailed(e.getMessage());
            try {
                RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodePublicKey(this.mpJwtPublicKey.get());
                contextInfo.setSignerKey(pk);
                ConfigLogging.log.publicKeyParsedAsPem();
            }
            catch (Exception e1) {
                throw ConfigMessages.msg.parsingPublicKeyFailed(e1);
            }
        }
    }

    public Optional<String> getMpJwtPublicKey() {
        return this.mpJwtPublicKey;
    }

    public String getMpJwtIssuer() {
        return this.mpJwtIssuer;
    }

    public Optional<String> getMpJwtLocation() {
        return this.mpJwtLocation;
    }

    public Optional<Boolean> getMpJwtRequireIss() {
        return this.mpJwtRequireIss;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public Optional<String> getTokenCookie() {
        return this.tokenCookie;
    }

    public boolean isAlwaysCheckAuthorization() {
        return this.alwaysCheckAuthorization;
    }

    public Optional<String> getTokenKeyId() {
        return this.tokenKeyId;
    }

    public Optional<String> getTokenSchemes() {
        return this.tokenSchemes;
    }

    public Optional<Integer> getExpGracePeriodSecs() {
        return this.expGracePeriodSecs;
    }

    public Optional<Long> getMaxTimeToLiveSecs() {
        return this.maxTimeToLiveSecs;
    }

    public Optional<Integer> getJwksRefreshInterval() {
        return this.jwksRefreshInterval;
    }

    public int getForcedJwksRefreshInterval() {
        return this.forcedJwksRefreshInterval;
    }

    public Optional<String> getDefaultGroupsClaim() {
        return this.defaultGroupsClaim;
    }

    public Optional<String> getGroupsPath() {
        return this.groupsPath;
    }

    public String getGroupsSeparator() {
        return this.groupsSeparator;
    }

    public Optional<String> getSubjectPath() {
        return this.subPath;
    }

    public Optional<String> getDefaultSubjectClaim() {
        return this.defaultSubClaim;
    }

    @Deprecated
    public Optional<String> getWhitelistAlgorithms() {
        return this.whitelistAlgorithms;
    }

    public Optional<SignatureAlgorithm> getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public KeyFormat getKeyFormat() {
        return this.keyFormat;
    }

    public Optional<Set<String>> getExpectedAudience() {
        return this.expectedAudience;
    }

    public Optional<Set<String>> getRequiredClaims() {
        return this.requiredClaims;
    }

    public boolean isRelaxVerificationKeyValidation() {
        return this.relaxVerificationKeyValidation;
    }

    @Produces
    @ApplicationScoped
    public JWTAuthContextInfo getContextInfo() {
        return this.getOptionalContextInfo().get();
    }
}

